<?php
$breadcrumbs = [
    [
        'text' => t__('Updates')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Updates'),
    'category' => 'settings.updates',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section
  x-data="{
        inProcess: false,
        checking: false,
        isNeedUpdate: <?php echo isNeedUpdate() ? 'true' : 'false' ?>,
        currentVersion: '<?php echo VERSION; ?>',
        latestVersion: '<?php echo latestVersion(); ?>',
        updateLeaderOS() {
            this.inProcess = true;
            return $request('/dashboard/updates')
                .then(response => response.data)
                .then(result => {
                    this.inProcess = false;
                    if (result.status === true) {
                        this.isNeedUpdate = false;
                        this.currentVersion = this.latestVersion;
                        return this.$dispatch('open-alert', {
                            type: 'success',
                            title: lang.alert_title_success,
                            message: lang.update_success
                        })
                    }
                    return this.$dispatch('open-alert', {
                        type: 'error',
                        title: lang.alert_title_error,
                        message: lang.update_failed
                    })
                });
        },
        checkUpdate() {
            this.checking = true;
            return $request('/dashboard/updates/check', null, 'GET')
                .then(response => response.data)
                .then(result => {
                    this.checking = false;
                    this.isNeedUpdate = result.needUpdate;
                    this.latestVersion = result.version;
                });
        }
    }"
  class="tight-container los-container"
>
    <div>
		    <div class="los-page-heading">
	        <h1 class="text-gray-950 !text-[1.625rem]]">
		        <?php e__('Updates') ?>
	        </h1>
	        <div class="flex gap-2">
		        <a href="<?php echo leaderosHelpUrl() ?>/settings/updates" class="btn btn-dark" target="_blank">
			        <?php e__('Help') ?>
		        </a>
	        </div>
        </div>
        <div class="mt-8 flex justify-between items-center">
            <div class="flex gap-5 items-center">
                <div class="relative center w-16 h-16 card">
                    <i class="stroke-gray-800 w-10 h-10" data-feather="refresh-2"></i>

                    <div x-show="!isNeedUpdate" class="absolute -bottom-1.5 -right-1.5 w-6 h-6 center bg-emerald-500 rounded-xl mx-auto">
                      <svg class="w-4 stroke-white" viewBox="0 0 6 4" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1.44141 1.99951L2.43141 2.9895L4.56141 1.01953" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>

                    <div x-show="isNeedUpdate" class="absolute -bottom-1.5 -right-1.5 w-6 h-6 center bg-red-500 rounded-xl mx-auto">
                      <span class="text-white font-semibold">!</span>
                    </div>
                </div>
                <div>
                    <div
                      class="h4 font-medium text-gray-700"
                      x-text="isNeedUpdate ? '<?php e__('Updates available!') ?>' : '<?php escape_e__("You're up to date!") ?>'"
                    ></div>

                    <p
                      class="mt-1 text-sm text-gray-500"
                      x-text="!isNeedUpdate ? '<?php e__('Current Version: %version%'); ?>'.replace('%version%', currentVersion) : '<?php e__('Latest Version: %version%'); ?>'.replace('%version%', latestVersion)"
                    ></p>
                </div>
            </div>

            <div>
                <button
                  type="button"
                  x-show="!isNeedUpdate"
                  class="btn btn-primary flex justify-center items-center gap-2"
                  :class="checking && 'pointer-events-none opacity-50'"
                  @click="checkUpdate()"
                >
                  <span x-show="checking">
                    <svg class="animate-spin -ml-1 mr-1 h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                      <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                      <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                  </span>
                  <span x-text="checking ? '<?php e__('Checking...') ?>' : '<?php e__('Check for updates') ?>'"></span>
                </button>

                <button
                  x-show="isNeedUpdate"
                  type="button"
                  class="btn btn-success flex justify-center items-center gap-2"
                  :class="inProcess && 'pointer-events-none opacity-50'"
                  @click="updateLeaderOS()"
                >
                  <span x-show="!inProcess">
                    <i class="w-4" data-feather="refresh-2"></i>
                  </span>
                  <span x-show="inProcess">
                    <svg class="animate-spin -ml-1 mr-1 h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                      <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                      <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                  </span>
                  <span x-text="inProcess ? '<?php e__('Updating...') ?>' : '<?php e__('Update') ?>'"></span>
                </button>
            </div>
        </div>
    </div>
    <div class="mt-10">
        <div class="card">
            <div class="py-4 px-5 flex justify-between items-center">
                <div class="card-title">
                    <?php e__('Changelog') ?>
                </div>
                <a href="<?php echo leaderosWebsiteUrl(); ?>/changelog" class="text-xs text-gray-500" target="_blank">
                  <?php e__('Show All') ?>
                </a>
            </div>
            <div
              x-data="{
                versions: [],
                isLoading: true,
                fetchVersions() {
                  axios.get('<?php echo leaderosApiUrl('api2') ?>/versions.php')
                  .then(response => response.data)
                  .then(data => {
                    this.versions = data.slice(0, 10);
                    this.isLoading = false;
                  })
                }
              }"
              x-init="fetchVersions()"
              class="pb-4 px-5 flex flex-col gap-4"
            >
                <div x-show="isLoading">
                  <template x-for="loader in [1,2,3]">
                    <div class="card mb-3 py-4 px-6 rounded-xl flex justify-between items-center">
                      <div class="sl sl-title sl-rounded-md sl-animation-shimmer"></div>
                      <div class="sl sl-text sl-rounded-md sl-animation-shimmer"></div>
                    </div>
                  </template>
                </div>
                <template x-for="version in versions">
                  <div class="bg-gray-100/50 hover:bg-gray-600/5 transition py-4 px-6 rounded-xl">
                      <div class="flex justify-between items-center">
                          <span
                            class="font-semibold text-gray-600"
                            x-text="'<?php e__('Version: %version%') ?>'.replace('%version%', version.version)"
                          ></span>
                          <span
                            class="text-sm text-gray-400/75"
                            x-text="moment(version.date).format('MMMM DD, YYYY')"
                          ></span>
                      </div>
                      <div x-show="version.changelog != ''">
                          <span class="text-sm font-medium text-gray-600 mt-2 block">
                              <?php e__('Changelog') ?>:
                          </span>
                          <pre x-html="version.changelog" class="text-sm text-gray-500 mt-2 rounded-lg dark:py-3 dark:px-4 whitespace-break-spaces dark:bg-black"></pre>
                      </div>
                  </div>
                </template>
            </div>
        </div>
        <div class="mt-8 flex gap-3 justify-center items-center">
            <svg class="w-5 fill-gray-800" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                <path d="M15 0.429932H5C2 0.429932 0 2.42993 0 5.42993V11.4299C0 14.4299 2 16.4299 5 16.4299V18.5599C5 19.3599 5.89 19.8399 6.55 19.3899L11 16.4299H15C18 16.4299 20 14.4299 20 11.4299V5.42993C20 2.42993 18 0.429932 15 0.429932ZM10 12.5999C9.58 12.5999 9.25 12.2599 9.25 11.8499C9.25 11.4399 9.58 11.0999 10 11.0999C10.42 11.0999 10.75 11.4399 10.75 11.8499C10.75 12.2599 10.42 12.5999 10 12.5999ZM11.26 8.44993C10.87 8.70993 10.75 8.87993 10.75 9.15993V9.36993C10.75 9.77993 10.41 10.1199 10 10.1199C9.59 10.1199 9.25 9.77993 9.25 9.36993V9.15993C9.25 7.99993 10.1 7.42993 10.42 7.20993C10.79 6.95993 10.91 6.78993 10.91 6.52993C10.91 6.02993 10.5 5.61993 10 5.61993C9.5 5.61993 9.09 6.02993 9.09 6.52993C9.09 6.93993 8.75 7.27993 8.34 7.27993C7.93 7.27993 7.59 6.93993 7.59 6.52993C7.59 5.19993 8.67 4.11993 10 4.11993C11.33 4.11993 12.41 5.19993 12.41 6.52993C12.41 7.66993 11.57 8.23993 11.26 8.44993Z"/>
            </svg>
            <p class="text-sm text-gray-500">
                <?php e__('If you have any questions, please contact us') ?>
            </p>
            <a href="<?php echo leaderosWebsiteUrl() ?>/discord" class="text-sm text-blue-500 -ml-1" target="_blank">
                <?php e__('Contact us') ?>
            </a>
        </div>
    </div>
</section>