<?php
	$breadcrumbs = [
		[
			'url' => 'dashboard.vip-tables.index',
			'text' => t__('VIP Tables')
		],
		[
			'text' => t__('Edit')
		]
	];
	$this->layout('layouts/main', [
		'title' => t__('Editing %text%', ['%text%' => t__('VIP Table')]),
		'category' => moduleIsDisabled('tebex_store') ? 'store.vip-tables' : 'tebex-store.vip-tables',
		'breadcrumbs' => $breadcrumbs
	]) ?>

<section class="py-9 los-container tight-container">
	<div class="los-page-heading">
		<h1 class="text-gray-950">
			<?php e__('Editing %text%', ['%text%' => t__('VIP Table')]) ?>
		</h1>
		<div class="flex items-center gap-2">
			<a href="/store/<?php echo $vipTable['categorySlug'] ?>" class="btn btn-primary" target="_blank">
				<?php e__('View') ?>
			</a>
			<a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/vip-table" class="btn btn-dark" target="_blank">
				<?php e__('Help') ?>
			</a>
			<a href="<?php echo url('dashboard.vip-tables.index') ?>" class="btn btn-default">
				<?php e__('Back') ?>
			</a>
		</div>
	</div>
	
	<?php _message(); ?>
	
	<div class="card p-6 mt-10">
		<form
			x-data="{
            isFetched: false,
            products: [],
            selectedProducts: <?php echo htmlentities(json_encode(old('vips', $vipTable["vips"]))) ?>
          }"
			action="<?php echo url('dashboard.vip-tables.update', ['id' => $vipTable['id']]) ?>"
			method="post"
			class="grid gap-4"
		>
			<?php _method('PATCH'); ?>
			<div class="grid gap-4">
				<div>
					<label for="categoryID" class="form-label">
						<?php e__("Category") ?>
					</label>
					<?php $this->insert('components/select-category', [
						'name' => 'categoryID',
						'id' => 'categoryID',
						'placeholder' => t__('Select category'),
						'selected' => old('categoryID', $vipTable['categoryID']),
						'onChange' => "(selected) => {
                          getProductsByCategory(selected).then(data => {
                              const isTebexStore = " . (moduleIsDisabled('tebex_store') ? 'false' : 'true') . ";
                              if (isTebexStore) {
                                const tiersData = selectedProducts.map(id => Number(id));
	                              const sortedTiers = data.map(product => product.id).filter(id => tiersData.includes(id));
	                              selectedProducts = sortedTiers.map(id => String(id));
                              }
                              products = data;
                              
                              if (isFetched) {
                                $('#vips').val('');
                                selectedProducts = [];
                                $('#vips').select2();
                              } else { isFetched = true; }
                          });
                        }"
					]); ?>
				</div>
				<div x-show="products.length > 0">
					<label for="vips" class="form-label">
						<?php e__("Select VIP") ?>
					</label>
					<select x-data="selectVIPs()" x-init="onChange(() => selectedProducts = values)" multiple name="vips[]" id="vips">
						<template x-for="product in products">
							<option :value="product.id" :selected="selectedProducts.includes(String(product.id))">
								<span x-text="product.name"></span>
							</option>
						</template>
					</select>
				</div>
				<div x-show="products.length === 0 && isFetched">
					<div class="text-red-500 text-sm">
						<?php e__('No products were found in the selected category. Please add a product to the category and try again!') ?>
					</div>
				</div>
			</div>
			
			<?php
				$descriptions = [];
				if (old('titles') !== null) {
					foreach (old('titles') as $index => $title) {
						foreach ($vipTable["vips"] as $vipID) {
							$descriptions[$index][$vipID] = old('description_' . $vipID)[$index];
						}
					}
				} else {
					$descriptions = array_column($vipTable['data'], 'descriptions');
				}
				
				$defaultInputs = array_map(
					function($titles, $explains, $descriptions) {
						$data =  [
							'titles' => $titles,
							'explains' => $explains,
							'descriptions' => $descriptions
						];
						return $data;
					},
					old('titles', array_column($vipTable['data'], 'title')),
					old('explains', array_column($vipTable['data'], 'explain')),
					$descriptions
				);
			?>
			<div
				x-data="inputArray({
                    titles: '',
                    explains: ''
                  }, <?php echo htmlentities(json_encode($defaultInputs)) ?>)"
				x-show="selectedProducts.length > 0 && products.length > 0"
			>
				<div class="flex justify-between items-center">
					<div class="card-title">
						<?php e__("Features") ?>
					</div>
					<span @click="addInput()" class="btn btn-sm btn-sheer btn-primary cursor-pointer"><?php e__('Add') ?></span>
				</div>
				<table class="mt-3 table">
					<colgroup>
						<col style="width: 40%;">
					</colgroup>
					<thead class="">
					<tr class="table-header !text-xs !text-gray-500">
						<th scope="col" class="!text-left">
							<?php e__('Feature') ?>
						</th>
						<template x-for="selectedProduct in selectedProducts">
							<th scope="col" class="!pl-0" x-text="products.find(product => product.id == selectedProduct)?.name"></th>
						</template>
						<th scope="col" style="width: 80px">
							<span class="sr-only">
								<?php e__('Actions') ?>
							</span>
						</th>
					</tr>
					</thead>
					<tbody x-data="sortable()" class="divide-y divide-gray-200/20 text-center">
					<template x-for="(input, index) in inputs" :key="index">
						<tr :id="'input_' + index">
							<td class="!text-left !pl-0">
								<input type="text" class="form-control" name="titles[]" placeholder="<?php e__('Feature') ?>" x-bind:value="input.titles">
								<div x-data="{ showExplain: input.explains !== '' && input.explains !== null }">
									<div x-show="showExplain">
										<input type="text" class="form-control mt-1" name="explains[]" placeholder="<?php e__('Description') ?>" x-bind:value="showExplain ? input.explains : ''">
									</div>
									<div class="flex gap-1 items-center mt-1">
										<span x-show="showExplain">
											<i data-feather="x" class="w-4 h-4 text-danger"></i>
										</span>
										<span x-show="!showExplain">
											<i data-feather="add" class="w-4 h-4 text-gray-500"></i>
										</span>
										<span
											class="text-xs cursor-pointer"
											:class="showExplain ? 'text-danger' : 'text-gray-500'"
											@click="showExplain = !showExplain"
											x-text="showExplain ? '<?php e__('Remove description') ?>' : '<?php e__('Add description') ?>'"></span>
									</div>
								</div>
							</td>
							<template x-for="selectedProduct in selectedProducts">
								<td class="!pl-0 align-top">
									<input type="text" class="form-control !text-center" x-bind:name="'description_' + selectedProduct + '[]'" placeholder="<?php e__('Value') ?>" x-bind:value="input?.descriptions?.[selectedProduct]">
								</td>
							</template>
							<td class="justify-end flex items-center !px-0 gap-1" style="width: 80px;">
								<div class="btn btn-icon btn-secondary draggable-item">
									<i data-feather="move" class="w-5 h-5"></i>
								</div>
								<div @click="deleteInput(index)" class="btn btn-icon btn-danger">
									<i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
								</div>
							</td>
						</tr>
					</template>
					</tbody>
				</table>
				<div class="flex flex-col gap-2 mt-2 bg-gray-50 rounded-lg py-2 px-4">
					<span class="text-sm text-gray-500">
						<?php e__('You can use HTML tags in fields.'); ?>
					</span>
					<div class="flex items-center gap-1.5 text-sm text-gray-500">
						<?php e__("To add the %icon% icon: %char%", [
							'%icon%' => '<i class="text-success w-4 h-4" data-feather="tick-circle"></i>',
							'%char%' => '<strong>+</strong>'
						]) ?>
					</div>
					<div class="flex items-center gap-1.5 text-sm text-gray-500">
						<?php e__("To add the %icon% icon: %char%", [
							'%icon%' => '<i class="text-danger w-4 h-4" data-feather="x"></i>',
							'%char%' => '<strong>-</strong>'
						]) ?>
					</div>
				</div>
			</div>
			
			<div class="flex justify-end">
				<?php _csrf(); ?>
				<button type="submit" class="btn btn-success">
					<?php e__('Save Changes') ?>
				</button>
			</div>
		</form>
	</div>
</section>
