<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.vip-tables.index',
        'text' => t__('VIP Tables')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('VIP Tables'),
    'category' => moduleIsDisabled('tebex_store') ? 'store.vip-tables' : 'tebex-store.vip-tables',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($VIPs) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('VIP Tables') ?>
            </h1>
            <a href="<?php echo url('dashboard.vip-tables.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('VIP Tables')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="category">
								    <?php e__('Category') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="products">
								    <?php e__('Products') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($VIPs as $VIP): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.vip-tables.edit', ['id' => $VIP['id']]) ?>" class="category"><?php echo $VIP['categoryName'] ?></a>
								    <div>#<?php echo $VIP['id'] ?></div>
							    </td>
							    <td class="products not">
								    <?php foreach ($VIP['products'] as $product): ?>
									    <span class="badge badge-sm badge-secondary">
										    <?php echo $product ?>
									    </span>
								    <?php endforeach; ?>
							    </td>
							    <td class="table-action-buttons">
								    <a href="/store/<?php echo $VIP['categorySlug'] ?>" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.vip-tables.edit', ['id' => $VIP['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    
								    </a>
								    <form action="<?php echo url('dashboard.vip-tables.destroy', ['id' => $VIP['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No vip table found!'),
            'details' => t__('You can add new vip table by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.vip-tables.create',
                'text' => t__('Create VIP Table')
            ],
        ]);
    endif; ?>
</section>
