<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.votes.index',
        'text' => t__('Vote Links')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $voteLink["name"]]),
    'category' => 'misc.votes',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $voteLink["name"]]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/vote" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.votes.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php url('dashboard.votes.update', ['id' => $voteLink['id']]) ?>" method="post" class="grid gap-4">
            <?php _method('PATCH') ?>
            <div>
                <label for="name" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('name', $voteLink['name']) ?>" type="text" id="name" name="name" class="form-control">
            </div>
            <div>
                <label for="link" class="form-label">
                    <?php e__('Link') ?>
                </label>
                <input value="<?php _old('link', $voteLink['link']) ?>" type="text" id="link" name="link" class="form-control">
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>
