<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.votes.index',
        'text' => t__('Vote Links')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Vote Links'),
    'category' => 'misc.votes',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($voteLinks) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Vote Links') ?>
            </h1>
            <a href="<?php echo url('dashboard.votes.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Vote Links')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="name">
								    <?php e__('Name') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="link">
								    <?php e__('Link') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($voteLinks as $voteLink): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.votes.edit', ['id' => $voteLink['id']]) ?>" class="name"><?php echo $voteLink['name'] ?></a>
								    <div>#<?php echo $voteLink['id'] ?></div>
							    </td>
							    <td class="link">
								    <?php echo $voteLink['link'] ?>
							    </td>
							    <td class="table-action-buttons">
								    <a x-bind="tooltip('<?php e__('Edit') ?>')" href="<?php echo url('dashboard.votes.edit', ['id' => $voteLink['id']]) ?>" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.votes.destroy', ['id' => $voteLink['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No vote links found!'),
            'details' => t__('You can add new vote links by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.votes.create',
                'text' => t__('Create Vote Link')
            ],
        ]);
    endif; ?>
</section>
