<footer class="!overflow-visible">
    <div class="los-container flex justify-between items-center">
      <div class="flex gap-2">
        <?php
        $language_list = [
          'en' => 'English',
	        'de' => 'Deutsch',
	        'hu' => 'Magyar',
          'tr' => 'Türkçe',
        ];
        if (!in_array($lang, array_keys($language_list))) {
          $lang = 'en';
        }
        ?>
        <div x-data="dropdown()" class="relative">
          <div @click="toggle()" class="lg:card lg:!rounded-xl lg:border dark:border-gray-600/30 flex gap-2 items-center py-2 px-4 cursor-pointer select-none" x-bind="tooltip('<?php e__('Change Language') ?>')">
            <img src="<?php echo $this->asset("/img/languages/$lang.png") ?>" alt="" width="20px">
            <span class="text-gray-800 text-sm font-medium">
              <?php echo $language_list[$lang]; ?>
            </span>
          </div>
          <div x-bind="isDropdown" class="dropdown w-40 !-top-[150px] !left-0 !overflow-auto">
            <?php foreach ($language_list as $language_key => $language_name): ?>
              <a href="?lang=<?php echo $language_key; ?>" class="!flex items-center gap-2 <?php echo $language_key == $lang ? 'active' : null; ?>">
                <img src="<?php echo $this->asset("/img/languages/$language_key.png") ?>" alt="" width="18px">
                <?php echo $language_name; ?>
              </a>
            <?php endforeach; ?>
          </div>
        </div>

        <div x-bind="tooltip('<?php e__('Theme Settings') ?>', 'bottom')" @click="activeModal('theme')" class="btn btn-icon lg:!rounded-xl lg:border dark:border-gray-600/30 cursor-pointer" style="width: 34px !important; height: 34px !important;">
          <i class="stroke-gray-800 w-[1.125rem]" data-feather="brush"></i>
        </div>
      </div>

      <!-- LeaderOS signature -->
      <a href="<?php echo leaderosWebsiteUrl(); ?>" class="lg:card lg:!rounded-xl lg:border dark:border-gray-600/30 flex gap-2 items-center py-2 px-4">
        <img width="75px" src="<?php echo $this->asset('/img/leaderos-text-logo.png') ?>" alt="">
        <span class="relative z-10 text-gray-800 font-semibold font-maven text-sm">
          <?php echo VERSION; ?>
        </span>
      </a>
    </div>
</footer>