<!-- default header -->
<header>
    <div class="flex justify-between gap-4 items-center">
        <div id="activeMenuButton" @click="toggleActiveMenu()" class="lg:hidden cursor-pointer">
            <i class="text-gray-800 w-6" data-feather="hamburger-menu"></i>
        </div>
        <nav class="breadcrumbs">
            <ul>
                <li>
                  <a href="<?php echo url('dashboard.home') ?>" class="flex items-center gap-4">
                    <i class="w-5" data-feather="home"></i>
                    <?php if (count($breadcrumbs) > 0): ?>
                      <svg class="w-2" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1.5 1.00012L8.5 8.00012L1.5 15.0001" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    <?php endif; ?>
                  </a>
                </li>
                <?php foreach ($breadcrumbs as $key => $item): ?>
                    <li>
                        <?php if (count($breadcrumbs) !== $key+1): ?>
	                          <?php
			                        $breadcrumbUrl = 'javascript::void(0)';
															if (isset($item['url'])) {
																$breadcrumbUrl = is_string($item['url']) ? url($item['url'], $item['url_params'] ?? []) : $item['url'];
															}
	                          ?>
                            <a href="<?php echo $breadcrumbUrl; ?>"><?php echo $item['text'] ?></a>
                            <svg class="w-2" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1.5 1.00012L8.5 8.00012L1.5 15.0001" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        <?php else: ?>
                            <a class="active" href="javascript::void(0)"><?php echo $item['text'] ?></a>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>
            </ul>
        </nav>
    </div>


    <div class="md:flex hidden items-center gap-2 card px-3">
        <div x-bind="tooltip('<?php e__('Search') ?>', 'bottom')" @click="activeModal('search')" class="header-shortcut">
          <i data-feather="search-normal-1"></i>
        </div>

        <div class="cursor-pointer">
          <a href="/" target="_blank" class="header-shortcut" x-bind="tooltip('<?php e__('Visit Website') ?>', 'bottom')">
              <i data-feather="home-2"></i>
          </a>
        </div>

        <?php if (auth()->user()->can('MANAGE_NOTIFICATIONS')): ?>
          <div x-bind="tooltip('<?php e__('Notifications') ?>', 'bottom')" @click="activeModal('notification')" class="header-shortcut">
            <i data-feather="notification"></i>
          </div>
        <?php endif; ?>


        <a target="_blank" href="<?php echo leaderosHelpUrl(); ?>" x-bind="tooltip('<?php e__('Help Center') ?>', 'bottom')"  class="header-shortcut">
          <i data-feather="lifebuoy"></i>
        </a>
    </div>

</header>

<!-- mobile | only right menu -->
<section class="los-container mb-8 -mt-3 lg:-mt-6">
    <div class="md:hidden flex justify-center md:justify-start items-center gap-6 card px-6 py-1">
        <div x-bind="tooltip('<?php e__('Search') ?>', 'bottom')" @click="activeModal('search')" class="cursor-pointer px-3.5 h-12 center">
            <i class="stroke-gray-800 w-5" data-feather="search-normal-1"></i>
        </div>

        <div class="cursor-pointer">
          <a href="/" target="_blank" class="h-12 px-3.5 center" x-bind="tooltip('<?php e__('Visit Website') ?>', 'bottom')">
            <i class="stroke-gray-800 w-5" data-feather="home-2"></i>
          </a>
        </div>

        <?php if (auth()->user()->can('MANAGE_NOTIFICATIONS')): ?>
          <div x-bind="tooltip('<?php e__('Notifications') ?>', 'bottom')" @click="activeModal('notification')" class="cursor-pointer px-3.5 h-12 center">
            <i class="stroke-gray-800 w-5" data-feather="notification"></i>
          </div>
        <?php endif; ?>

        <a target="_blank" href="<?php echo leaderosHelpUrl(); ?>" x-bind="tooltip('<?php e__('Help Center') ?>', 'bottom')"  class="cursor-pointer px-3.5 h-12 center">
          <i class="stroke-gray-800 w-5" data-feather="lifebuoy"></i>
        </a>
    </div>
</section>