<?php if (auth()->user()->can('MANAGE_NOTIFICATIONS')): ?>
<div x-show="modal === 'notification'" class="h-full right-0 w-full max-w-xl bg-los-shiny absolute top-0 z-20 flex flex-col transition duration-300"
     x-transition:enter-start="opacity-0 translate-x-full"
     x-transition:enter-end="opacity-100 translate-x-0"
     x-transition:leave-start="opacity-100 translate-x-0"
     x-transition:leave-end="opacity-0 translate-x-full">
  <div class="py-8 px-10 flex justify-between items-center">
    <div class="text-los font-medium font-maven h3">
      <?php e__('Notifications') ?>
    </div>
    <div @click="closeModal()" class="cursor-pointer text-sm text-gray-400/75 transition hover:text-gray-400">
      <i class="fill-gray-400 w-6" data-feather="close"></i>
    </div>
  </div>
  <div class="flex flex-col divide-y divide-gray-600/10 overflow-y-auto">
    <?php if (count($notifications) > 0): ?>
      <?php foreach ($notifications as $notification): ?>
        <div class="py-4 transition hover:bg-gray-600/5">
          <div class="relative flex gap-5">
            <div class="absolute left-0 inset-y-0 w-0.5 bg-gray-400/25 rounded-r-full"></div>
            <div class="w-16 h-16 center pl-6">
	            <?php $this->insert('components/avatar', [
		            'avatar' => \Dashboard\Services\AvatarService::get($notification['accountID'], $notification['realname']),
		            'username' => $notification['realname'],
		            'class' => 'w-10',
		            'size' => '32px'
	            ]); ?>
              <svg class="hidden w-10 stroke-gray-600 dark:stroke-gray-400/50" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M8.5 10.5H15.5" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M2 11.5599V13.4299C2 16.4299 4 18.4299 7 18.4299H11L15.45 21.39C16.11 21.83 17 21.3599 17 20.5599V18.4299C20 18.4299 22 16.4299 22 13.4299V7.42993C22 4.42993 20 2.42993 17 2.42993H7C4 2.42993 2 4.42993 2 7.42993" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
              </svg>
            </div>
            <div class="grow">
              <div class="pt-3">
                <div class="flex items-center gap-3 text-gray-400 text-xs font-normal">
                  <span><?php echo convertTime($notification["creationDate"]); ?></span>
                </div>
                <div class="mt-1 text-gray-500 text-sm">
                  <a href="#" class="text-gray-800 font-medium"><?php echo $notification['realname'] ?></a>
                  <?php if ($notification["type"] == 1): ?>
                    <?php e__('has sent support message!') ?>
                  <?php elseif ($notification["type"] == 2): ?>
                    <?php e__('has commented on a news!') ?>
                  <?php elseif ($notification["type"] == 3): ?>
                    <?php e__('has bought %credit% credits!', ['%credit%' => $notification["variables"]]); ?>
                  <?php elseif ($notification["type"] == 4): ?>
                    <?php $notification["variables"] = explode(",", $notification["variables"]); ?>
                    <?php e__('has bought %product% from the %server%', ['%product%' => $notification["variables"][1], '%server%' => $notification["variables"][0]]) ?>
                  <?php else: ?>
                    <?php e__('ERROR!') ?>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
      <div class="center py-4 px-6 text-gray-400 text-sm">
        <?php e__('Only the last 10 notifications are displayed.') ?>
      </div>
    <?php else: ?>
      <p class="text-red-500 px-10">
        <?php e__('No notifications found!') ?>
      </p>
    <?php endif; ?>
  </div>
  <div class="mt-auto p-8 center">
    <a href="<?php echo url('dashboard.notifications.index') ?>" class="btn btn-lg btn-default w-full text-center !py-3">
      <?php e__('Show All') ?>
    </a>
  </div>
</div>
<?php endif; ?>

<div x-show="modal === 'theme'" class="h-full right-0 w-full max-w-xl bg-los-shiny absolute top-0 z-20 flex flex-col transition duration-300 overflow-y-auto"
   x-transition:enter-start="opacity-0 translate-x-full"
   x-transition:enter-end="opacity-100 translate-x-0"
   x-transition:leave-start="opacity-100 translate-x-0"
   x-transition:leave-end="opacity-0 translate-x-full">
  <div class="py-8 px-10 flex justify-between items-center">
      <div class="text-los font-medium font-maven h3">
          <?php e__('Theme Settings') ?>
      </div>
      <div @click="closeModal()" class="cursor-pointer text-sm text-gray-400/75 transition hover:text-gray-400">
        <i class="fill-gray-400 w-6" data-feather="close"></i>
      </div>
  </div>
  <div class="pb-6 px-10 divide-y divide-gray-600/10">
      <div>
          <label for="" class="form-label">
            <?php e__('Always show sidebar') ?>
          </label>
          <div class="!flex-row tab-container !py-3">
              <div @click="alwaysSideDetailsOpen = true" class="tab-item" :class="[alwaysSideDetailsOpen ? 'active':'']"><?php e__('Active') ?></div>
              <div @click="alwaysSideDetailsOpen = false" class="tab-item" :class="[alwaysSideDetailsOpen ? '':'active']"><?php e__('Disable') ?></div>
          </div>
      </div>
      <div class="pt-6">
          <label for="" class="form-label">
            <?php e__('Theme') ?>
          </label>
          <div class="!flex-row tab-container !grid !grid-cols-2 !py-3">
              <div @click="switchTheme('light')" :class="{'active':activeTheme === 'light'}" class="tab-item">
                  <small class="text-sm text-gray-400">
                    <?php e__('Light Mode') ?>
                  </small>
                  <img class="w-44 mt-2" src="/apps/dashboard/public/assets/img/lightMode.svg" alt="">
              </div>
              <div @click="switchTheme('dark')" :class="{'active':activeTheme === 'dark'}" class="tab-item">
                  <small class="text-sm text-gray-400">
                    <?php e__('Dark Mode') ?>
                  </small>
                  <img class="w-44 mt-2" src="/apps/dashboard/public/assets/img/darkMode.svg" alt="">
              </div>
              <div @click="switchTheme('dark-blue')" :class="{'active':activeTheme === 'dark-blue'}" class="tab-item">
                  <small class="text-sm text-gray-400">
                    <?php e__('Blue Dark Mode') ?>
                  </small>
                  <img class="w-44 mt-2" src="/apps/dashboard/public/assets/img/blueDarkMode.svg" alt="">
              </div>
          </div>
      </div>
      <div class="pt-6">
          <label for="" class="form-label"><?php e__('Blue Side Panel') ?> <small class="text-gray-400/75">(<?php e__('for light mode') ?>)</small></label>
          <div class="!flex-row tab-container !grid !grid-cols-2 !py-3">
              <div @click="toggleSideColor()" :class="{'active':sideColorBlue}" class="tab-item">
                  <span x-text="sideColorBlue ? 'active':'non-active'"></span>
                  <img class="w-44 mt-2" src="/apps/dashboard/public/assets/img/blueSidePanel.svg" alt="">
              </div>
          </div>
      </div>
  </div>
</div>

<div x-data="search()" x-show="modal === 'search'" class="max-w-3xl w-full card p-3 absolute-center -mt-20 duration-200 transition"
   x-transition:enter-start="opacity-0 scale-90"
   x-transition:enter-end="opacity-100 scale-100"
   x-transition:leave-start="opacity-100 scale-100"
   x-transition:leave-end="opacity-0 scale-90">
  <div x-trap="modal === 'search'" class="pt-3 px-4">
      <div class="flex justify-between items-center">
        <span class="text-lg font-medium dark:text-white">
          <?php e__('Search') ?>
        </span>
        <div @click="closeModal()" class="cursor-pointer text-sm text-gray-400/75 transition hover:text-gray-400">
          <i class="fill-gray-400 w-6" data-feather="close"></i>
        </div>
      </div>
      <input type="text" x-model.debounce.500ms="query" class="form-control mt-3" placeholder="<?php e__('How can I help you?') ?>">
  </div>
	<div x-show="results.length > 0 || loading || notFound" class="py-4 px-4 text-sm">
		<div class="px-1 mt-4 card-title">
			<?php e__('Search Results') ?>
		</div>
		<div x-show="results.length > 0 && !loading && !notFound" class="grid mt-2 -mx-3 max-h-[415px] overflow-y-auto">
			<template x-for="result in results">
				<a :href="result.item.url" class="py-4 px-4 rounded-xl text-gray-500 flex items-center gap-3.5 transition hover:bg-gray-600/5 not">
					<div x-html="feather.icons[result.item.icon].toSvg({ class: 'w-6 h-6 stroke-gray-800 dark:stroke-white' })"></div>
					<div class="">
						<div class="block text-gray-800 dark:text-white font-medium" x-html="result.item.title"></div>
						<div class="flex items-center gap-0.5" x-html="result.item.breadcrumb"></div>
					</div>
				</a>
			</template>
		</div>
		<div x-show="loading" class="grid mt-2 mb-3 gap-y-2">
			<template x-for="item in [1,2,3,4,5,6]">
				<div class="sl sl-title sl-rounded-md sl-animation-shimmer !w-full !h-[40px]"></div>
			</template>
		</div>
		<div x-show="!loading && notFound" class="grid mt-2 mb-3 gap-y-2">
			<div class="bg-red-500/20 text-red-500 py-3 px-4 rounded-lg">
				<?php e__('No data found!') ?>
			</div>
		</div>
	</div>
  <div x-show="results.length === 0 && !loading && !notFound" class="py-4 px-4 text-sm">
      <div class="px-1 mt-4 card-title">
        <?php e__('Quick Menu') ?>
      </div>
      <div class="grid mt-2 -mx-3">
          <a href="<?php echo url('dashboard.store.products.create') ?>" class="py-4 px-4 rounded-xl text-gray-500 flex items-center gap-3 transition hover:bg-gray-600/5 not">
              <div>
                <i class="w-5 h-5 stroke-gray-800" data-feather="shopping-cart"></i>
              </div>
              <span>
                  <?php e__('Create Product') ?>
              </span>
          </a>
        <a href="<?php echo url('dashboard.support.tickets.index') ?>" class="py-4 px-5 rounded-xl text-gray-500 flex items-center gap-3 transition hover:bg-gray-600/5 not">
          <div>
            <i class="w-5 h-5 stroke-gray-800" data-feather="lifebuoy"></i>
          </div>
          <span>
                  <?php e__('Tickets') ?>
              </span>
        </a>
        <a href="<?php echo url('dashboard.settings.index') ?>" class="py-4 px-5 rounded-xl text-gray-500 flex items-center gap-3 transition hover:bg-gray-600/5 not">
          <div>
            <i class="w-5 h-5 stroke-gray-800" data-feather="setting-2"></i>
          </div>
          <span>
                  <?php e__('Settings') ?>
              </span>
        </a>
      </div>
      <div class="px-1 mt-4 card-title">
        <?php e__('Help') ?>
      </div>
      <div class="grid gap-2 mt-2 -mx-3">
          <a href="<?php echo leaderosHelpUrl(); ?>" target="_blank" class="py-4 px-4 rounded-xl text-gray-500 flex items-center gap-3 transition hover:bg-gray-600/5 not">
              <div>
                <i class="w-5 h-5 stroke-gray-800" data-feather="lifebuoy"></i>
              </div>
              <span>
                  <?php e__('Help Center') ?>
              </span>
          </a>
      </div>
  </div>
</div>

<div x-show="modal === 'alert'" @open-alert.window="openAlert($event.detail)" class="max-w-xl w-full card p-3 absolute-center -mt-20 duration-200 transition relative"
   x-transition:enter-start="opacity-0 scale-90"
   x-transition:enter-end="opacity-100 scale-100"
   x-transition:leave-start="opacity-100 scale-100"
   x-transition:leave-end="opacity-0 scale-90">
  <div class="absolute right-4 top-4 z-10">
    <div @click="closeModal()" class="cursor-pointer text-sm text-gray-400/75 transition hover:text-gray-400 p-3">
      <i class="fill-gray-400 w-6" data-feather="close"></i>
    </div>
  </div>
  <div class="py-10">
      <div class="center mb-6">
		      <i
			      x-show="alert.type === 'info'"
			      class="w-20 h-20 stroke-blue-500"
			      data-feather="info-circle"></i>
		      
          <i
            x-show="alert.type === 'warning' || alert.type === 'warning-question'"
            class="w-20 h-20 stroke-yellow-400"
            data-feather="danger"></i>

          <i
            x-show="alert.type === 'delete'"
            class="w-20 h-20 stroke-red-400"
            data-feather="trash"></i>

          <i
            x-show="alert.type === 'danger' || alert.type === 'danger-question'"
            class="w-20 h-20 stroke-red-400"
            data-feather="x"></i>

          <i
            x-show="alert.type === 'success'"
            class="w-20 h-20 stroke-emerald-400"
            data-feather="tick-circle"></i>
      </div>

      <div class="text-center font-semibold text-gray-800 text-xl" x-text="alert.title"></div>
      <p class="text-center max-w-sm mx-auto text-gray-500 mt-1 text-lg" x-text="alert.message"></p>

      <div class="mt-8 center gap-2">
        <div
          x-show="alert.type === 'delete' || alert.type === 'danger-question' || alert.type === 'warning-question'"
          @click="closeModal()"
          class="cursor-pointer btn btn-secondary btn-lg"
        >
          <?php e__('Cancel') ?>
        </div>

        <div
          x-show="alert.confirm !== null"
          @click="() => {
            if (typeof alert.confirm === 'string' || alert.confirm instanceof String)
                $dispatch(alert.confirm, true)
            else
                alert.confirm()

            closeModal()
          }"
          class="cursor-pointer btn"
          :class="() => {
            if (alert.confirmClass !== null)
                return alert.confirmClass

            if (alert.type === 'warning' || alert.type === 'warning-question')
              return 'btn-warning'
            else if (alert.type === 'danger' || alert.type === 'danger-question' || alert.type === 'delete')
                return 'btn-danger'
            else if (alert.type === 'success')
                return 'btn-success'
            else
                return 'btn-primary'
          }"
          x-text="alert.confirmText ?? '<?php e__('OK') ?>'">
        </div>
      </div>
  </div>
</div>

<div x-show="modal === 'ai'" class="max-w-3xl w-full card p-3 absolute-center -mt-20 duration-200 transition"
     x-transition:enter-start="opacity-0 scale-90"
     x-transition:enter-end="opacity-100 scale-100"
     x-transition:leave-start="opacity-100 scale-100"
     x-transition:leave-end="opacity-0 scale-90">
	<div x-trap="modal === 'ai'" class="pt-3 px-4">
		<div class="flex justify-between items-center">
			<div class="flex items-center gap-2">
				<img src="<?php echo $this->asset("/img/ai-icon.png") ?>" width="24px">
				<span class="text-lg font-medium dark:text-white">
          <?php e__('Generate with AI') ?>
        </span>
			</div>
			<div @click="closeModal()" class="cursor-pointer text-sm text-gray-400/75 transition hover:text-gray-400">
				<i class="fill-gray-400 w-6" data-feather="close"></i>
			</div>
		</div>
		<div class="relative" x-data="{prompt: '', isAiGenerating: false}">
			<textarea id="ai_content" rows="5" class="form-control mt-3" placeholder="<?php e__('What do you want to generate?') ?>" x-model="prompt" @keydown.enter="generateWithAi(prompt, $event)" :readonly="isAiGenerating"></textarea>
			<div class="absolute right-3 bottom-4">
				<button x-show="!isAiGenerating" type="button" @click="generateWithAi(prompt)" class="btn btn-dark btn-icon" :class="{'pointer-events-none': prompt.length < 5, 'opacity-50': prompt.length < 5}">
					<i class="w-5 h-5" data-feather="arrow-up"></i>
				</button>
				<button x-show="isAiGenerating" type="button" class="btn btn-dark btn-icon pointer-events-none">
					<svg class="animate-spin h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
						<circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
						<path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
					</svg>
				</button>
			</div>
		</div>
	</div>
</div>