<div
  x-data="noticesHandler()"
  aria-live="assertive"
  class="fixed inset-0 flex flex-col gap-3 items-end px-4 py-6 pointer-events-none sm:p-6 sm:items-start z-50"
  @notice.window="add($event.detail)"
  style="pointer-events:none"
>
  <template x-for="notice of notices" :key="notice.id">
    <div class="w-full flex flex-col items-center space-y-4 sm:items-end">
      <div
        @click="remove(notice.id)"
        x-show="visible.includes(notice)"
        x-transition:enter="transform ease-out duration-300 transition"
        x-transition:enter-start="translate-y-2 opacity-0 sm:translate-y-0 sm:translate-x-2"
        x-transition:enter-end="translate-y-0 opacity-100 sm:translate-x-0"
        x-transition:leave="transition ease-in duration-100"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        class="cursor-pointer max-w-sm w-full rounded-lg pointer-events-auto overflow-hidden"
        :class="'toast-' + notice.type"
      >
        <div class="p-4">
          <div class="flex items-start">
            <div class="flex-shrink-0">
              <div x-show="notice.type === 'success'">
                <i class="h-6 w-6" data-feather="tick-circle"></i>
              </div>
              <div x-show="notice.type === 'error'">
                <i class="h-6 w-6" data-feather="x"></i>
              </div>
              <div x-show="notice.type === 'warning'">
                <i class="h-6 w-6" data-feather="danger"></i>
              </div>
              <div x-show="notice.type === 'info'">
                <i class="h-6 w-6" data-feather="info-circle"></i>
              </div>
            </div>
            <div class="ml-3 w-0 flex-1">
              <p x-show="notice.title !== undefined" class="text-sm font-medium mb-1" x-text="notice.title"></p>
              <p class="text-sm" x-text="notice.text"></p>
            </div>
            <div class="ml-4 flex-shrink-0 flex">
              <button
                @click="remove(notice.id)"
                class="rounded-md inline-flex text-white focus:outline-none focus:ring-0 focus:ring-offset-0"
              >
                  <span class="sr-only">
                    <?php e__('Close') ?>
                  </span>
                <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                  <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                </svg>
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </template>
</div>