<?php
	$sidebar = [
		'user-management' => [
			'title' => t__('User Management'),
			'icon' => 'profile',
			'permission' => ['MANAGE_ACCOUNTS', 'MANAGE_ROLES', 'MANAGE_BANS'],
			'items' => [
				[
					'title' => t__('User Management'),
					'items' => [
						[
							'title' => t__('Users'),
							'route' => 'dashboard.accounts.index',
							'category' => 'user-management.users',
							'icon' => 'user',
							'permission' => ['MANAGE_ACCOUNTS'],
						],
						[
							'title' => t__('Roles'),
							'route' => 'dashboard.roles.index',
							'category' => 'user-management.roles',
							'icon' => 'shield-security',
							'permission' => ['MANAGE_ROLES'],
						],
						[
							'title' => t__('Staff'),
							'route' => 'dashboard.accounts.staff',
							'category' => 'user-management.staff',
							'icon' => 'user-tick',
							'permission' => ['MANAGE_ACCOUNTS'],
						],
						[
							'title' => t__('Bans'),
							'route' => 'dashboard.bans.index',
							'category' => 'user-management.bans',
							'icon' => 'forbidden',
							'permission' => ['MANAGE_BANS'],
						],
						[
							'title' => t__('Custom Fields'),
							'route' => 'dashboard.custom-fields.index',
							'category' => 'user-management.custom-fields',
							'icon' => 'add-square',
							'permission' => ['MANAGE_ACCOUNTS'],
						]
					]
				],
				[
					'title' => t__('Actions'),
					'items' => [
						[
							'title' => t__('Ban User'),
							'route' => 'dashboard.bans.create',
							'category' => 'user-management.actions.ban-user',
							'icon' => 'forbidden',
							'permission' => ['MANAGE_BANS'],
						],
						[
							'title' => t__('Send Credits'),
							'route' => 'dashboard.store.credit.send.index',
							'category' => 'user-management.actions.send-credits',
							'icon' => 'money-recive',
							'module' => ['credit'],
							'permission' => ['MANAGE_ACCOUNTS'],
						],
						[
							'title' => t__('Send Chest Item'),
							'route' => 'dashboard.store.chest.send.index',
							'category' => 'user-management.actions.send-chest-item',
							'icon' => 'strongbox',
							'module' => ['chest'],
							'permission' => ['MANAGE_ACCOUNTS'],
						]
					]
				]
			]
		],
		'store' => [
			'title' => t__('Store'),
			'icon' => 'shopping-cart',
			'module' => ['store'],
			'show' => moduleIsDisabled('tebex_store'),
			'permission' => ['MANAGE_STORE', 'MANAGE_SERVERS', 'MANAGE_GIFTS', 'MANAGE_GAMING_NIGHT', 'MANAGE_COMMUNITY_GOALS'],
			'items' => [
				[
					'title' => t__('Store'),
					'items' => [
						[
							'title' => t__('Products'),
							'route' => 'dashboard.store.products.index',
							'category' => 'store.products',
							'icon' => 'shopping-cart',
							'permission' => ['MANAGE_STORE'],
						],
						[
							'title' => t__('Categories'),
							'route' => 'dashboard.store.categories.index',
							'category' => 'store.categories',
							'icon' => 'category-2',
							'permission' => ['MANAGE_STORE'],
						],
						[
							'title' => t__('Game Servers'),
							'route' => 'dashboard.servers.index',
							'category' => 'store.servers',
							'icon' => 'code-1',
							'permission' => ['MANAGE_SERVERS'],
						],
						[
							'title' => t__('Coupons'),
							'route' => 'dashboard.store.coupons.index',
							'category' => 'store.coupons',
							'icon' => 'ticket-discount',
							'permission' => ['MANAGE_STORE'],
						],
						[
							'title' => t__('Creator Codes'),
							'route' => 'dashboard.store.creator-codes.index',
							'category' => 'store.creator-codes',
							'icon' => 'ticket-star',
							'permission' => ['MANAGE_STORE'],
						],
						[
							'title' => t__('Gifts'),
							'route' => 'dashboard.gifts.index',
							'category' => 'store.gifts',
							'icon' => 'gift',
							'permission' => ['MANAGE_GIFTS'],
						],
						[
							'title' => t__('Orders'),
							'route' => 'dashboard.store.orders.index',
							'category' => 'store.orders',
							'icon' => 'bag',
							'permission' => ['MANAGE_STORE'],
						],
						[
							'title' => t__('Payments'),
							'route' => 'dashboard.store.payments.index',
							'category' => 'store.payments',
							'icon' => 'card',
							'permission' => ['MANAGE_STORE'],
						],
						[
							'title' => t__('VIP Tables'),
							'route' => 'dashboard.vip-tables.index',
							'category' => 'store.vip-tables',
							'icon' => 'grid-7',
							'permission' => ['MANAGE_STORE'],
						],
						[
							'title' => t__('Credit Packages'),
							'route' => 'dashboard.store.credit-packages.index',
							'category' => 'store.credit-packages',
							'icon' => 'coin-1',
							'permission' => ['MANAGE_STORE'],
							'show' => moduleSettings('credit', 'creditPackageStatus') == 1
						],
						[
							'title' => t__('Gaming Night'),
							'route' => 'dashboard.gaming-night.index',
							'category' => 'store.gaming-night',
							'icon' => 'moon',
							'module' => ['gaming_night'],
							'permission' => ['MANAGE_GAMING_NIGHT'],
						],
						[
							'title' => t__('Bulk Discount'),
							'route' => 'dashboard.store.bulk-discount.index',
							'category' => 'store.bulk-discount',
							'icon' => 'percentage-square',
							'permission' => ['MANAGE_STORE'],
						],
						[
							'title' => t__('Community Goals'),
							'route' => 'dashboard.store.community-goals.index',
							'category' => 'store.community-goal',
							'icon' => 'shopping-bag',
							'permission' => ['MANAGE_COMMUNITY_GOALS'],
						],
						[
							'title' => t__('Variables'),
							'route' => 'dashboard.store.variables.index',
							'category' => 'store.variables',
							'icon' => 'add-square',
							'permission' => ['MANAGE_STORE'],
						],
						[
							'title' => t__('Settings'),
							'route' => 'dashboard.settings.store.index',
							'category' => 'settings.store',
							'icon' => 'setting-2',
							'permission' => ['MANAGE_SETTINGS'],
						],
					]
				]
			]
		],
		'tebex-store' => [
			'title' => t__('Tebex Store'),
			'svg' => '<svg fill="none" stroke="white" style="width: 20px; position: relative; stroke-width: 4px;" viewBox="16 0 75 75" xmlns="http://www.w3.org/2000/svg"><path d="M55.8364 19.1468C58.6805 14.4276 63.8309 13.0604 63.8309 13.0604C63.8309 13.0604 54.0012 10.4463 54.0012 0C54.0012 10.4463 44.1658 13.0604 44.1658 13.0604C44.1658 13.0604 49.3181 14.4276 52.1641 19.1468H38.7266V37.239L41.7815 31.6362H47.8894V62.8606L60.1072 75.35V37.1186C56.9915 35.6504 52.5155 31.9178 50.9121 29.0707C53.6497 29.9155 57.3221 31.0264 60.1813 31.6381H69.272V19.1468H55.8364Z"></path></svg>',
			'module' => ['tebex_store'],
			'permission' => ['MANAGE_STORE'],
			'items' => [
				[
					'title' => t__('Tebex Store'),
					'items' => [
						[
							'title' => t__('Dashboard'),
							'url' => 'https://creator.tebex.io/dashboard',
							'target' => '_blank',
							'icon' => 'category',
						],
						[
							'title' => t__('Statistics'),
							'url' => 'https://creator.tebex.io/statistics',
							'target' => '_blank',
							'icon' => 'diagram',
						],
						[
							'title' => t__('Payments'),
							'url' => 'https://creator.tebex.io/payments',
							'target' => '_blank',
							'icon' => 'card',
						],
						[
							'title' => t__('Packages'),
							'url' => 'https://creator.tebex.io/packages',
							'target' => '_blank',
							'icon' => 'archive-1',
						],
						[
							'title' => t__('Coupons'),
							'url' => 'https://creator.tebex.io/coupons',
							'target' => '_blank',
							'icon' => 'ticket-discount',
						],
						[
							'title' => t__('Sales'),
							'url' => 'https://creator.tebex.io/sales',
							'target' => '_blank',
							'icon' => 'percentage-square',
						],
						[
							'title' => t__('Creator Codes'),
							'url' => 'https://creator.tebex.io/creator-codes',
							'target' => '_blank',
							'icon' => 'barcode',
						],
						[
							'title' => t__('Gift Cards'),
							'url' => 'https://creator.tebex.io/giftcards',
							'target' => '_blank',
							'icon' => 'gift',
						],
						[
							'title' => t__('VIP Tables'),
							'route' => 'dashboard.vip-tables.index',
							'category' => 'tebex-store.vip-tables',
							'icon' => 'grid-7',
						],
						[
							'title' => t__('Settings'),
							'route' => 'dashboard.tebex-store.settings.index',
							'category' => 'tebex-store.settings',
							'icon' => 'setting-2',
						]
					]
				]
			]
		],
		'support-help' => [
			'title' => t__('Support & Help'),
			'icon' => 'lifebuoy',
			'module' => ['support', 'help'],
			'permission' => ['MANAGE_SUPPORT', 'MANAGE_SUPPORT_TICKETS', 'MANAGE_HELP_CENTER'],
			'items' => [
				[
					'title' => t__('Support'),
					'module' => ['support'],
					'permission' => ['MANAGE_SUPPORT', 'MANAGE_SUPPORT_TICKETS'],
					'items' => [
						[
							'title' => t__('Tickets'),
							'route' => 'dashboard.support.tickets.index',
							'category' => 'support-help.support.tickets',
							'icon' => 'lifebuoy',
							'permission' => ['MANAGE_SUPPORT', 'MANAGE_SUPPORT_TICKETS'],
						],
						[
							'title' => t__('Categories'),
							'route' => 'dashboard.support.categories.index',
							'icon' => 'category-2',
							'category' => 'support-help.support.categories',
							'permission' => ['MANAGE_SUPPORT'],
						],
						[
							'title' => t__('Quick Answers'),
							'route' => 'dashboard.support.quick-answers.index',
							'icon' => 'message-text',
							'category' => 'support-help.support.quick-answers',
							'permission' => ['MANAGE_SUPPORT'],
						],
						[
							'title' => t__('Settings'),
							'route' => 'dashboard.settings.support.index',
							'category' => 'settings.support',
							'icon' => 'setting-2',
							'permission' => ['MANAGE_SETTINGS'],
						],
					]
				],
				[
					'title' => t__('Help Center'),
					'module' => ['help'],
					'permission' => ['MANAGE_HELP_CENTER'],
					'items' => [
						[
							'title' => t__('Articles'),
							'route' => 'dashboard.help.articles.index',
							'category' => 'support-help.help.articles',
							'icon' => 'edit'
						],
						[
							'title' => t__('Topics'),
							'route' => 'dashboard.help.topics.index',
							'category' => 'support-help.help.topics',
							'icon' => 'category-2'
						]
					]
				]
			]
		],
		'content-management' => [
			'title' => t__('Content Management'),
			'icon' => 'edit',
			'module' => ['blog', 'forum', 'page', 'changelog'],
			'permission' => ['MANAGE_BLOG', 'MANAGE_FORUM', 'MANAGE_PAGES', 'MANAGE_CHANGELOG'],
			'items' => [
				[
					'title' => t__('Blog'),
					'module' => ['blog'],
					'permission' => ['MANAGE_BLOG'],
					'items' => [
						[
							'title' => t__('Posts'),
							'route' => 'dashboard.blog.posts.index',
							'category' => 'content-management.blog.posts',
							'icon' => 'edit',
						],
						[
							'title' => t__('Categories'),
							'route' => 'dashboard.blog.categories.index',
							'category' => 'content-management.blog.categories',
							'icon' => 'category-2'
						],
						[
							'title' => t__('Comments'),
							'route' => 'dashboard.blog.comments.index',
							'category' => 'content-management.blog.comments',
							'icon' => 'message'
						]
					]
				],
				[
					'title' => t__('Forum'),
					'module' => ['forum'],
					'permission' => ['MANAGE_FORUM'],
					'items' => [
						[
							'title' => t__('Threads'),
							'route' => 'dashboard.forum.threads.index',
							'category' => 'content-management.forum.threads',
							'icon' => 'message-notif'
						],
						[
							'title' => t__('Categories'),
							'route' => 'dashboard.forum.categories.index',
							'category' => 'content-management.forum.categories',
							'icon' => 'category-2'
						]
					]
				],
				[
					'title' => t__('Changelog'),
					'module' => ['changelog'],
					'permission' => ['MANAGE_CHANGELOG'],
					'items' => [
						[
							'title' => t__('Changelog'),
							'route' => 'dashboard.changelog.index',
							'category' => 'content-management.changelog',
							'icon' => 'clipboard-tick',
						],
						[
							'title' => t__('Tags'),
							'route' => 'dashboard.changelog.tags.index',
							'category' => 'content-management.changelog.tags',
							'icon' => 'tag',
						],
					]
				],
				[
					'title' => t__('Other'),
					'module' => ['page'],
					'permission' => ['MANAGE_PAGES'],
					'items' => [
						[
							'title' => t__('Pages'),
							'route' => 'dashboard.pages.index',
							'category' => 'content-management.other.pages',
							'icon' => 'element-1',
							'module' => ['page'],
							'permission' => ['MANAGE_PAGES'],
						],
					]
				]
			]
		],
		'forms' => [
			'title' => t__('Forms'),
			'icon' => 'document-text',
			'module' => ['application', 'form'],
			'permission' => ['MANAGE_APPLICATIONS', 'MANAGE_CUSTOM_FORMS'],
			'items' => [
				[
					'title' => t__('Applications'),
					'module' => ['application'],
					'permission' => ['MANAGE_APPLICATIONS'],
					'items' => [
						[
							'title' => t__('Application Forms'),
							'route' => 'dashboard.applications.forms.index',
							'category' => 'forms.applications.forms',
							'icon' => 'document-text'
						],
						[
							'title' => t__('Applications'),
							'route' => 'dashboard.applications.index',
							'category' => 'forms.applications',
							'icon' => 'direct-inbox'
						]
					]
				],
				[
					'title' => t__('Custom Forms'),
					'module' => ['form'],
					'permission' => ['MANAGE_CUSTOM_FORMS'],
					'items' => [
						[
							'title' => t__('Custom Forms'),
							'route' => 'dashboard.forms.index',
							'category' => 'forms.custom-forms.forms',
							'icon' => 'document-text'
						],
						[
							'title' => t__('Submissions'),
							'route' => 'dashboard.forms.answers.index',
							'category' => 'forms.custom-forms.submissions',
							'icon' => 'direct-inbox'
						]
					]
				]
			]
		],
		'appearance' => [
			'title' => t__('Appearance'),
			'icon' => 'brush',
			'permission' => ['MANAGE_THEME'],
			'items' => [
				[
					'title' => t__('Appearance'),
					'items' => [
						[
							'title' => t__('Themes'),
							'route' => 'dashboard.appearance.themes.index',
							'category' => 'appearance.themes',
							'icon' => 'brush'
						],
						[
							'title' => t__('Theme Settings'),
							'route' => 'dashboard.appearance.themes.settings.index',
							'category' => 'appearance.themes.settings',
							'icon' => 'setting-4'
						],
						[
							'title' => t__('Theme Editor'),
							'route' => 'dashboard.appearance.editor.index',
							'category' => 'appearance.editor',
							'icon' => 'document-code',
							'target' => '_blank'
						],
						[
							'title' => t__('Header Menu'),
							'route' => 'dashboard.appearance.header.index',
							'category' => 'appearance.header',
							'icon' => 'menu'
						],
						[
							'title' => t__('Footer Menu'),
							'route' => 'dashboard.appearance.footer.index',
							'category' => 'appearance.footer',
							'icon' => 'menu'
						],
						[
							'title' => t__('Custom CSS'),
							'route' => 'dashboard.appearance.css.index',
							'category' => 'appearance.css',
							'icon' => 'brush-2'
						]
					]
				]
			]
		],
		'logs' => [
			'title' => t__('Logs'),
			'icon' => 'history',
			'module' => ['gift', 'store', 'chest', 'credit', 'lottery', 'bazaar'],
			'permission' => ['MANAGE_LOGS', 'MANAGE_STORE', 'MANAGE_LOTTERY', 'MANAGE_BAZAAR', 'MANAGE_GIFTS'],
			'items' => [
				[
					'title' => t__('Logs'),
					'items' => [
						[
							'title' => t__('Dashboard Logs'),
							'route' => 'dashboard.logs.index',
							'category' => 'logs.dashboard',
							'icon' => 'dashboard',
							'permission' => ['MANAGE_LOGS'],
						],
						[
							'title' => t__('Gift Logs'),
							'route' => 'dashboard.gifts.logs.index',
							'category' => 'logs.gift',
							'icon' => 'gift',
							'module' => ['gift'],
							'permission' => ['MANAGE_LOGS', 'MANAGE_GIFTS'],
						],
						[
							'title' => t__('Chest Logs'),
							'route' => 'dashboard.store.chest-logs.index',
							'category' => 'logs.chest',
							'icon' => 'strongbox',
							'module' => ['chest'],
							'permission' => ['MANAGE_LOGS', 'MANAGE_STORE'],
						],
						[
							'title' => t__('Coupon Logs'),
							'route' => 'dashboard.store.coupon-logs.index',
							'category' => 'logs.coupon',
							'icon' => 'ticket-discount',
							'module' => ['store'],
							'permission' => ['MANAGE_LOGS', 'MANAGE_STORE'],
						],
						[
							'title' => t__('Creator Code Logs'),
							'route' => 'dashboard.store.creator-code-logs.index',
							'category' => 'logs.creator-code',
							'icon' => 'ticket-star',
							'module' => ['store'],
							'permission' => ['MANAGE_LOGS', 'MANAGE_STORE'],
						],
						[
							'title' => t__('Credit Purchase Logs'),
							'route' => 'dashboard.store.credit-purchase-logs.index',
							'category' => 'logs.credit-purchase',
							'icon' => 'money-recive',
							'module' => ['credit'],
							'permission' => ['MANAGE_LOGS', 'MANAGE_STORE'],
						],
						[
							'title' => t__('Credit Usage Logs'),
							'route' => 'dashboard.store.credit-usage-logs.index',
							'category' => 'logs.credit-usage',
							'icon' => 'money-send',
							'module' => ['credit'],
							'permission' => ['MANAGE_LOGS', 'MANAGE_STORE'],
						],
						[
							'title' => t__('Fortune Wheel Logs'),
							'route' => 'dashboard.lotteries.logs.index',
							'category' => 'logs.lottery',
							'icon' => 'graph',
							'module' => ['lottery'],
							'permission' => ['MANAGE_LOGS', 'MANAGE_LOTTERY'],
						],
						[
							'title' => t__('Bazaar Logs'),
							'route' => 'dashboard.bazaar.logs.index',
							'category' => 'logs.bazaar',
							'icon' => 'shop',
							'module' => ['bazaar'],
							'permission' => ['MANAGE_LOGS', 'MANAGE_BAZAAR'],
						],
						[
							'title' => t__('Failed Jobs'),
							'route' => 'dashboard.failed-jobs.index',
							'category' => 'logs.failed-jobs',
							'icon' => 'programming-arrows',
							'permission' => ['MANAGE_LOGS'],
						],
					]
				]
			]
		],
		'misc' => [
			'title' => t__('Misc'),
			'icon' => 'category-2',
			'module' => ['games', 'leaderboards', 'lottery', 'vote', 'slider', 'announcements', 'download', 'suggestions', 'bazaar', 'popup'],
			'permission' => ['VIEW_STATS', 'MANAGE_GAMES', 'MANAGE_LEADERBOARDS', 'MANAGE_LOTTERY', 'MANAGE_VOTES', 'MANAGE_SLIDER', 'MANAGE_ANNOUNCEMENTS', 'MANAGE_DOWNLOADS', 'MANAGE_SUGGESTIONS', 'MANAGE_BAZAAR'],
			'items' => [
				[
					'title' => t__('Misc'),
					'items' => [
						[
							'title' => t__('Statistics'),
							'route' => 'dashboard.stats.index',
							'category' => 'misc.stats',
							'icon' => 'diagram',
							'permission' => ['VIEW_STATS'],
						],
						[
							'title' => t__('Gamemodes'),
							'route' => 'dashboard.games.index',
							'category' => 'misc.games',
							'icon' => 'game',
							'module' => ['games'],
							'permission' => ['MANAGE_GAMES'],
						],
						[
							'title' => t__('Leaderboards'),
							'route' => 'dashboard.leaderboards.index',
							'category' => 'misc.leaderboards',
							'icon' => 'cup',
							'module' => ['leaderboards'],
							'permission' => ['MANAGE_LEADERBOARDS'],
						],
						[
							'title' => t__('Fortune Wheel'),
							'route' => 'dashboard.lotteries.index',
							'category' => 'misc.lotteries',
							'icon' => 'graph',
							'module' => ['lottery'],
							'permission' => ['MANAGE_LOTTERY'],
						],
						[
							'title' => t__('Vote'),
							'route' => 'dashboard.votes.index',
							'category' => 'misc.votes',
							'icon' => 'like-1',
							'module' => ['vote'],
							'permission' => ['MANAGE_VOTES'],
						],
						[
							'title' => t__('Slider'),
							'route' => 'dashboard.sliders.index',
							'category' => 'misc.slider',
							'icon' => 'slider-horizontal',
							'module' => ['slider'],
							'permission' => ['MANAGE_SLIDER'],
						],
						[
							'title' => t__('Announcements'),
							'route' => 'dashboard.announcements.index',
							'category' => 'misc.announcements',
							'icon' => 'volume-low-1',
							'module' => ['announcements'],
							'permission' => ['MANAGE_ANNOUNCEMENTS'],
						],
						[
							'title' => t__('Download Center'),
							'route' => 'dashboard.downloads.index',
							'category' => 'misc.downloads',
							'icon' => 'cloud',
							'module' => ['download'],
							'permission' => ['MANAGE_DOWNLOADS'],
						],
						[
							'title' => t__('Suggestions'),
							'category' => 'misc.suggestions',
							'icon' => 'lamp-charge',
							'module' => ['suggestions'],
							'permission' => ['MANAGE_SUGGESTIONS'],
							'items' => [
								[
									'title' => t__('Suggestions'),
									'route' => 'dashboard.suggestions.index',
									'category' => 'misc.suggestions.suggestions',
									'icon' => 'lamp-charge'
								],
								[
									'title' => t__('Categories'),
									'route' => 'dashboard.suggestions.categories.index',
									'category' => 'misc.suggestions.categories',
									'icon' => 'category-2'
								]
							]
						],
						[
							'title' => t__('Bazaar'),
							'category' => 'misc.bazaar',
							'icon' => 'shop',
							'module' => ['bazaar'],
							'permission' => ['MANAGE_BAZAAR'],
							'items' => [
								[
									'title' => t__('Items'),
									'route' => 'dashboard.bazaar.index',
									'category' => 'misc.bazaar.items',
									'icon' => 'shop'
								],
								[
									'title' => t__('Servers'),
									'route' => 'dashboard.bazaar.servers.index',
									'category' => 'misc.bazaar.servers',
									'icon' => 'category-2'
								],
								[
									'title' => t__('Custom Item Images'),
									'route' => 'dashboard.bazaar.custom-item-images.index',
									'category' => 'misc.bazaar.custom-item-images',
									'icon' => 'gallery'
								],
								[
									'title' => t__('Settings'),
									'route' => 'dashboard.settings.bazaar.index',
									'category' => 'settings.bazaar',
									'icon' => 'setting-2',
									'permission' => ['MANAGE_SETTINGS'],
								],
							]
						],
						[
							'title' => t__('URL Redirects'),
							'route' => 'dashboard.redirects.index',
							'category' => 'misc.redirects',
							'icon' => 'link',
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Popup'),
							'route' => 'dashboard.popup.edit',
							'category' => 'misc.popup',
							'icon' => 'copy',
							'module' => ['popup'],
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('AI'),
							'category' => 'misc.ai',
							'icon' => 'cpu',
							'module' => ['ai'],
							'permission' => ['MANAGE_AI'],
							'items' => [
								[
									'title' => t__('Overview'),
									'route' => 'dashboard.ai.index',
									'category' => 'misc.ai.index',
									'icon' => 'activity',
								],
								[
									'title' => t__('Data Sources'),
									'route' => 'dashboard.ai.data.index',
									'category' => 'misc.ai.data',
									'icon' => 'data',
								],
								[
									'title' => t__('Settings'),
									'route' => 'dashboard.ai.settings.index',
									'category' => 'misc.ai.settings',
									'icon' => 'setting-2',
								]
							]
						],
					]
				]
			]
		],
		'settings' => [
			'title' => t__('Settings'),
			'permission' => ['MANAGE_SETTINGS', 'MANAGE_PAYMENT', 'MANAGE_MODULES', 'MANAGE_UPDATES'],
			'items' => [
				[
					'title' => t__('Settings'),
					'items' => [
						[
							'title' => t__('General'),
							'route' => 'dashboard.settings.general.index',
							'category' => 'settings.general',
							'icon' => 'setting-5',
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('System'),
							'route' => 'dashboard.settings.system.index',
							'category' => 'settings.system',
							'icon' => 'cpu',
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Payment Methods'),
							'route' => 'dashboard.payment-gateways.index',
							'category' => 'settings.payment-gateways',
							'icon' => 'card-add',
							'permission' => ['MANAGE_PAYMENT'],
						],
						[
							'title' => t__('Currencies'),
							'route' => 'dashboard.settings.currencies.index',
							'category' => 'settings.currencies',
							'icon' => 'money-send',
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('SEO'),
							'route' => 'dashboard.settings.seo.index',
							'category' => 'settings.seo',
							'icon' => 'search-status',
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Languages'),
							'route' => 'dashboard.settings.languages.index',
							'category' => 'settings.languages',
							'icon' => 'language-square',
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Account Linking'),
							'route' => 'dashboard.settings.account-linking.index',
							'category' => 'settings.account-linking',
							'icon' => 'link-21',
							'module' => ['account_linking'],
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Discord Webhooks'),
							'route' => 'dashboard.discord-webhooks.index',
							'category' => 'settings.discord-webhooks',
							'icon' => 'webhook',
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('SMTP'),
							'route' => 'dashboard.settings.smtp.index',
							'category' => 'settings.smtp',
							'icon' => 'directbox-send',
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Email Templates'),
							'route' => 'dashboard.settings.email-templates.index',
							'category' => 'settings.email-templates',
							'icon' => 'directbox-notif',
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Discord Bot (Legacy)'),
							'route' => 'dashboard.settings.discord-bot-legacy.index',
							'category' => 'settings.discord-bot-legacy',
							'icon' => 'discord',
							'module' => ['discord'],
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Discord Bot'),
							'route' => 'dashboard.settings.discord-bot.index',
							'category' => 'settings.discord-bot',
							'icon' => 'discord',
							'module' => ['discord_bot'],
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Punishments'),
							'route' => 'dashboard.settings.punishments.index',
							'category' => 'settings.punishments',
							'icon' => 'forbidden',
							'module' => ['punishments'],
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Paraşüt'),
							'route' => 'dashboard.settings.parasut.index',
							'category' => 'settings.parasut',
							'icon' => 'document-text',
							'module' => ['parasut'],
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('BirFatura'),
							'route' => 'dashboard.settings.birfatura.index',
							'category' => 'settings.birfatura',
							'icon' => 'document-text',
							'module' => ['birfatura'],
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('%module% Settings', ['%module%' => t__('Store')]),
							'route' => 'dashboard.settings.store.index',
							'category' => 'settings.store',
							'icon' => 'shopping-cart',
							'module' => ['store'],
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('%module% Settings', ['%module%' => t__('Credit')]),
							'route' => 'dashboard.settings.credit.index',
							'category' => 'settings.credit',
							'icon' => 'wallet',
							'module' => ['credit'],
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('%module% Settings', ['%module%' => t__('Support')]),
							'route' => 'dashboard.settings.support.index',
							'category' => 'settings.support',
							'icon' => 'lifebuoy',
							'module' => ['support'],
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Modules'),
							'route' => 'dashboard.modules.index',
							'category' => 'settings.modules',
							'icon' => 'category',
							'permission' => ['MANAGE_MODULES'],
						],
						[
							'title' => t__('API'),
							'route' => 'dashboard.settings.api.index',
							'category' => 'settings.api',
							'icon' => 'data',
							'permission' => ['MANAGE_SETTINGS'],
						],
						[
							'title' => t__('Updates'),
							'route' => 'dashboard.updates.index',
							'category' => 'settings.updates',
							'icon' => 'refresh-2',
							'permission' => ['MANAGE_UPDATES'],
						]
					]
				],
			]
		],
	];
?>

<?php $rootCategory = explode('.', $category, 2)[0]; ?>
<aside x-bind="aside" x-data="{'sideTab': '<?php echo $rootCategory; ?>'}">
	<div :class="{'side-leader': sideColorBlue}" id="side">
		<!-- logo -->
		<a href="<?php echo url('dashboard.home') ?>" class="center">
			<div class="center bg-blue-100 rounded-xl w-9 h-9">
				<img class="w-6 h-6"
				     src="<?php echo $this->asset('/img/leaderos-icon.png'); ?>"
				     alt="LeaderOS Logo">
			</div>
		</a>
		
		<!-- menus -->
		<nav class="navbar mt-6">
			<?php foreach ($sidebar as $sidebarItemKey => $sidebarItem): ?>
				<?php
				if ($sidebarItemKey == 'settings')
					continue;
				
				if (isset($sidebarItem["module"]) && !checkModuleStatus($sidebarItem["module"]))
					continue;
				
				if (isset($sidebarItem["permission"]) && !auth()->user()->can($sidebarItem["permission"]))
					continue;
				
				if (isset($sidebarItem["show"]) && !$sidebarItem["show"])
					continue;
				?>
				
				<?php if (isset($sidebarItem["url"])): ?>
					<a href="<?php echo $sidebarItem["url"]; ?>" target="_blank" class="nav-item"
					   x-bind="tooltip('<?php echo $sidebarItem["title"]; ?>', 'right')">
						<?php if (isset($sidebarItem["svg"])): ?>
							<?php echo $sidebarItem["svg"]; ?>
						<?php else: ?>
							<i data-feather="<?php echo $sidebarItem["icon"] ?? 'home-2' ?>"></i>
						<?php endif; ?>
					</a>
				<?php else: ?>
					<div x-bind="tooltip('<?php echo $sidebarItem["title"]; ?>', 'right')"
					     :class="'nav-item ' + (sideTab == '<?php echo $sidebarItemKey; ?>' ? 'active' : '')"
					     @click="toggleSideDetails('<?php echo $sidebarItemKey; ?>')"
					>
						<?php if (isset($sidebarItem["svg"])): ?>
							<?php echo $sidebarItem["svg"]; ?>
						<?php else: ?>
							<i data-feather="<?php echo $sidebarItem["icon"] ?? 'home-2' ?>"></i>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			<?php endforeach; ?>
		</nav>
		
		<div class="mt-3 lg:mt-auto grid gap-6">
			<nav class="navbar">
				<?php if (auth()->user()->can('MANAGE_SETTINGS')): ?>
					<a x-bind="tooltip('<?php e__('Settings') ?>', 'right')"
					   class="nav-item <?php echo $rootCategory == 'settings' ? 'active' : null ?>"
					   href="<?php echo url('dashboard.settings.index') ?>">
						<i data-feather="setting-2"></i>
					</a>
				<?php endif; ?>
			</nav>
			<div x-data="dropdown()" class="relative flex justify-center items-center">
				<div @click="toggle()" href="<?php echo url('dashboard.accounts.show', ['id' => auth()->user()->id()]) ?>" class="cursor-pointer">
					<?php $this->insert('components/avatar', [
						'avatar' => auth()->user()->avatar(),
						'username' => auth()->user()->displayName(),
						'class' => '!rounded-xl w-8',
						'size' => '42px'
					]); ?>
				</div>
				<div x-bind="isDropdown" class="dropdown w-[180px] !-top-[90px] !left-[50px]">
					<div class="relative px-4 pt-2 pb-3 text-sm border-b border-gray-500/25 dark:border-gray-600/20">
						<div class="font-semibold dark:text-gray-300">
							<?php echo auth()->user()->displayName(); ?>
						</div>
						<div class="text-gray-500 dark:text-gray-400 text-xs">
							<?php if (settings('loginProvider') == 'default' &&  auth()->user()->email() != null): ?>
								<?php echo auth()->user()->email(); ?>
							<?php else: ?>
							  @<?php echo auth()->user()->username(); ?>
							<?php endif; ?>
						</div>
					</div>
					<a class="!text-gray-500 dark:!text-gray-300" href="<?php echo url('dashboard.accounts.show', ['id' => auth()->user()->id()]) ?>">
						<div class="flex items-center gap-2 text-sm">
							<?php e__('Profile') ?>
						</div>
					</a>
					<form action="/logout" method="post">
						<?php _csrf(); ?>
						<button type="submit" class="flex items-center text-left gap-2 text-sm !text-gray-500 dark:!text-gray-300">
							<?php e__('Logout') ?>
						</button>
					</form>
				</div>
			</div>
		</div>
	</div>
	
	<div id="side-details" class="overflow-y-auto"
	     :class="{ 'side-leader': sideColorBlue, 'expanded': (sideDetails || alwaysSideDetailsOpen) && (sideTab !== 'dashboard')}">
		<div class="">
			<?php foreach ($sidebar as $sidebarRootKey => $sidebarRoot): ?>
				<?php
				if (isset($sidebarRoot["module"]) && !checkModuleStatus($sidebarRoot["module"]))
					continue;
				
				if (isset($sidebarRoot["permission"]) && !auth()->user()->can($sidebarRoot["permission"]))
					continue;
				
				if (isset($sidebarRoot["show"]) && !$sidebarRoot["show"])
					continue;
				?>
				<div x-show="sideTab === '<?php echo $sidebarRootKey ?>'">
					<?php foreach ($sidebarRoot["items"] as $sidebarItem): ?>
						<?php
						if (isset($sidebarItem["module"]) && !checkModuleStatus($sidebarItem["module"]))
							continue;
						
						if (isset($sidebarItem["permission"]) && !auth()->user()->can($sidebarItem["permission"]))
							continue;
						
						if (isset($sidebarItem["show"]) && !$sidebarItem["show"])
							continue;
						?>
						<div class="text-gray-200/60 tracking-wider text-xs font-medium px-4">
							<?php echo $sidebarItem["title"] ?>
						</div>
						<nav class="navbar mt-2 mb-4">
							<?php foreach ($sidebarItem["items"] as $sidebarSubitem): ?>
								<?php
								if (isset($sidebarSubitem["module"]) && !checkModuleStatus($sidebarSubitem["module"]))
									continue;
								
								if (isset($sidebarSubitem["permission"]) && !auth()->user()->can($sidebarSubitem["permission"]))
									continue;
								
								if (isset($sidebarSubitem["show"]) && !$sidebarSubitem["show"])
									continue;
								?>
								<?php if (isset($sidebarSubitem["items"])): ?>
									<?php
									$parsedCategory = explode('.', $category);
									if (count($parsedCategory) >= 2)
										$parsedCategory = $parsedCategory[0] . '.' . $parsedCategory[1];
									else
										$parsedCategory = null;
									
									$active = isset($sidebarSubitem["category"]) && $sidebarSubitem["category"] == $parsedCategory;
									?>
									<div class="select-none" x-data="{showDeep: <?php echo $active ? 'true' : 'false' ?>}">
										<div
											class="cursor-pointer justify-between nav-item"
											@click="showDeep = !showDeep"
										>
											<div class="flex gap-3 items-center">
												<?php if (isset($sidebarSubitem["svg"])): ?>
													<?php echo $sidebarSubitem["svg"]; ?>
												<?php else: ?>
													<i data-feather="<?php echo $sidebarSubitem['icon'] ?>"></i>
												<?php endif; ?>
												<span><?php echo $sidebarSubitem["title"] ?></span>
											</div>
											<div :class="{'-rotate-90':showDeep}" class="transition-all">
												<i data-feather="arrow-down" class="w-4 h-4"></i>
											</div>
										</div>
										<div
											class="pl-7 nav-alt-menu"
											x-show="showDeep"
											x-collapse.duration.500ms
										>
											<?php foreach ($sidebarSubitem["items"] as $sidebarDeepSubitem): ?>
												<?php
												if (isset($sidebarDeepSubitem["module"]) && !checkModuleStatus($sidebarDeepSubitem["module"]))
													continue;
												
												if (isset($sidebarDeepSubitem["permission"]) && !auth()->user()->can($sidebarDeepSubitem["permission"]))
													continue;
												
												if (isset($sidebarDeepSubitem["show"]) && !$sidebarDeepSubitem["show"])
													continue;
												
												$active = isset($sidebarDeepSubitem["category"]) && $sidebarDeepSubitem["category"] == $category;
												?>
												<a
													href="<?php echo (isset($sidebarDeepSubitem["url"])) ? $sidebarDeepSubitem["url"] : url($sidebarDeepSubitem["route"]) ?>"
													class="nav-item <?php echo $active ? 'active' : null ?>"
													<?php echo isset($sidebarSubitem["target"]) ? 'target="' . $sidebarSubitem["target"] . '"' : null ?>
												>
													<?php if (isset($sidebarDeepSubitem["svg"])): ?>
														<?php echo $sidebarDeepSubitem["svg"]; ?>
													<?php else: ?>
														<?php if (isset($sidebarDeepSubitem['icon'])): ?>
															<i data-feather="<?php echo $sidebarDeepSubitem['icon'] ?>"></i>
														<?php endif; ?>
													<?php endif; ?>
													<?php echo $sidebarDeepSubitem["title"] ?>
												</a>
											<?php endforeach; ?>
										</div>
									</div>
								<?php else: ?>
									<?php $active = isset($sidebarSubitem["category"]) && $sidebarSubitem["category"] == $category; ?>
									<a
										href="<?php echo (isset($sidebarSubitem["url"])) ? $sidebarSubitem["url"] : url($sidebarSubitem["route"]) ?>"
										class="nav-item <?php echo $active ? 'active' : null ?>"
										<?php echo isset($sidebarSubitem["target"]) ? 'target="' . $sidebarSubitem["target"] . '"' : null ?>
									>
										<?php if (isset($sidebarSubitem["svg"])): ?>
											<?php echo $sidebarSubitem["svg"]; ?>
										<?php else: ?>
											<i data-feather="<?php echo $sidebarSubitem['icon'] ?>"></i>
										<?php endif; ?>
										<?php echo $sidebarSubitem["title"] ?>
									</a>
								<?php endif; ?>
							<?php endforeach; ?>
						</nav>
					<?php endforeach; ?>
				</div>
			<?php endforeach; ?>
		</div>
	</div>
	
	<div @click="toggleActiveMenu()" class="closeMenu">
		<i class="stroke-white w-8" data-feather="close"></i>
	</div>
</aside>
