<?php
	namespace Dashboard\Core;
	
	class Auth {
		private static ?User $user = null;
		
		public function __construct()
		{
			if (isset($_SESSION['user'])) {
        self::$user = new User(
					$_SESSION['user']["id"],
					$_SESSION['user']["username"],
					$_SESSION['user']["realname"],
					$_SESSION['user']["email"],
					$_SESSION['user']["avatar"],
	        $_SESSION['user']["isTfaVerified"],
					$_SESSION['user']["roles"],
					$_SESSION['user']["permissions"],
					$_SESSION['user']["supportPermissions"],
					$_SESSION['user']
        );
			}
		}
		
		public static function user(): ?User
		{
			return self::$user;
		}
		
		public static function check(): bool
		{
			return isset($_SESSION['user']);
		}
		
		public static function logout(): void
		{
			// Set the expiry date to now and end the session
			if (isset($_SESSION['login'])) {
				$updateSession = db()->prepare("UPDATE AccountSessions SET expiryDate = ? WHERE loginToken = ?");
				$updateSession->execute([datetime(), $_SESSION['login']]);
			}
			
			removeCookie("rememberMe");
			unset($_SESSION['login']);
			unset($_SESSION['user']);
		}
	}