'use strict';

const JSTree = function () {
    var $jstree = $('[data-toggle="jstree"]');
    var $jstreeSearch = $('[data-toggle="jstree-search"]');
    var $jstreeValue = $('[data-toggle="jstree-value"]');
    var $jstreeJSON = $jstree.attr("json");
    var $timeout = false;

    // Init
    function init($jstree) {
        const $options = {
            core: {
                themes: {
                    name: 'default'
                },
                strings: {"Loading ...": lang.loading},
                multiple: true,
                animation: 0,
                data: {
                    url: $jstreeJSON,
                    dataType: "json"
                }
            },
            types: {
                server: {
                    icon: "fas fa-server"
                },
                category: {
                    icon: "fas fa-folder"
                },
                product: {
                    icon: "fas fa-tag"
                }
            },
            plugins: ["types", "checkbox", "search"]
        }
        $jstree.jstree($options);
        $jstreeSearch.keyup(function () {
            if($timeout) {
                clearTimeout($timeout);
            }
            $timeout = setTimeout(function () {
                var $value = $jstreeSearch.val();
                $jstree.jstree(true).search($value);
            }, 250);
        });
        $jstree.on("changed.jstree", function (e, data) {
            var i, j, r = [];
            for(i = 0, j = data.selected.length; i < j; i++) {
                if (data.instance.get_node(data.selected[i]).type == "product") {
                    r.push(data.instance.get_node(data.selected[i]).id);
                }
            }
            $jstreeValue.val(r.join(','));
        });
        if ($jstreeValue.val()) {
            $jstree.on("ready.jstree", function (e, data, selected, event) {
                var ref = $jstree.jstree(true);
                ref.close_all();
                ref.deselect_all(true);
                ref.select_node([$jstreeValue.val().split(",")]);
            });
        }
    }
    if ($jstree.length) {
        $jstree.each(function() {
            init($(this));
        });
    }
}

JSTree()