// $(document).ready(function() {
//     $('[data-toggle="select"]').select2({
//         minimumResultsForSearch: -1
//     });
// });

function select2Alpine(searched = false, dfvalue = '') {
    return {
        selected: '',
        select2: null,
        init() {
            this.$nextTick(() => {
                const searchedSelect = searched ? 1 : -1
                const placeholder = this.$el.getAttribute('placeholder')
                this.select2 = $(this.$el).select2({
                    placeholder: placeholder,
                    minimumResultsForSearch: searchedSelect,
                })

                if (dfvalue != '') {
                    this.select2.val(dfvalue).trigger("change")
                }

                this.select2.on('select2:select', event => {
                    this.selected = event.target.value
                })

                this.$watch("selected", value => {
                    this.select2.val(value).trigger("change")
                })
            })
        },
        changed(name, func = () => {}) {
            this.$nextTick(() => {
                this.$watch('selected', () => {
                    func()
                });
                /*this.$watch(name, value => {
                    this.select2.val(value).trigger('change')
                })*/
            })
        },
        onChange(func = () => {}) {
            this.$nextTick(() => {
                this.select2.on('change', (e) => {
                    func(e);
                })
                /*this.$watch(name, value => {
                    this.select2.val(value).trigger('change')
                })*/
            })
        }
    }
}