<?php
	
	use Install\Controllers\DataController;
	use Install\Controllers\InstallerController;
	use Pecee\SimpleRouter\SimpleRouter as Router;

	Router::get('/', [InstallerController::class, 'index'])->name('install.index');
	
	Router::group([
		'prefix' => '/steps'
	], function () {
		Router::post('/compatibility', [InstallerController::class, 'compatibility'])->name('install.steps.compatibility');
		Router::post('/database', [InstallerController::class, 'database'])->name('install.steps.database');
		Router::post('/general', [InstallerController::class, 'general'])->name('install.steps.general');
		Router::post('/admin', [InstallerController::class, 'admin'])->name('install.steps.admin');
		Router::post('/run', [InstallerController::class, 'run'])->name('install.steps.run');
	});
	
	Router::group([
		'prefix' => '/data'
	], function () {
		Router::get('/languages', [DataController::class, 'languages'])->name('install.data.languages');
		Router::get('/timezones', [DataController::class, 'timezones'])->name('install.data.timezones');
		Router::get('/currencies', [DataController::class, 'currencies'])->name('install.data.currencies');
	});
