<?php
	
	namespace Install\Controllers;
	
	use DateTime;
	use DateTimeZone;
	use Install\Core\Controller;
	use Install\Services\VariablesService;
	
	class DataController extends Controller
	{
		public function languages()
		{
			response()->json(VariablesService::$languages);
		}
		
		public function timezones()
		{
			$zoneIdentifiers = timezone_identifiers_list();
			$zoneLocations = array();
			
			foreach ($zoneIdentifiers as $zoneIdentifier) {
				$zone = explode('/', $zoneIdentifier);
				$desiredRegions = array(
					'Africa', 'America', 'Antarctica', 'Arctic', 'Asia', 'Atlantic', 'Australia', 'Europe', 'Indian', 'Pacific'
				);
				if (in_array($zone[0], $desiredRegions)) {
					if (isset($zone[1]) != '') {
						$area = str_replace('_', ' ', $zone[1]);
						if (!empty($zone[2]))
						{
							$area = $area . ' (' . str_replace('_', ' ', $zone[2]) . ')';
						}
						$zoneLocations[$zone[0]][$zoneIdentifier] = $zone[0] . '/' .  $area;
					}
				}
			}
			
			$timezones = [];
			foreach($zoneLocations as $zoneRegion => $regionAreas) {
				foreach($regionAreas as $regionArea => $zoneLabel) {
					$currentTimeInZone = new DateTime("now", new DateTimeZone($regionArea));
					$currentTimeDiff = $currentTimeInZone->format('P');
					$timezones[] = [
						'value' => $regionArea,
						'label' => '(GMT '.$currentTimeDiff.') '.$zoneLabel
					];
				}
			}
			response()->json($timezones);
		}
		
		public function currencies()
		{
			response()->json(VariablesService::$currencies);
		}
	}