<?php
	
	namespace Install\Controllers;
	
	use Install\Core\Controller;
	use Install\Services\VariablesService;
	use PDO;
	use PDOException;
	use Verot\Upload\Upload;
	
	class InstallerController extends Controller
	{
		public function index()
		{
			ob_start();
			include '../public/assets/index.html';
			$html_content = ob_get_contents();
			ob_end_clean();
			
			// Replace CSRF Token and LeaderOS License Location
			$html_content = str_replace(
				[
					'REPLACE_CSRF_TOKEN',
					'REPLACE_LEADEROS_LOCATION'
				],
				[
					csrf_token(),
					LOCATION
				],
				$html_content
			);
			
			echo $html_content;
		}
		
		public function compatibility()
		{
			$php = checkPhp();
			$ioncube = checkCompatibility('ionCube Loader');
			$ctype = checkCompatibility('ctype');
			$fileinfo = checkCompatibility('fileinfo', false);
			$json = checkCompatibility('json');
			$mbstring = checkCompatibility('mbstring');
			$openssl = checkCompatibility('openssl');
			$pdo = checkCompatibility('PDO');
			$tokenizer = checkCompatibility('tokenizer', false);
			$zip = checkCompatibility('zip');
			$curl = checkCompatibility('curl');
			$phpSettings = [
				'allow_url_fopen' => checkPhpSettings('allow_url_fopen', true),
				'max_input_vars' => checkPhpSettings('max_input_vars', 10000, '>=', false)
			];
			$isWriteable = checkIsWriteable($_SERVER["DOCUMENT_ROOT"] . '/apps/main/app/config/connect.php');
			
			// Check PHP Settings
			$phpSettingsStatus = 'success';
			
			foreach ($phpSettings as $setting) {
				if ($setting['status'] === 'error') {
					$phpSettingsStatus = 'error';
					break;
				} elseif ($setting['status'] === 'warning') {
					$phpSettingsStatus = 'warning';
					break;
				}
			}
			
			response()->json([
				[
					'status'  => $isWriteable['status'],
					'label'   => 'File Permissions',
					'content' => $isWriteable['message']
				],
				[
					'status'  => $php['status'],
					'label'   => 'PHP',
					'content' => $php['version']
				],
				[
					'status'  => $phpSettingsStatus,
					'label'   => 'PHP Settings',
					'content' => $phpSettingsStatus == 'success' ? 'ok' : 'check php.ini'
				],
				[
					'status'  => $ioncube['status'],
					'label'   => 'Ioncube',
					'content' => $ioncube['message']
				],
				[
					'status'  => $ctype['status'],
					'label'   => 'Ctype PHP Extension',
					'content' => $ctype['message']
				],
				[
					'status'  => $fileinfo['status'],
					'label'   => 'Fileinfo PHP Extension',
					'content' => $fileinfo['message'],
				],
				[
					'status'  => $json['status'],
					'label'   => 'JSON PHP Extension',
					'content' => $json['message']
				],
				[
					'status'  => $mbstring['status'],
					'label'   => 'Mbstring PHP Extension',
					'content' => $mbstring['message']
				],
				[
					'status'  => $openssl['status'],
					'label'   => 'OpenSSL PHP Extension',
					'content' => $openssl['message']
				],
				[
					'status'  => $pdo['status'],
					'label'   => 'PDO PHP Extension',
					'content' => $pdo['message']
				],
				[
					'status'  => $tokenizer['status'],
					'label'   => 'Tokenizer PHP Extension',
					'content' => $tokenizer['message']
				],
				[
					'status'  => $zip['status'],
					'label'   => 'Zip PHP Extension',
					'content' => $zip['message']
				],
				[
					'status'  => $curl['status'],
					'label'   => 'Curl PHP Extension',
					'content' => $curl['message']
				]
			]);
		}
		
		public function database()
		{
			validate([
				'mysqlServer'   => 'required',
				'mysqlPort'     => 'required|numeric',
				'mysqlUsername' => 'required',
				'mysqlPassword' => 'required',
				'mysqlDatabase' => 'required',
			]);
			
			/*
			 * echo json_encode([
					'success' => false,
					'errors'  => [
						'fill_fields',
					]
				]);
			 */
			
			$mysqlServer   = input("mysqlServer");
			$mysqlPort     = input("mysqlPort");
			$mysqlUsername = input("mysqlUsername");
			$mysqlPassword = input("mysqlPassword");
			$mysqlDatabase = input("mysqlDatabase");
			
			try {
				$db = new PDO("mysql:host=$mysqlServer;port=$mysqlPort;dbname=$mysqlDatabase;charset=utf8mb4", $mysqlUsername, $mysqlPassword);
			} catch (PDOException $e) {
				response()->json([
					'success' => false,
					'errors'  => [
						'steps.2.database_connection_error',
						utf8_encode($e->getMessage()),
					]
				]);
			}
			
			response()->json([
				'success' => true,
			]);
		}
		
		public function general()
		{
			validate([
				'siteSlogan' => 'required',
				'siteServerName' => 'required',
				'siteServerIP' => 'required',
				'sitePasswordType' => 'required',
				'siteMaintenance' => 'required',
				'siteCurrency' => 'required',
				'siteLanguage' => 'required',
				'siteTimezone' => 'required',
			]);
			
			response()->json([
				'success' => true,
			]);
		}
		
		public function admin()
		{
			validate([
				'loginProvider' => 'required',
				'accountUsername' => 'required',
				'accountRealname' => 'required',
				'accountEmail' => 'required_if:loginProvider,default|email',
				'accountPassword' => 'required_if:loginProvider,default|min:4',
				'accountPasswordRe' => 'required_if:loginProvider,default|same:accountPassword',
				'mysqlServer'   => 'required',
				'mysqlPort'     => 'required|numeric',
				'mysqlUsername' => 'required',
				'mysqlPassword' => 'required',
				'mysqlDatabase' => 'required',
			]);
			
			$mysqlServer   = input("mysqlServer");
			$mysqlPort     = input("mysqlPort");
			$mysqlUsername = input("mysqlUsername");
			$mysqlPassword = input("mysqlPassword");
			$mysqlDatabase = input("mysqlDatabase");
			
			try {
				$db = new PDO("mysql:host=$mysqlServer;port=$mysqlPort;dbname=$mysqlDatabase;charset=utf8mb4", $mysqlUsername, $mysqlPassword);
			}
			catch (PDOException $e) {
				die('<strong>MySQL connection error: </strong>'.utf8_encode($e->getMessage()));
			}
			
			$usernameValid = $db->prepare("SELECT * FROM Accounts WHERE username = ?");
			$usernameValid->execute(array(input("accountUsername")));
			if ($usernameValid->rowCount() > 0) {
				response()->json([
					'success' => false,
					'errors'  => [
						'username_taken',
					]
				]);
			}
			
			if (input('accountEmail') != null) {
				$emailValid = $db->prepare("SELECT * FROM Accounts WHERE email = ?");
				$emailValid->execute(array(input("accountEmail")));
				if ($emailValid->rowCount() > 0) {
					response()->json([
						'success' => false,
						'errors'  => [
							'email_taken',
						]
					]);
				}
			}
			
			response()->json([
				'success' => true,
			]);
		}
		
		public function run()
		{
			$mysqlServer   = input("mysqlServer");
			$mysqlPort     = input("mysqlPort");
			$mysqlUsername = input("mysqlUsername");
			$mysqlPassword = input("mysqlPassword");
			$mysqlDatabase = input("mysqlDatabase");
			
			try {
				$db = new PDO("mysql:host=$mysqlServer;port=$mysqlPort;dbname=$mysqlDatabase;charset=utf8mb4", $mysqlUsername, $mysqlPassword);
			}
			catch (PDOException $e) {
				response()->json([
					"success" => false,
					"errors"  => [
						"MySQL connection error: ".utf8_encode($e->getMessage()),
					]
				]);
			}
			
			$dbConnectionForCreate = new PDO("mysql:host=$mysqlServer;port=$mysqlPort;dbname=$mysqlDatabase;charset=utf8mb4", $mysqlUsername, $mysqlPassword);
			$dbFileContents = file_get_contents($_SERVER["DOCUMENT_ROOT"] . '/apps/install/database/migrations/database.sql');
			$dbCreate = $dbConnectionForCreate->exec($dbFileContents);
			$dbConnectionForCreate=null;
			
			$connectFile = ($_SERVER["DOCUMENT_ROOT"] . '/apps/main/app/config/connect.php');
			$connectFileData =
				'<?php
  define(\'DB_HOST\', \''.$mysqlServer.'\');
  define(\'DB_PORT\', \''.$mysqlPort.'\');
  define(\'DB_USERNAME\', \''.$mysqlUsername.'\');
  define(\'DB_PASSWORD\', \''.phpFileEscape($mysqlPassword).'\');
  define(\'DB_NAME\', \''.$mysqlDatabase.'\');

  try {
    $db = new PDO("mysql:host=".DB_HOST.";port=".DB_PORT.";dbname=".DB_NAME.";charset=utf8mb4", DB_USERNAME, DB_PASSWORD);
  }
  catch (PDOException $e) {
    die("MySQL connection error: ".utf8_encode($e->getMessage()));
  }
?>';
			$updateConnectFile = file_put_contents($connectFile, $connectFileData) OR die(json_encode([
				"success" => false,
				"errors"  => [
					"File error! Please contact LeaderOS. (connect.php)",
				]
			]));
			
			$statusFile = ($_SERVER["DOCUMENT_ROOT"] . '/apps/main/app/config/status.php');
			$statusFileData =
				'<?php
  define(\'INSTALL_STATUS\', true);
  define(\'VERSION\', \''.VERSION.'\');
  define(\'BUILD_NUMBER\', '.BUILD_NUMBER.');
?>';
			$updateStatusFile = file_put_contents($statusFile, $statusFileData) OR die(json_encode([
				"success" => false,
				"errors"  => [
					"File error! Please contact LeaderOS. (status.php)",
				]
			]));
			
			$appFile = ($_SERVER["DOCUMENT_ROOT"] . '/apps/main/app/config/app.php');
			$appFileData =
				'<?php
  define(\'APP_KEY\', \''.md5(uniqid(mt_rand(), true)).'\');
  define(\'LOCATION\', \''.LOCATION.'\');
?>';
			$updateAppFile = file_put_contents($appFile, $appFileData) OR die(json_encode([
				"success" => false,
				"errors"  => [
					"File error! Please contact LeaderOS. (app.php)",
				]
			]));

			
			if (LOCATION === "TR") {
				$smtpPasswordTitle = "Şifre sıfırlama bağlantısı";
				$smtpPasswordTemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>Recover Account</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }

</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
Şifre sıfırlama talebinizi aldık, aşağıdaki bağlantıyı kullanarak şifrenizi değiştirebilirsiniz.
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Merhaba <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Şifre sıfırlama talebinizi aldık, aşağıdaki bağlantıyı kullanarak şifrenizi değiştirebilirsiniz.</p>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">Şifre Değiştir</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Çalışmadı mı? Aşağıdaki bağlantıyı kullanabilirsiniz.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. Tüm hakları saklıdır.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
				
				$smtpVerifyEmailChangeTitle = "Email değişikliğinizi onaylayın";
				$smtpVerifyEmailChangeTemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>Confirm Email Change</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }

</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
Hesabınıza ait email değiştirme işlemini onaylamak için bağlantıya tıklayın.
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Merhaba <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Hesabınıza ait email değiştirme işlemini onaylamak için lütfen aşağıdaki bağlantıya tıklayın:</p>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">Email Değişikliğini Onayla</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Bu bağlantıya tıkladığınızda e-posta adresiniz <strong>%email%</strong> olarak değişecektir. Eğer bu değişikliği talep etmediyseniz, bağlantıya tıklamayın ve hesabınızı güvenceye almak için şifrenizi hemen değiştirin!</p>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Çalışmadı mı? Aşağıdaki bağlantıyı kullanabilirsiniz.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. Tüm hakları saklıdır.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
			} else {
				$smtpPasswordTitle = "Reset your password!";
				$smtpPasswordTemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>Recover Account</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }

</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
We have received your password reset request, you can change your password using the link below.
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Dear <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">We have received your password reset request, you can change your password using the link below.</p>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">Change Password</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Didn\'t it work? You can use the link below.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. All rights reserved.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
				
				$smtpVerifyEmailChangeTitle = "Confirm Your Email Change";
				$smtpVerifyEmailChangeTemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>Confirm Email Change</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }

</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
Confirm your email address changes using the link below.
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Dear <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">We received a request to change the email address associated with your account. To confirm this change, please click the link below:</p>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">Confirm Email Change</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Clicking the link will update your email to <strong>%email%</strong>. If you did not request this change, do not click the link and immediately change your password to secure your account.</p>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Didn\'t it work? You can use the link below.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. All rights reserved.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
			}
			/* Header */
			$header = array_map(function ($item) {
				$item["id"] = md5(uniqid(mt_rand(), true));
				
				return $item;
			}, VariablesService::$header);
			$headerJSON = json_encode($header);
			
			/* Footer */
			$footer = array_map(function ($item) {
				$item["id"] = md5(uniqid(mt_rand(), true));
				$item["children"] = array_map(function ($childrenItem) {
					$childrenItem["id"] = md5(uniqid(mt_rand(), true));
					
					return $childrenItem;
				}, $item["children"]);
				
				return $item;
			}, VariablesService::$footer);
			$footerJSON = json_encode($footer);
			
			$themeName = "flat";
			
			$settings = [
				'autoInstallation' => 'COMPLETED',
				'apiStatus' => '1',
				'apiKey' => input("apiKey"),
				'gameType' => input("game"),
				'loginProvider' => input("loginProvider"),
				'websiteURL' => '',
				'themeName' => $themeName,
				'serverName' => input("siteServerName"),
				'siteSlogan' => input("siteSlogan"),
				'serverIP' => input("siteServerIP"),
				'serverVersion' => '',
				'siteDescription' => '',
				'facebookUrl' => '',
				'twitterUrl' => '',
				'instagramUrl' => '',
				'youtubeUrl' => '',
				'discordUrl' => '',
				'tiktokUrl' => '',
				'about' => '',
				'passwordType' => input("sitePasswordType"),
				'maintenanceStatus' => input("siteMaintenance"),
				'avatarAPI' => '1',
				'onlineAPI' => '1',
				'sslStatus' => '0',
				'debugModeStatus' => '0',
				'registerLimit' => '-1',
				'smtpServer' => '',
				'smtpPort' => '',
				'smtpSecure' => '1',
				'smtpSenderEmail' => '',
				'smtpUsername' => '',
				'smtpPassword' => '',
				'smtpPasswordTitle' => $smtpPasswordTitle,
				'smtpPasswordTemplate' => $smtpPasswordTemplate,
				'smtpVerifyEmailChangeTitle' => $smtpVerifyEmailChangeTitle,
				'smtpVerifyEmailChangeTemplate' => $smtpVerifyEmailChangeTemplate,
				'emailChangeVerification' => '0',
				'updateNotifications' => '1',
				'lastCheckCurrencies' => '1000-01-01 00:00:00',
				'lastCheckAccounts' => '1000-01-01 00:00:00',
				'totalAccountCount' => '0',
				'thisYearAccountCount' => '0',
				'thisMonthAccountCount' => '0',
				'lastMonthAccountCount' => '0',
				'language' => input("siteLanguage"),
				'timezone' => input("siteTimezone"),
				'currency' => input("siteCurrency"),
				'registrationStatus' => '1',
				"forceDefaultLanguage" => LOCATION === "TR" ? "1" : "0",
				"allowCustomAvatars" => "0",
				"usernameRegex" => '^[a-zA-Z0-9_]{3,16}$',
				"lastSitemapGeneration" => "1000-01-01 00:00:00",
				"lastUpdateCheck" => "",
				"updateCache" => "",
				"header" => $headerJSON,
				"footer" => $footerJSON,
				"customCSS" => '',
				"updatedAt" => time()
			];
			foreach ($settings as $key => $value) {
				$insertSettings = $db->prepare("INSERT INTO Settings (name, value) VALUES (?, ?)");
				$insertSettings->execute(array($key, $value));
			}
			
			/* Payment Methods */
			$paymentGateways = VariablesService::$paymentGateways;
			$insertPaymentGateways = $db->prepare("INSERT INTO PaymentGateways (name, title, slug, feeStatus, transactionFee, fixedFee, config) VALUES (?, ?, ?, ?, ?, ?, ?)");
			foreach ($paymentGateways as $key => $paymentGateway) {
				$insertPaymentGateways->execute(array($paymentGateway["name"], $paymentGateway["title"], $key, '0', $paymentGateway["transactionFee"], $paymentGateway["fixedFee"], json_encode($paymentGateway["config"])));
			}
			
			/* Languages */
			$languages = VariablesService::$languages;
			$insertLanguage = $db->prepare("INSERT INTO Languages (code, name) VALUES (?, ?)");
			foreach ($languages as $key => $value) {
				$insertLanguage->execute(array($key, $value));
			}
			
			/* Currencies */
			$currencies = VariablesService::$currencies;
			$insertCurrency = $db->prepare("INSERT INTO Currencies (code, symbol, label, prefix, suffix, rate) VALUES (?, ?, ?, ?, ?, ?)");
			foreach ($currencies as $key => $value) {
				$insertCurrency->execute(array($key, $value["symbol"], $value["label"], '', $value["suffix"], 1));
			}
			
			/* Social Login Providers */
			$accountLinkingProviders = VariablesService::$accountLinkingProviders;
			$insertAccountLinkingProviders = $db->prepare("INSERT INTO AccountLinkingProviders (name, slug, isEnabled) VALUES (?, ?, ?)");
			foreach ($accountLinkingProviders as $key => $value) {
				$insertAccountLinkingProviders->execute(array($value, $key, 0));
			}
			
			if (input('accountPassword') == null) {
				$password = null;
			} else {
				if (input("sitePasswordType") == 1)
					$password = createSHA256(input("accountPassword"));
				elseif (input("sitePasswordType") == 2)
					$password = md5(input("accountPassword"));
				else
					$password = password_hash(input("accountPassword"), PASSWORD_BCRYPT);
			}
			
			$insertAccounts = $db->prepare("INSERT INTO Accounts (username, realname, email, password, creationIP, creationDate) VALUES (?, ?, ?, ?, ?, ?)");
			$insertAccounts->execute(array(input("accountUsername"), input("accountRealname"), input("accountEmail"), $password, getIP(), date("Y-m-d H:i:s")));
			$accountID = $db->lastInsertId();
			
			// Avatar
			if (input('accountAvatar') != null) {
				// Get the avatar from link
				$avatarData = file_get_contents(input('accountAvatar'));
				
				$upload = new Upload('data:' . $avatarData);
				$imageID = md5(uniqid(mt_rand(), true));
				if ($upload->uploaded) {
					$upload->allowed = ["image/png", "image/gif", "image/jpg", "image/jpeg"];
					$upload->file_new_name_body = $imageID;
					$upload->image_resize = true;
					$upload->image_ratio_crop = true;
					$upload->image_x = 256;
					$upload->image_y = 256;
					$upload->process(__ROOT__ . "/apps/main/public/images/avatars/");
					if ($upload->processed) {
						$imageType = $upload->file_dst_name_ext;
						
						$insertAvatar = $db->prepare("INSERT INTO Avatars (accountID, imageID, imageType) VALUES (?, ?, ?)");
						$insertAvatar->execute(array($accountID, $imageID, $imageType));
					}
				}
			}
			
			/* SEO Pages */
			$seoPages = VariablesService::$seoPages;
			$insertSeoPages = $db->prepare("INSERT INTO SeoPages (page, title, description, image) VALUES (?, ?, ?, ?)");
			foreach ($seoPages as $seoPage) {
				$insertSeoPages->execute(array($seoPage['page'], $seoPage['title'], $seoPage['description'], $seoPage['image']));
			}
			
			/* Modules */
			$modules = VariablesService::getModules();
			$addModule = $db->prepare("INSERT INTO Modules (name, slug, description, isEnabled) VALUES (?, ?, ?, ?)");
			$addModuleSettings = $db->prepare("INSERT INTO ModuleSettings (moduleID, name, value) VALUES (?, ?, ?)");
			foreach ($modules as $module) {
				$addModule->execute([
					$module["name"],
					$module["id"],
					$module["description"],
					$module["isEnabled"]
				]);
        $moduleID = $db->lastInsertId();

        foreach ($module["settings"] as $moduleSettingKey => $moduleSettingValue) {
            $addModuleSettings->execute([
                $moduleID,
                $moduleSettingKey,
                $moduleSettingValue
            ]);
        }
			}
			
			$insertPage = $db->prepare("INSERT INTO Pages (title, slug, content, creationDate) VALUES (?, ?, ?, ?)");
			if (LOCATION === "TR") {
				$insertPage->execute(array("Gizlilik Politikası", "privacy", "Yönetim Paneli > İçerik Yönetimi > Sayfalar kısmından bu yazıyı düzenleyebilirsiniz.", date('Y-m-d H:i:s')));
				$insertPage->execute(array("Hizmet Şartları", "terms", "Yönetim Paneli > İçerik Yönetimi > Sayfalar kısmından bu yazıyı düzenleyebilirsiniz.", date('Y-m-d H:i:s')));
				$insertPage->execute(array("Kurallar", "rules", "Yönetim Paneli > İçerik Yönetimi > Sayfalar kısmından bu yazıyı düzenleyebilirsiniz.", date('Y-m-d H:i:s')));
			} else {
				$insertPage->execute(array("Terms", "terms", "Enter your terms here! Dashboard > Content Management > Pages", date('Y-m-d H:i:s')));
				$insertPage->execute(array("Privacy Policy", "privacy", "Enter your privacy policy here! Dashboard > Content Management > Pages", date('Y-m-d H:i:s')));
				$insertPage->execute(array("Rules", "rules", "Enter your rules here! Dashboard > Content Management > Pages", date('Y-m-d H:i:s')));
			}
			
			/* Changelog Tags */
			$addChangelogTags = $db->prepare("INSERT INTO ChangelogTags (`name`, `badgeCSS`) VALUES (?, ?)");
			if (LOCATION === "TR") {
				$addChangelogTags->execute(['Yeni', "background: #fc0303;\r\ncolor: #fff;"]);
				$addChangelogTags->execute(['İyileştirme', "background: #036ffc;\r\ncolor: #fff;"]);
			} else {
				$addChangelogTags->execute(['New', "background: #fc0303;\r\ncolor: #fff;"]);
				$addChangelogTags->execute(['Improved', "background: #036ffc;\r\ncolor: #fff;"]);
			}
			$addChangelogTags->execute(['Fix', "background: #edf1f5;\r\ncolor: #434a57;"]);
			
			/* Forum Permissions */
			$forumPermissions = VariablesService::$forumPermissions;
			$addForumPermission = $db->prepare("INSERT INTO ForumPermissions (name, description) VALUES (?, ?)");
			foreach ($forumPermissions as $forum_permission_key => $forum_permission_value) {
				$addForumPermission->execute(array($forum_permission_key, $forum_permission_value));
			}
			
			/* Support Category Permissions */
			$supportCategoryPermissions = VariablesService::$supportCategoryPermissions;
			$addSupportCategoryPermission = $db->prepare("INSERT INTO SupportCategoryPermissions (name, description) VALUES (?, ?)");
			foreach ($supportCategoryPermissions as $supportCategory_permission_key => $supportCategory_permission_value) {
				$addSupportCategoryPermission->execute(array($supportCategory_permission_key, $supportCategory_permission_value));
			}
			
			$insertAccountCustomFields = $db->prepare("INSERT INTO AccountCustomFields (name, description, type, isRequired, isPublic) VALUES (?, ?, ?, ?, ?)");
			$insertAccountCustomFields->execute(array('Discord', null, 1, '0', '1'));
			
			/* Permissions */
			$permissions = VariablesService::$permissions;
			$addPermission = $db->prepare("INSERT INTO Permissions (name, description) VALUES (?, ?)");
			foreach ($permissions as $key => $value) {
				$addPermission->execute(array($key, $value));
			}
			$addRole = $db->prepare("INSERT INTO Roles (id, name, slug, priority) VALUES (?, ?, ?, ?)");
			$addRole->execute(array(1, (LOCATION === "TR" ? "Oyuncu" : "User"), "default", 0));
			$addRole->execute(array(2, (LOCATION === "TR" ? "Yönetici" : "Admin"), "admin", 99));
			
			$addPermissionToRole = $db->prepare("INSERT INTO RolePermissions (roleID, permissionID) VALUES (?, ?)");
			$addPermissionToRole->execute(array(2, 1));
			
			$addRoleToAccount = $db->prepare("INSERT INTO AccountRoles (accountID, roleID) VALUES (?, ?)");
			$addRoleToAccount->execute(array($accountID, 2));
			
			$themeJsonFile = __ROOT__.'/apps/main/app/views/themes/'.$themeName.'/theme.json';
			if (file_exists($themeJsonFile)) {
				$themeJson = json_decode(file_get_contents($themeJsonFile), true);
				$addThemeSettings = $db->prepare("INSERT INTO Settings (name, value) VALUES (?, ?)");
				foreach ($themeJson["settingsCategories"] as $themeSettingsCategory) {
					foreach ($themeSettingsCategory["settings"] as $key => $themeSettingsData) {
						$addThemeSettings->execute(array("theme:$themeName:".$key, $themeSettingsData["value"]));
					}
				}
			}
			
			if (isset($_COOKIE["rememberMe"])) {
				setcookie("rememberMe", "", time()-86400*365, '/');
			}

			response()->json([
				'success' => true,
			]);
		}
	}