<?php
	namespace Install\Services;
	
	class VariablesService
	{
		/* Languages */
		public static array $languages = [
			"en" => "English",
			"es" => "Español",
			"de" => "Deutsch",
			"tr" => "Türkçe",
			"fr" => "Français",
			"ru" => "Русский",
			"vi" => "Tiếng Việt",
			"cs" => "Čeština",
			"pl" => "Polski",
			"pt_BR" => "Português (Brasil)",
			"hu" => "Magyar",
			"it" => "Italiano",
			"ro" => "Română",
			"nl" => "Nederlands",
			"ja" => "日本語",
			"sv" => "Svenska",
			"no" => "Norsk",
			"zh_CN" => "中文",
			"hi" => "हिन्दी",
		];
		
		/* Currencies */
		public static array $currencies = [
			"USD" => [
				'symbol' => '$',
				'label' => 'USD',
				'suffix' => ' USD'
			],
			"EUR" => [
				'symbol' => '€',
				'label' => 'EUR',
				'suffix' => ' EUR'
			],
			"GBP" => [
				'symbol' => '£',
				'label' => 'GBP',
				'suffix' => ' GBP'
			],
			"TRY" => [
				'symbol' => '₺',
				'label' => 'TL',
				'suffix' => ' ₺'
			],
			"AUD" => [
				'symbol' => 'A$',
				'label' => 'AUD',
				'suffix' => ' AUD'
			],
			"BRL" => [
				'symbol' => 'R$',
				'label' => 'BRL',
				'suffix' => ' BRL'
			],
			"CAD" => [
				'symbol' => 'C$',
				'label' => 'CAD',
				'suffix' => ' CAD'
			],
			"DKK" => [
				'symbol' => 'kr',
				'label' => 'DKK',
				'suffix' => ' DKK'
			
			],
			"NOK" => [
				'symbol' => 'kr',
				'label' => 'NOK',
				'suffix' => ' NOK'
			],
			"NZD" => [
				'symbol' => 'NZ$',
				'label' => 'NZD',
				'suffix' => ' NZD'
			],
			"PLN" => [
				'symbol' => 'zł',
				'label' => 'PLN',
				'suffix' => ' PLN'
			],
			"SEK" => [
				'symbol' => 'kr',
				'label' => 'SEK',
				'suffix' => ' SEK'
			],
			"RUB" => [
				'symbol' => '₽',
				'label' => 'RUB',
				'suffix' => ' RUB'
			],
			"JPY" => [
				'symbol' => '¥',
				'label' => 'JPY',
				'suffix' => ' JPY'
			],
			"VND" => [
				'symbol' => '₫',
				'label' => 'VND',
				'suffix' => ' VND'
			],
			"CNY" => [
				'symbol' => '¥',
				'label' => 'CNY',
				'suffix' => ' CNY'
			],
			"CZK" => [
				'symbol' => 'Kč',
				'label' => 'CZK',
				'suffix' => ' CZK'
			],
			"INR" => [
				'symbol' => '₹',
				'label' => 'INR',
				'suffix' => ' INR'
			],
			"PHP" => [
				'symbol' => '₱',
				'label' => 'PHP',
				'suffix' => ' PHP'
			],
			"HUF" => [
				'symbol' => 'Ft',
				'label' => 'HUF',
				'suffix' => ' HUF'
			],
		];
		
		/* SEO Pages */
		public static array $seoPages = [
			[
				'page' => 'home',
				'title' => '%site_title% - %tagline%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'auth.login',
				'title' => '%translate:"Login"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'auth.register',
				'title' => '%translate:"Register"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'auth.forgot-password',
				'title' => '%translate:"Forgot Password"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'auth.reset-password',
				'title' => '%translate:"Reset Password"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'tfa.index',
				'title' => '%translate:"Two Factor Authentication"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'tfa.recover.index',
				'title' => '%translate:"Recover Account"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'email.verification.index',
				'title' => '%translate:"Verify Email"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'account.profile.index',
				'title' => '%translate:"Profile"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'account.orders',
				'title' => '%translate:"Orders"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'account.subscriptions',
				'title' => '%translate:"Subscriptions"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'account.credit-history',
				'title' => '%translate:"Credit History"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'account.applications',
				'title' => '%translate:"Applications"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'account.settings.profile',
				'title' => '%translate:"Edit Profile"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'account.settings.security',
				'title' => '%translate:"Security"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'account.settings.linked-accounts',
				'title' => '%translate:"Linked Accounts"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'account.contact.edit',
				'title' => '%translate:"Edit Contact Details"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'members.index',
				'title' => '%translate:"Members"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'members.show',
				'title' => '%username% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'blog.index',
				'title' => '%translate:"Blog"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'blog.posts.show',
				'title' => '%post_title% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'blog.categories.show',
				'title' => '%category_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'blog.tags.show',
				'title' => '%tag% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'store.index',
				'title' => '%translate:"Store"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'store.categories.show',
				'title' => '%category_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'store.products.show',
				'title' => '%product_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'store.cart',
				'title' => '%translate:"Cart"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'credits.charge.index',
				'title' => '%translate:"Buy Credits"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'credits.send.index',
				'title' => '%translate:"Send Credits"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'credits.send.to',
				'title' => '%translate:"Send Credits to %username%"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'credits.packages.index',
				'title' => '%translate:"Credit Packages"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'credits.packages.show',
				'title' => '%package_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'payment.pay',
				'title' => '%payment_gateway% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'payment.success',
				'title' => '%translate:"Payment Successful"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'payment.error',
				'title' => '%translate:"Payment Failed"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'leaderboards.index',
				'title' => '%translate:"Leaderboards"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'leaderboards.show',
				'title' => '%leaderboard_title% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'leaderboards.search',
				'title' => '%translate:"Search results for: %search_query%"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'games.index',
				'title' => '%translate:"Games"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'games.show',
				'title' => '%game_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'help.index',
				'title' => '%translate:"Help Center"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'help.articles.show',
				'title' => '%article_title% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'help.topics.show',
				'title' => '%topic_title% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'help.search',
				'title' => '%translate:"Search results for: %search_query%"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'gaming-night.index',
				'title' => '%translate:"Gaming Night"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'gaming-night.products.show',
				'title' => '%product_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'forum.index',
				'title' => '%translate:"Forum"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'forum.categories.show',
				'title' => '%category_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'forum.threads.show',
				'title' => '%thread_title% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'forum.threads.create',
				'title' => '%translate:"Post Thread"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'forum.threads.edit',
				'title' => '%translate:"Editing %thread_title%"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'forum.replies.edit',
				'title' => '%translate:"Editing Reply"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'punishments.index',
				'title' => '%translate:"Punishments"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'punishments.bans',
				'title' => '%translate:"Bans"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'punishments.kicks',
				'title' => '%translate:"Kicks"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'punishments.mutes',
				'title' => '%translate:"Mutes"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'punishments.warnings',
				'title' => '%translate:"Warnings"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'suggestions.index',
				'title' => '%translate:"Suggestions"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'suggestions.categories.show',
				'title' => '%category_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'suggestions.show',
				'title' => '%suggestion_title% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'suggestions.create',
				'title' => '%translate:"Post Suggestion"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'suggestions.edit',
				'title' => '%translate:"Editing %suggestion_title%"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'suggestions.replies.edit',
				'title' => '%translate:"Editing Reply"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'download.index',
				'title' => '%translate:"Download"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'download.show',
				'title' => '%file_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'play',
				'title' => '%translate:"Play"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'changelog',
				'title' => '%translate:"Changelog"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'staff',
				'title' => '%translate:"Staff"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'vote',
				'title' => '%translate:"Vote"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'applications.show',
				'title' => '%form_title% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'forms.show',
				'title' => '%form_title% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'bazaar.index',
				'title' => '%translate:"Bazaar"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'bazaar.help',
				'title' => '%translate:"Bazaar Help"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'bazaar.logs',
				'title' => '%translate:"Bazaar History"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'bazaar.servers.show',
				'title' => '%server_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'bazaar.products.show',
				'title' => '%product_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'bazaar.manage.index',
				'title' => '%translate:"Manage Bazaar"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'bazaar.manage.edit',
				'title' => '%translate:"Editing %product_name%"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'fortune-wheel.index',
				'title' => '%translate:"Wheel of Fortune"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'fortune-wheel.show',
				'title' => '%fortune_wheel_name% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'fortune-wheel.logs',
				'title' => '%translate:"Wheel of Fortune History"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'support.tickets.index',
				'title' => '%translate:"Tickets"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'support.tickets.create',
				'title' => '%translate:"Open Ticket"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'support.tickets.show',
				'title' => '%ticket_title% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'orders.show',
				'title' => '%translate:"Orders"% #%order_id% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'chest.index',
				'title' => '%translate:"Chest"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'chest.gift.index',
				'title' => '%translate:"Send Gift"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'chest.logs',
				'title' => '%translate:"Chest History"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'gifts.index',
				'title' => '%translate:"Gift"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'gifts.logs',
				'title' => '%translate:"Gift History"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'maintenance',
				'title' => '%translate:"Maintenance"% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => 'page',
				'title' => '%page_title% - %site_title%',
				'description' => null,
				'image' => null,
			],
			[
				'page' => '404',
				'title' => '%translate:"Page not found!"% - %site_title%',
				'description' => null,
				'image' => null,
			],
		];
		
		/* Modules */
		public static function getModules() {
            $recaptchaPagesStatusArray = json_encode([
                "login" => 0,
                "register" => 0,
                "forgot_password" => 0,
                "reply_blog_post" => 0,
                "open_ticket" => 0,
                "reply_ticket" => 0,
                "tfa" => 0,
                "post_thread" => 0,
                "reply_thread" => 0,
                "post_suggestion" => 0,
                "reply_suggestion" => 0,
            ]);

            if (LOCATION === "TR") {
                $supportMessageTemplate = '
        <p>Dear <strong><span class="text-primary">%username%</span></strong>,</p>
        <p>%message%</p><p class="mb-1"><strong>%servername% Support Team</strong></p>
        <p class="mb-1"><strong><span class="text-primary">Server IP:</span></strong> %serverip%</p>
        ';
            } else {
                $supportMessageTemplate = '
        <p>Değerli <strong><span class="text-primary">%username%</span></strong>,</p>
        <p>%message%</p><p class="mb-1"><strong>%servername% Destek Ekibi</strong></p>
        <p class="mb-1"><strong><span class="text-primary">Sunucu IP:</span></strong> %serverip%</p>
        ';
            }

            if (LOCATION === "TR") {
	              $smtpTFATitle = "İki adımlı doğrulama sıfırlaması";
                $smtpTFATemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>TFA Reset</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }

</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
İki adımlı doğrulamayı sıfırlama talebinizi aldık, aşağıdaki bağlantıyı kullanarak iki adımlı doğrulamayı sıfırlayabilirsiniz.
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Merhaba <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">İki adımlı doğrulamayı sıfırlama talebinizi aldık, aşağıdaki bağlantıyı kullanarak iki adımlı doğrulamayı sıfırlayabilirsiniz.</p>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">Sıfırla</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Çalışmadı mı? Aşağıdaki bağlantıyı kullanabilirsiniz.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. Tüm hakları saklıdır.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
	              $smtpVerifyEmailTitle = "Email adresinizi doğrulayın!";
								$smtpVerifyEmailTemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>User Verification</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }

</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
Lütfen aşağıdaki bağlantıyı kullanarak e-posta adresinizi doğrulayın.
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Merhaba <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Lütfen aşağıdaki bağlantıyı kullanarak e-posta adresinizi doğrulayın.</p>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">Email Doğrula</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Çalışmadı mı? Aşağıdaki bağlantıyı kullanabilirsiniz.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. Tüm hakları saklıdır.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
	            
	              $purchaseEmailTitle = "Satın aldığınız için teşekkürler!";
                $purchaseEmailTemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>Purchase</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }
</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
Satın alma işleminiz için teşekkürler!
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Merhaba <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Satın alma işleminiz için teşekkürler!</p>
                  <div style="margin-bottom: 10px;">
                    <table class="table-list" style="border-collapse: collapse;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;border-spacing: 0;margin-bottom: 20px;background-color: #f1f5f8;border-radius: 6px;">
                      <thead>
                      <tr>
                        <th style="color: #576478;text-align: left;padding: 6px 12px;font-size: 0.825rem;font-weight: 600;border-bottom: 1px solid #e3e6f0;">Ürün</th>
                        <th style="color: #576478;text-align: left;padding: 6px 12px;font-size: 0.825rem;font-weight: 600;border-bottom: 1px solid #e3e6f0;">Adet</th>
                        <th style="color: #576478;text-align: left;padding: 6px 12px;font-size: 0.825rem;font-weight: 600;border-bottom: 1px solid #e3e6f0;">Toplam</th>
                      </tr>
                      </thead>
                      <tbody data-loop="products">
                      <tr>
                      <td style="color: #576478; text-align: left; padding: 6px 12px; font-size: 0.825rem;">%product.name%</td>
                      <td style="color: #576478; text-align: left; padding: 6px 12px; font-size: 0.825rem;">%product.quantity%</td>
                      <td style="color: #576478; text-align: left; padding: 6px 12px; font-size: 0.825rem;">%product.total%</td>
                      </tr>
                      </tbody>
                    </table>
                    <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">
                      <strong>Toplam:</strong> %total%<br>
                      <strong>İndirim:</strong> %discount%
                    </p>
                  </div>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">Siparişi Görüntüle</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Çalışmadı mı? Aşağıdaki bağlantıyı kullanabilirsiniz.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. Tüm hakları saklıdır.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
	            
	              $supportAnsweredEmailTitle = "Destek talebiniz yanıtlandı!";
								$supportAnsweredEmailTemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>Ticket Reply</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }

</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
Destek biletiniz yetkilimiz tarafından yanıtlandı.
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Merhaba <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Destek biletiniz yetkilimiz tarafından yanıtlandı.</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">
                    <strong>Başlık:</strong> %subject%<br>
                    <strong>Kategori:</strong> %category%
                  </p>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">Görüntüle</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Çalışmadı mı? Aşağıdaki bağlantıyı kullanabilirsiniz.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. Tüm hakları saklıdır.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
            } else {
	              $smtpTFATitle = "Recover TFA";
                $smtpTFATemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>TFA Reset</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }

</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
We received your request to reset two-step verification, you can reset two-step verification using the link below.
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Dear <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">We received your request to reset two-step verification, you can reset two-step verification using the link below.</p>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">Reset</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Didn\'t it work? You can use the link below.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. All rights reserved.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
	              $smtpVerifyEmailTitle = "Verify your email address";
                $smtpVerifyEmailTemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>User Verification</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }

</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
Please verify your email address using the link below.
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Dear <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Please verify your email address using the link below.</p>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">Verify Email</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Didn\'t it work? You can use the link below.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. All rights reserved.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
	            
	              $purchaseEmailTitle = "Thanks for your purchasing!";
                $purchaseEmailTemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>Purchase</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }
</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
Thanks for your purchasing!
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Dear <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Thanks for your purchasing!</p>
                  <div style="margin-bottom: 10px;">
                    <table class="table-list" style="border-collapse: collapse;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;border-spacing: 0;margin-bottom: 20px;background-color: #f1f5f8;border-radius: 6px;">
                      <thead>
                      <tr>
                        <th style="color: #576478;text-align: left;padding: 6px 12px;font-size: 0.825rem;font-weight: 600;border-bottom: 1px solid #e3e6f0;">Product</th>
                        <th style="color: #576478;text-align: left;padding: 6px 12px;font-size: 0.825rem;font-weight: 600;border-bottom: 1px solid #e3e6f0;">Qty</th>
                        <th style="color: #576478;text-align: left;padding: 6px 12px;font-size: 0.825rem;font-weight: 600;border-bottom: 1px solid #e3e6f0;">Total</th>
                      </tr>
                      </thead>
                      <tbody data-loop="products">
                      <tr>
                      <td style="color: #576478; text-align: left; padding: 6px 12px; font-size: 0.825rem;">%product.name%</td>
                      <td style="color: #576478; text-align: left; padding: 6px 12px; font-size: 0.825rem;">%product.quantity%</td>
                      <td style="color: #576478; text-align: left; padding: 6px 12px; font-size: 0.825rem;">%product.total%</td>
                      </tr>
                      </tbody>
                    </table>
                    <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">
                      <strong>Total:</strong> %total%<br>
                      <strong>Discount:</strong> %discount%
                    </p>
                  </div>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">View Order</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Didn\'t it work? You can use the link below.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. All rights reserved.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
	            
	              $supportAnsweredEmailTitle = "Your support ticket has been answered!";
                $supportAnsweredEmailTemplate = '
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>Ticket Reply</title>
<style>
  /* -------------------------------------
      RESPONSIVE AND MOBILE FRIENDLY STYLES
  ------------------------------------- */
  @media only screen and (max-width: 620px) {
    table.email-body h1 {
      font-size: 28px !important;
      margin-bottom: 10px !important;
    }
    table.email-body p,
    table.email-body ul,
    table.email-body ol,
    table.email-body td,
    table.email-body span,
    table.email-body a {
      font-size: 16px !important;
    }
    table.email-body .email-wrapper,
    table.email-body .email-article {
      padding: 10px !important;
    }
    table.email-body .email-content {
      padding: 0 !important;
    }
    table.email-body .email-container {
      padding: 0 !important;
      width: 100% !important;
    }
    table.email-body .email-main {
      border-left-width: 0 !important;
      border-radius: 0 !important;
      border-right-width: 0 !important;
    }
    table.email-body .email-btn table {
      width: 100% !important;
    }
    table.email-body .email-btn a {
      width: 100% !important;
    }
    table.email-body .email-img-responsive {
      height: auto !important;
      max-width: 100% !important;
      width: auto !important;
    }
  }

  /* -------------------------------------
      PRESERVE THESE STYLES IN THE HEAD
  ------------------------------------- */
  @media all {
    .email-btn-primary table td:hover {
      background-color: #2463EB !important;
    }
    .email-btn-primary a:hover {
      background-color: #2463EB !important;
      border-color: #2463EB !important;
    }
  }

</style>
</head>
<body style="color: #576478;background-color: #f1f5f8;font-family: sans-serif;-webkit-font-smoothing: antialiased;font-size: 14px;line-height: 1.4;margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;">
<span style="color: transparent;display: none;height: 0;max-height: 0;max-width: 0;opacity: 0;overflow: hidden;mso-hide: all;visibility: hidden;width: 0;">
Your support ticket has been answered by our staff.
</span>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-body" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
<tr>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
  <td class="email-container" style="font-family: sans-serif;font-size: 14px;vertical-align: top;display: block;max-width: 580px;padding: 24px;width: 580px;margin: 0 auto !important;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
      <tr>
        <td align="center" style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
          <div style="padding-bottom: 10px;padding-top: 10px;">
            <a href="https://www.leaderos.net" style="color: #3B81F6;text-decoration: underline;">
              <img style="width: 150px;border: none;-ms-interpolation-mode: bicubic;max-width: 100%;" src="https://i.imghippo.com/files/zQXA7953EVY.png">
            </a>
          </div>
        </td>
      </tr>
    </table>

    <div class="email-content" style="box-sizing: border-box;display: block;margin: 0 auto;max-width: 580px;padding: 10px;">
      <!-- START CENTERED WHITE CONTAINER -->
      <table role="presentation" class="email-main" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;background: #ffffff;border-radius: 3px;">

        <!-- START MAIN CONTENT AREA -->
        <tr>
          <td class="email-wrapper" style="font-family: sans-serif;font-size: 14px;vertical-align: top;box-sizing: border-box;padding: 20px;">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
              <tr>
                <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Dear <strong>%username%</strong>,</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">Your support ticket has been answered by our staff.</p>
                  <p style="color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;margin-bottom: 15px;">
                    <strong>Subject:</strong> %subject%<br>
                    <strong>Category:</strong> %category%
                  </p>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="email-btn email-btn-primary" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;box-sizing: border-box;">
                    <tbody>
                    <tr>
                      <td align="left" style="font-family: sans-serif;font-size: 14px;vertical-align: top;padding-bottom: 15px;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: auto;">
                          <tbody>
                          <tr>
                            <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;background-color: #3B81F6;border-radius: 5px;text-align: center;">
                              <a href="%url%" target="_blank" style="color: #ffffff;text-decoration: none;background-color: #3B81F6;border: solid 1px #3B81F6;border-radius: 6px;box-sizing: border-box;cursor: pointer;display: inline-block;font-size: 14px;font-weight: bold;margin: 0;padding: 8px 16px;text-transform: capitalize;border-color: #3B81F6;">View Ticket</a>
                            </td>
                          </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    </tbody>
                  </table>
                  <p style="margin-bottom: 0 !important;color: #576478;font-family: sans-serif;font-size: 14px;font-weight: normal;margin: 0;">Didn\'t it work? You can use the link below.</p>
                  <div style="color: #3B81F6;">%url%</div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- END MAIN CONTENT AREA -->
      </table>
      <!-- END CENTERED WHITE CONTAINER -->

      <!-- START FOOTER -->
      <div style="clear: both;margin-top: 10px;text-align: center;width: 100%;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate;mso-table-lspace: 0pt;mso-table-rspace: 0pt;width: 100%;">
          <tr>
            <td style="font-family: sans-serif;font-size: 12px;vertical-align: top;padding-bottom: 10px;padding-top: 10px;color: #999999;text-align: center;">
              <span style="color: #999999;font-size: 12px;text-align: center;">
                &copy; 2025 LeaderOS. All rights reserved.
              </span>
            </td>
          </tr>
        </table>
      </div>
      <!-- END FOOTER -->

    </div>
  </td>
  <td style="font-family: sans-serif;font-size: 14px;vertical-align: top;">&nbsp;</td>
</tr>
</table>
</body>
</html>
';
            }

            return [
                [
                    "id" => "forum",
                    "name" => "Forum",
                    "description" => "Your players can chat and discuss topics within the different categories you create. Also, don't forget to decorate your user flags with the custom roles!",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "bazaar",
                    "name" => "Bazaar",
                    "description" => "Create a marketplace for your players. They can sell their items and buy items from other players.",
                    "isEnabled" => 0,
                    "settings" => [
                        'commission' => '0',
                    ]
                ],
                [
                    "id" => "store",
                    "name" => "Store",
                    "description" => "Start monetizing your server by adding your products to the store. You can increase your sales with systems such as discounts, coupons, gifts and stock.",
                    "isEnabled" => 1,
                    "settings" => [
                        'discount' => '0',
                        'discountExpiryDate' => '1000-01-01 00:00:00',
                        'discountProducts' => '0',
                        'minPay' => '1',
                        'maxPay' => '9999',
                        'topSalesStatus' => '1',
                        'featuredProducts' => '0',
                        'cashback' => '0',
                        "isCreditRequiredOnPurchase" => "0",
                        'redirect' => '',
                        "communityGoalStatus" => "0",
                        "communityGoalTitle" => LOCATION === "TR" ? "Topluluk Hedefi" : "Community Goal",
                        "communityGoalDescription" => LOCATION === "TR" ? "Hedefimize ulaşmamızda bize yardımcı ol!" : "Help us to reach our goal!",
                        "communityGoalCurrent" => "0",
                        "communityGoalTarget" => "100",
                        "communityGoalRepeat" => "0",
                        "showTermsCheckbox" => "0",
                        'tax' => '0',
                        "removeMoneyZeroDecimal" => "0",
                        "sendEmailOnPurchase" => "0",
                        "purchaseEmailTitle" => $purchaseEmailTitle,
                        "purchaseEmailTemplate" => $purchaseEmailTemplate,
                    ]
                ],
                [
                    "id" => "blog",
                    "name" => "Blog",
                    "description" => "Share server updates, news, and cool stuff with ease. Stay connected with your players and come together in the comments!",
                    "isEnabled" => 1,
                    "settings" => [
                        'commentsStatus' => '1',
                    ]
                ],
                [
                    "id" => "support",
                    "name" => "Support",
                    "description" => "Manage your support tickets with your team. You can also create custom fields for your support tickets.",
                    "isEnabled" => 1,
                    "settings" => [
                        'messageTemplate' => $supportMessageTemplate,
                        "ticketsLimit" => "-1",
                        "sendEmailOnAnswered" => "0",
                        "answeredEmailTitle" => $supportAnsweredEmailTitle,
                        "answeredEmailTemplate" => $supportAnsweredEmailTemplate,
                    ]
                ],
                [
                    "id" => "help",
                    "name" => "Help Center",
                    "description" => "Write articles and create a knowledge base to help your players.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "leaderboards",
                    "name" => "Leaderboards",
                    "description" => "Create leaderboards and fetch data from your MySQL database.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "chest",
                    "name" => "Chest",
                    "description" => "Save bought items in store chest to redeem them later or gift it to other players.",
                    "isEnabled" => 0,
                    "settings" => [
                        'canSendGift' => '1',
                    ]
                ],
                [
                    "id" => "credit",
                    "name" => "Credits",
                    "description" => "Enable using credits on your website. Your players can buy credits and use them on your website.",
                    "isEnabled" => 1,
                    "settings" => [
                        'minPay' => '1',
                        'maxPay' => '9999',
                        'bonusCredit' => '0',
                        'bonusCreditMinAmount' => '0',
                        'bonusCreditExpiryDate' => '1000-01-01 00:00:00',
                        'multiplier' => '1',
                        "showTermsCheckbox" => "0",
                        'creditPackageStatus' => '0',
                        "creditText" => "",
                        'canSendCredits' => '1', // send credits to other players
                    ]
                ],
                [
                    "id" => "download",
                    "name" => "Download Center",
                    "description" => "Upload your files to the download center and share them with your players.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "form",
                    "name" => "Custom Forms",
                    "description" => "Create custom forms like contact form, report form, etc.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "games",
                    "name" => "Gamemodes",
                    "description" => "Introduce your gamemodes to your players.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "gaming_night",
                    "name" => "Gaming Night",
                    "description" => "Make special discounts with limited stocks on selected products on a certain day and time of the week.",
                    "isEnabled" => 0,
                    "settings" => [
                        'day' => 'Friday',
                        'start' => '2000',
                        'end' => '2359',
                    ]
                ],
                [
                    "id" => "gift",
                    "name" => "Gifts",
                    "description" => "Create gift codes and share them with your players.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "lottery",
                    "name" => "Wheel of Fortune",
                    "description" => "Create a Wheel of Fortune game and share it with your players. You can also add a link to the game.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "page",
                    "name" => "Custom Pages",
                    "description" => "Create custom pages with using HTML editor.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "player",
                    "name" => "Player Profiles",
                    "description" => "Create player profiles and share them with your players. You can also add a link to the player profile.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "application",
                    "name" => "Applications",
                    "description" => "Create application forms and manage them with your team.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "tfa",
                    "name" => "Two Factor Authentication",
                    "description" => "With two-factor authentication, users can increase the security of their accounts.",
                    "isEnabled" => 0,
                    "settings" => [
                        'tfaEmailTitle' => $smtpTFATitle,
                        'tfaEmailTemplate' => $smtpTFATemplate,
                    ]
                ],
                [
                    "id" => "staff",
                    "name" => "Staff",
                    "description" => "Create a staff page and share it with your players. You can also add a link to the staff page.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "vote",
                    "name" => "Vote",
                    "description" => "Share Vote Links with your players and reward them with in-game items.",
                    "isEnabled" => 1,
                    "settings" => [
                        'description' => '',
                    ]
                ],
                [
                    "id" => "punishments",
                    "name" => "Punishments",
                    "description" => "Create a Punishments page using LiteBans/AdvancedBan plugin data and share them with your players.",
                    "isEnabled" => 0,
                    "settings" => [
                        "plugin" => "litebans",
                        "mysqlHost" => "",
                        "mysqlPort" => "3306",
                        "mysqlUsername" => "",
                        "mysqlPassword" => "",
                        "mysqlDatabase" => "",
                    ]
                ],
                [
                    "id" => "announcements",
                    "name" => "Announcements",
                    "description" => "Create announcements and share them with your players.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "slider",
                    "name" => "Slider",
                    "description" => "Create a slider and share it with your players. You can also add a link to the slider.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "suggestions",
                    "name" => "Suggestions",
                    "description" => "Get suggestions from your players and manage them with your team. You can also create custom fields for your suggestions.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "discord",
                    "name" => "Discord Bot (Legacy)",
                    "description" => "This module is deprecated. Please use the new Discord Bot module.",
                    "isEnabled" => 0,
                    "settings" => [
                        "clientID" => "",
                        "clientSecret" => "",
                        "botToken" => "",
                        "guildID" => "",
                        "joinServerStatus" => "1",
                        "everyoneRoleID" => "",
                        "syncedRoleID" => "",
                        "roleSyncingStatus" => "1",
                        "setNicknameStatus" => "1",
                        "ticketStatus" => "0",
                        "ticketCategoryID" => "",
                        "ticketStaffRoleID" => "",
                        "ticketEmbedDetailsTemplate" => LOCATION === "TR" ? "**Kategori:** {category}\r\n{newline}\r\n**Kullanıcı Adı:** {username}\r\n{newline}\r\n%fields%\r\n**{field}:** {fieldValue}{newline}\r\n%endfields%\r\n**Mesaj:** {message}" : "**Category:** {category}\r\n{newline}\r\n**Username:** {username}\r\n{newline}\r\n%fields%\r\n**{field}:** {fieldValue}{newline}\r\n%endfields%\r\n**Message:** {message}",
                    ]
                ],
                [
                    "id" => "discord_bot",
                    "name" => "Discord Bot",
                    "description" => "Integrate your website with your discord server.",
                    "isEnabled" => 0,
                    "settings" => [
                        "botLinkToken" => "",
                        "guildID" => "",
                        "syncNames" => "0",
                    ]
                ],
                [
                    "id" => "parasut",
                    "name" => "Paraşüt",
                    "description" => "You can create and send invoices to your customers with Paraşüt integration.",
                    "isEnabled" => 0,
                    "settings" => [
                        "isDevelopment" => "0",
                        "clientID" => "",
                        "clientSecret" => "",
                        "authType" => "1",
                        "username" => "",
                        "password" => "",
                        "companyID" => "",
                        "accessToken" => "",
                        "refreshToken" => "",
                        "tokenExpiryDate" => "",
                        "accountID" => "0",
                        "productID" => "0",
                    ]
                ],
                [
                    "id" => "birfatura",
                    "name" => "BirFatura",
                    "description" => "You can create and send invoices to your customers with BirFatura integration.",
                    "isEnabled" => 0,
                    "settings" => [
                        "token" => "",
                        "lastCheck" => "1000-01-01 00:00:00",
                    ]
                ],
                [
                    "id" => "tebex_store",
                    "name" => "Tebex Store",
                    "description" => "Manage your store with Tebex! Allow your players to choose from over 120+ payments methods, fast and easy. All LeaderOS customer receive free Plus Plan via Tebex!",
                    "isEnabled" => 0,
                    "settings" => [
                        "publicKey" => "",
                        "secretKey" => "",
                        "storeName" => "",
                        "storeDescription" => "",
                    ]
                ],
                [
                    "id" => "tawkto",
                    "name" => "Tawk.to",
                    "description" => "Tawk.to is a free live chat widget that lets you monitor and chat with visitors on your website.",
                    "isEnabled" => 0,
                    "settings" => [
                        'id' => '',
                        'widgetID' => '',
                    ]
                ],
                [
                    "id" => "google_analytics",
                    "name" => "Google Analytics",
                    "description" => "Analyze in-depth detail about the visitors on your website with Google Analytics.",
                    "isEnabled" => 0,
                    "settings" => [
                        'ua' => '',
                    ]
                ],
                [
                    "id" => "recaptcha",
                    "name" => "Cloudflare Turnstile",
                    "description" => "Protect your website from spam and abuse while letting real people pass through with ease. It is an alternative to Google reCAPTCHA.",
                    "isEnabled" => 0,
                    "settings" => [
                        'pagesStatus' => $recaptchaPagesStatusArray,
                        'publicKey' => '',
                        'privateKey' => '',
                    ]
                ],
                [
                    "id" => "cookie_consent",
                    "name" => "Cookie Consent",
                    "description" => "Cookie Consent is a free solution to the EU cookie law. It is highly customizable and supports multiple languages.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "email_verification",
                    "name" => "Email Verification",
                    "description" => "Verify your user's email addresses and increase the security of your website.",
                    "isEnabled" => 0,
                    "settings" => [
                        'verifyEmailTitle' => $smtpVerifyEmailTitle,
                        'verifyEmailTemplate' => $smtpVerifyEmailTemplate,
                    ]
                ],
                [
                    "id" => "popup",
                    "name" => "Popup",
                    "description" => "Shows a popup screen to visitors when they visit the website.",
                    "isEnabled" => 0,
                    "settings" => [
                        "image" => "popup.png",
                        "link" => "#",
                    ]
                ],
                [
                    "id" => "changelog",
                    "name" => "Changelog",
                    "description" => "Share changelog with your players and keep them informed about the updates.",
                    "isEnabled" => 1,
                    "settings" => []
                ],
                [
                    "id" => "account_linking",
                    "name" => "Account Linking",
                    "description" => "Enable users to link third-party accounts such as Discord, Steam, and more.",
                    "isEnabled" => 0,
                    "settings" => []
                ],
		            [
			            "id" => "ai",
			            "name" => "AI",
			            "description" => "Integrate AI features into your website, such as ticket auto-replies, content generation, and more.",
			            "isEnabled" => 1,
			            "settings" => [
										'name' => 'AI',
				            'autoReply' => '0'
			            ]
		            ],
            ];
        }
		
		/* Forum Permissions */
		public static array $forumPermissions = [
			'VIEW_FORUM' => "Can view forum?",
			'CREATE_TOPICS' => "Can create threads?",
			'CREATE_REPLIES' => "Can create replies?",
			'MODERATE_FORUM' => "Can moderate forum?",
		];
		
		/* Support Category Permissions */
		public static array $supportCategoryPermissions = [
			'VIEW_CATEGORY' => "Can view category?",
			'REPLY_TICKETS' => "Can reply tickets?",
			'CLOSE_TICKETS' => "Can close tickets?",
			'DELETE_TICKETS' => "Can delete tickets?",
			'DELETE_MESSAGES' => "Can delete messages?",
		];
		
		/* Permissions */
		public static array $permissions = [
			'SUPER_ADMIN' => "Super Admin",
			'VIEW_DASHBOARD' => "View Dashboard",
			'VIEW_STATS' => "View Stats",
			'MANAGE_ACCOUNTS' => "Manage Accounts",
			'MANAGE_APPLICATIONS' => "Manage Applications",
			'MANAGE_BANS' => "Manage Bans",
			'MANAGE_BAZAAR' => "Manage Bazaar",
			'MANAGE_ANNOUNCEMENTS' => "Manage Announcements",
			'MANAGE_DOWNLOADS' => "Manage Downloads",
			'MANAGE_GAMES' => "Manage Games",
			'MANAGE_GIFTS' => "Manage Gifts",
			'MANAGE_HELP_CENTER' => "Manage Help Center",
			'MANAGE_LEADERBOARDS' => "Manage Leaderboards",
			'MANAGE_LOTTERY' => "Manage Wheel Of Fortune",
			'MANAGE_BLOG' => "Manage Blog",
			'MANAGE_NOTIFICATIONS' => "View Notifications",
			'MANAGE_PAGES' => "Manage Pages",
			'MANAGE_PAYMENT' => "Manage Payments",
			'MANAGE_ROLES' => "Manage Roles",
			'MANAGE_SERVERS' => "Manage Servers",
			'MANAGE_SETTINGS' => "Manage Settings",
			'MANAGE_SLIDER' => "Manage Slider",
			'MANAGE_STORE' => "Manage Store",
			'MANAGE_SUPPORT' => "Manage Support",
			'MANAGE_SUPPORT_TICKETS' => "Manage Support Tickets",
			'MANAGE_THEME' => "Manage Themes",
			'MANAGE_UPDATES' => "Manage Updates",
			'MANAGE_LOGS' => "Manage Logs",
			'MANAGE_GAMING_NIGHT' => "Manage Gaming Night",
			'MANAGE_FORUM' => "Manage Forum",
			'MANAGE_CUSTOM_FORMS' => "Manage Custom Forms",
			'MANAGE_MODULES' => "Manage Modules",
			'MANAGE_VOTES' => "Manage Votes",
			'MANAGE_SUGGESTIONS' => "Manage Suggestions",
			'MANAGE_COMMUNITY_GOALS' => "Manage Community Goals",
			'MANAGE_CHANGELOG' => "Manage Changelog",
			'MANAGE_AI' => "Manage AI",
		];
		
		/* Payment Methods */
		public static array $paymentGateways = [
			"paywant" => [
				'name' => 'Paywant',
				'title' => 'Paywant',
				'transactionFee' => '5.00',
				'fixedFee' => '0.00',
				'config' => [
					[
						'key' => 'api_key',
						'value' => null,
						'settings' => [
							'title' => 'API Key',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'secret_key',
						'value' => null,
						'settings' => [
							'title' => 'Secret Key',
							'value_type' => 'text',
						]
					],
				]
			],
			"shopier" => [
				'name' => 'Shopier',
				'title' => 'Shopier',
				'transactionFee' => '5.00',
				'fixedFee' => '0.00',
				'config' => [
					[
						'key' => 'api_key',
						'value' => null,
						'settings' => [
							'title' => 'API Kullanıcı',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'secret_key',
						'value' => null,
						'settings' => [
							'title' => 'API Şifre',
							'value_type' => 'text',
						]
					],
				]
			],
			"shipy" => [
				'name' => 'Shipy',
				'title' => 'Shipy',
				'transactionFee' => '5.00',
				'fixedFee' => '0.00',
				'config' => [
					[
						'key' => 'api_key',
						'value' => null,
						'settings' => [
							'title' => 'API Key',
							'value_type' => 'text',
						]
					],
				]
			],
			"shipy_mobile" => [
				'name' => 'Shipy (Mobil)',
				'title' => 'Shipy (Mobil)',
				'transactionFee' => '50.00',
				'fixedFee' => '0.00',
				'config' => [
					[
						'key' => 'api_key',
						'value' => null,
						'settings' => [
							'title' => 'API Key',
							'value_type' => 'text',
						]
					],
				]
			],
			"paytr" => [
				'name' => 'PayTR',
				'title' => 'PayTR',
				'transactionFee' => '5.00',
				'fixedFee' => '0.00',
				'config' => [
					[
						'key' => 'merchant_id',
						'value' => null,
						'settings' => [
							'title' => 'Mağaza No',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'merchant_key',
						'value' => null,
						'settings' => [
							'title' => 'Mağaza Parola',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'merchant_salt',
						'value' => null,
						'settings' => [
							'title' => 'Mağaza Gizli Anahtar',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'iframe_version',
						'value' => 'v2',
						'settings' => [
							'title' => 'Iframe Versiyonu',
							'value_type' => 'select',
							'values' => [
								[
									'value' => 'v1',
									'text' => 'Eski Sürüm v1'
								],
								[
									'value' => 'v2',
									'text' => 'Yeni Sürüm v2'
								]
							]
						]
					],
					[
						'key' => 'dark_theme',
						'value' => "0",
						'settings' => [
							'title' => 'Dark Mod',
							'value_type' => 'switch',
						]
					],
				]
			],
			"paytr_eft" => array(
				'name' => 'PayTR (EFT)',
				'title' => 'PayTR (EFT)',
				'transactionFee' => '1.00',
				'fixedFee' => '0.00',
				'config' => [
					[
						'key' => 'merchant_id',
						'value' => null,
						'settings' => [
							'title' => 'Mağaza No',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'merchant_key',
						'value' => null,
						'settings' => [
							'title' => 'Mağaza Parola',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'merchant_salt',
						'value' => null,
						'settings' => [
							'title' => 'Mağaza Gizli Anahtar',
							'value_type' => 'text',
						]
					],
				]
			),
			"paypal_legacy" => [
				'name' => 'PayPal (Legacy)',
				'title' => 'PayPal',
				'transactionFee' => '3.49',
				'fixedFee' => '0.49',
				'config' => [
					[
						'key' => 'email',
						'value' => null,
						'settings' => [
							'title' => 'PayPal Email',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'sandbox',
						'value' => "0",
						'settings' => [
							'title' => 'Test Mode (Sandbox)',
							'value_type' => 'switch',
						]
					],
				]
			],
			"paypal_checkout" => [
				'name' => 'PayPal Checkout',
				'title' => 'PayPal',
				'transactionFee' => '3.49',
				'fixedFee' => '0.49',
				'config' => [
					[
						'key' => 'client_id',
						'value' => null,
						'settings' => [
							'title' => 'Client ID',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'client_secret',
						'value' => null,
						'settings' => [
							'title' => 'Client Secret',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'webhook_id',
						'value' => null,
						'settings' => [
							'title' => 'Webhook ID',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'sandbox',
						'value' => null,
						'settings' => [
							'title' => 'Test Mode (Sandbox)',
							'value_type' => 'switch',
						]
					],
				]
			],
			"stripe" => [
				'name' => 'Stripe',
				'title' => 'Stripe',
				'transactionFee' => '2.90',
				'fixedFee' => '0.30',
				'config' => [
					[
						'key' => 'public_key',
						'value' => null,
						'settings' => [
							'title' => 'Publishable Key',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'secret_key',
						'value' => null,
						'settings' => [
							'title' => 'Secret Key',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'webhook_key',
						'value' => null,
						'settings' => [
							'title' => 'Signing Secret',
							'value_type' => 'text',
						]
					],
				]
			],
			"weepay" => [
				'name' => 'WeePay',
				'title' => 'WeePay',
				'transactionFee' => '5.00',
				'fixedFee' => '0.00',
				'config' => [
					[
						'key' => 'merchant_id',
						'value' => null,
						'settings' => [
							'title' => 'Bayi ID',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'api_key',
						'value' => null,
						'settings' => [
							'title' => 'API Key',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'secret_key',
						'value' => null,
						'settings' => [
							'title' => 'Secret Key',
							'value_type' => 'text',
						]
					],
				]
			],
			"paymentwall" => [
				'name' => 'Paymentwall',
				'title' => 'Paymentwall',
				'transactionFee' => '2.10',
				'fixedFee' => '0.25',
				'config' => [
					[
						'key' => 'project_key',
						'value' => null,
						'settings' => [
							'title' => 'Project Key',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'secret_key',
						'value' => null,
						'settings' => [
							'title' => 'Secret Key',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'widget_id',
						'value' => 'p1',
						'settings' => [
							'title' => 'Widget ID',
							'value_type' => 'text',
						]
					],
				]
			],
			"mercadopago" => [
				'name' => 'MercadoPago',
				'title' => 'MercadoPago',
				'transactionFee' => '4.00',
				'fixedFee' => '0.25',
				'config' => [
					[
						'key' => 'access_token',
						'value' => null,
						'settings' => [
							'title' => 'Access Token',
							'value_type' => 'text',
						]
					],
				]
			],
			"mollie" => [
				'name' => 'Mollie',
				'title' => 'Mollie',
				'transactionFee' => '2.90',
				'fixedFee' => '0.25',
				'config' => [
					[
						'key' => 'api_key',
						'value' => null,
						'settings' => [
							'title' => 'API Key',
							'value_type' => 'text',
						]
					],
				]
			],
			"payu_india" => [
				'name' => 'PayU (India)',
				'title' => 'PayU (India)',
				'transactionFee' => '2.00',
				'fixedFee' => '0.00',
				'config' => [
					[
						'key' => 'merchant_key',
						'value' => null,
						'settings' => [
							'title' => 'Merchant Key',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'merchant_salt',
						'value' => null,
						'settings' => [
							'title' => 'Merchant Salt (v1)',
							'value_type' => 'text',
						]
					],
				]
			],
			"tebex_checkout" => [
				'name' => 'Tebex Checkout',
				'title' => 'Tebex Checkout',
				'transactionFee' => '2.95',
				'fixedFee' => '0.30',
				'config' => [
					[
						'key' => 'username',
						'value' => null,
						'settings' => [
							'title' => 'Username',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'api_key',
						'value' => null,
						'settings' => [
							'title' => 'API Key',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'secret_key',
						'value' => null,
						'settings' => [
							'title' => 'Secret Key',
							'value_type' => 'text',
						]
					],
				]
			],
			"square" => [
				'name' => 'Square',
				'title' => 'Square',
				'transactionFee' => '3.30',
				'fixedFee' => '0.30',
				'config' => [
					[
						'key' => 'access_token',
						'value' => null,
						'settings' => [
							'title' => 'Access Token',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'location_id',
						'value' => null,
						'settings' => [
							'title' => 'Location ID',
							'value_type' => 'text',
						]
					],
				]
			],
			"manual" => [
				'name' => 'Manual Payment',
				'title' => 'Manual Payment',
				'transactionFee' => '0.00',
				'fixedFee' => '0.00',
				'config' => [
					[
						'key' => 'content',
						'value' => null,
						'settings' => [
							'title' => 'Content',
							'value_type' => 'html',
						]
					],
				]
			],
			"paybylink" => [
				'name' => 'PayByLink',
				'title' => 'PayByLink',
				'transactionFee' => '4.00',
				'fixedFee' => '0.30',
				'config' => [
					[
						'key' => 'shop_id',
						'value' => null,
						'settings' => [
							'title' => 'Shop ID',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'secret_key',
						'value' => null,
						'settings' => [
							'title' => 'Secret Key',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'hashing_algorithm',
						'value' => null,
						'settings' => [
							'title' => 'Hashing Algorithm',
							'value_type' => 'text',
						]
					],
				]
			],
			"cryptomus" => [
				'name' => 'Cryptomus',
				'title' => 'Cryptomus',
				'transactionFee' => '1.00',
				'fixedFee' => '0.00',
				'config' => [
					[
						'key' => 'merchant_id',
						'value' => null,
						'settings' => [
							'title' => 'Merchant ID',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'payment_api_key',
						'value' => null,
						'settings' => [
							'title' => 'Payment API Key',
							'value_type' => 'text',
						]
					],
				]
			],
			"phonepe" => [
				'name' => 'PhonePe',
				'title' => 'PhonePe',
				'transactionFee' => '4.00',
				'fixedFee' => '0.00',
				'config' => [
					[
						'key' => 'merchant_id',
						'value' => null,
						'settings' => [
							'title' => 'Merchant ID',
							'value_type' => 'text',
						]
					],
					[
						'key' => 'api_key',
						'value' => null,
						'settings' => [
							'title' => 'API Key',
							'value_type' => 'text',
						]
					],
				]
			],
		];
		
		/* Social Login Providers */
		public static array $accountLinkingProviders = [
			'discord' => 'Discord',
			'steam' => 'Steam',
			'cfx' => 'Cfx.re',
			'xbox' => 'Xbox',
			'minecraft' => 'Minecraft',
			'ingame' => 'In-Game Verification',
			'roblox' => 'Roblox',
		];
		
		/* Header */
		public static $header = [
			array(
				"title"       => "Home",
				"icon"        => "fas fa-home",
				"url"         => "/",
				"tab"         => 0,
				"route"       => "home",
				"module"      => ""
			),
			array(
				"title"       => "Store",
				"icon"        => "fas fa-shopping-cart",
				"url"         => "/store",
				"tab"         => 0,
				"route"       => "store",
				"module"      => "store"
			),
			array(
				"title"       => "Forum",
				"icon"        => "fas fa-comment",
				"url"         => "/forum",
				"tab"         => 0,
				"route"       => "forum",
				"module"      => "forum"
			),
			array(
				"title"       => "Help",
				"icon"        => "fas fa-question-circle",
				"url"         => "/help",
				"tab"         => 0,
				"route"       => "help",
				"module"      => "help"
			),
			array(
				"title"       => "Support",
				"icon"        => "fas fa-life-ring",
				"url"         => "/support/tickets",
				"tab"         => 0,
				"route"       => "support",
				"module"      => "support"
			)
		];
		
		/* Footer */
		public static $footer = [
			array(
				"title"       => "Quick Menu",
				"icon"        => "none",
				"url"         => "",
				"tab"         => 0,
				"route"       => "",
				"module"      => "",
				"children"    => [
					array(
						"title"       => "Home",
						"icon"        => "fas fa-home",
						"url"         => "/",
						"tab"         => 0,
						"route"       => "home",
						"module"      => ""
					),
					array(
						"title"       => "Store",
						"icon"        => "fas fa-shopping-cart",
						"url"         => "/store",
						"tab"         => 0,
						"route"       => "store",
						"module"      => "store"
					),
					array(
						"title"       => "Forum",
						"icon"        => "fas fa-comment",
						"url"         => "/forum",
						"tab"         => 0,
						"route"       => "forum",
						"module"      => "forum"
					),
					array(
						"title"       => "Help",
						"icon"        => "fas fa-question-circle",
						"url"         => "/help",
						"tab"         => 0,
						"route"       => "help",
						"module"      => "help"
					),
					array(
						"title"       => "Support",
						"icon"        => "fas fa-life-ring",
						"url"         => "/support/tickets",
						"tab"         => 0,
						"route"       => "support",
						"module"      => "support"
					)
				]
			),
			array(
				"title"       => "Social Media",
				"icon"        => "none",
				"url"         => "",
				"tab"         => 0,
				"route"       => "",
				"module"      => "",
				"children"    => [
					array(
						"title"       => "Facebook",
						"icon"        => "fab fa-facebook",
						"url"         => "%facebook%",
						"tab"         => 1,
						"route"       => "",
						"module"      => ""
					),
					array(
						"title"       => "Instagram",
						"icon"        => "fab fa-instagram",
						"url"         => "%instagram%",
						"tab"         => 1,
						"route"       => "",
						"module"      => ""
					),
					array(
						"title"       => "X",
						"icon"        => "fab fa-x-twitter",
						"url"         => "%x%",
						"tab"         => 1,
						"route"       => "",
						"module"      => ""
					),
					array(
						"title"       => "YouTube",
						"icon"        => "fab fa-youtube",
						"url"         => "%youtube%",
						"tab"         => 1,
						"route"       => "",
						"module"      => ""
					),
					array(
						"title"       => "TikTok",
						"icon"        => "fab fa-tiktok",
						"url"         => "%tiktok%",
						"tab"         => 1,
						"route"       => "",
						"module"      => ""
					),
					array(
						"title"       => "Discord",
						"icon"        => "fab fa-discord",
						"url"         => "%discord%",
						"tab"         => 1,
						"route"       => "",
						"module"      => ""
					),
				]
			),
			array(
				"title"       => "Links",
				"icon"        => "none",
				"url"         => "",
				"tab"         => 0,
				"route"       => "",
				"module"      => "",
				"children"    => [
					array(
						"title"       => "Rules",
						"icon"        => "none",
						"url"         => "/rules",
						"tab"         => 0,
						"route"       => "",
						"module"      => ""
					),
					array(
						"title"       => "Terms of Service",
						"icon"        => "none",
						"url"         => "/terms",
						"tab"         => 0,
						"route"       => "",
						"module"      => ""
					),
					array(
						"title"       => "Privacy Policy",
						"icon"        => "none",
						"url"         => "/privacy",
						"tab"         => 0,
						"route"       => "",
						"module"      => ""
					),
				]
			),
		];
	}