SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `LEADEROSv5`
--

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `Accounts` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `uuid` CHAR(36) NULL,
  `username` VARCHAR(255) NOT NULL,
  `realname` VARCHAR(255) NOT NULL,
  `email` VARCHAR(255) DEFAULT NULL,
  `password` VARCHAR(255) DEFAULT NULL,
  `credit` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `isVerified` ENUM('0', '1') NOT NULL DEFAULT '1',
  `creationIP` VARCHAR(40) NOT NULL DEFAULT '127.0.0.1',
  `creationDate` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP(),
  PRIMARY KEY(`id`),
  UNIQUE KEY(`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Avatars` (
    `accountID` INT(11) NOT NULL,
    `imageID` CHAR(32) NOT NULL,
    `imageType` VARCHAR(6) NOT NULL DEFAULT 'jpg',
    PRIMARY KEY(`accountID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountContactInfo` (
  `accountID` INT(11) NOT NULL,
  `firstName` VARCHAR(255) NOT NULL,
  `lastName` VARCHAR(255) NOT NULL,
  `phoneNumber` VARCHAR(255) NOT NULL,
  PRIMARY KEY(`accountID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountNoticationInfo` (
  `accountID` INT(11) NOT NULL,
  `lastReadDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`accountID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountOneSignalInfo` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `oneSignalID` CHAR(36) NOT NULL DEFAULT 'xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx',
  PRIMARY KEY(`id`),
  UNIQUE KEY(`oneSignalID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountCustomFields` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `description` TEXT NULL,
  `type` INT(2) NOT NULL,
  `isRequired` ENUM('0', '1') NOT NULL DEFAULT '0',
  `isPublic` ENUM('0', '1') NOT NULL DEFAULT '1',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountCustomFieldValues` (
  `accountID` INT(11) NOT NULL,
  `customFieldID` INT(11) NOT NULL,
  `value` TEXT NOT NULL,
  PRIMARY KEY(`accountID`, `customFieldID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountPasswordResetTokens` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `token` CHAR(32),
  `creationIP` VARCHAR(40) NOT NULL DEFAULT '127.0.0.1',
  `expiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `lastSend` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`),
  UNIQUE KEY(`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountEmailVerificationTokens` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `token` CHAR(32),
  `creationIP` VARCHAR(40) NOT NULL DEFAULT '127.0.0.1',
  `expiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `lastSend` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`),
  UNIQUE KEY(`token`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountTfaRecoverTokens` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `accountID` INT(11) NOT NULL,
    `token` CHAR(32),
    `creationIP` VARCHAR(40) NOT NULL DEFAULT '127.0.0.1',
    `expiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `lastSend` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY(`id`),
    UNIQUE KEY(`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountSessions` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `loginToken` CHAR(32),
  `useragent` TEXT NULL,
  `isTfaVerified` ENUM('0','1') NULL DEFAULT NULL,
  `creationIP` VARCHAR(40) NOT NULL DEFAULT '127.0.0.1',
  `expiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`),
  UNIQUE KEY(`loginToken`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountEmailChangeTokens` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `accountID` INT(11) NOT NULL,
    `token` CHAR(32),
    `oldEmail` VARCHAR(255) NULL,
    `newEmail` VARCHAR(255) NULL,
    `creationIP` VARCHAR(40) NOT NULL DEFAULT '127.0.0.1',
    `expiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `lastSend` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY(`id`),
    UNIQUE KEY(`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountTfaKeys` (
  `accountID` INT(11) NOT NULL,
  `secretKey` CHAR(16),
  PRIMARY KEY(`accountID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountDiscordData` (
`accountID` INT(11) NOT NULL AUTO_INCREMENT,
`discordUserID` VARCHAR(30) NOT NULL,
`updatedDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
`creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
PRIMARY KEY(`accountID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountParasutData` (
    `accountID` INT(11) NOT NULL,
    `contactID` INT(11) NOT NULL,
    PRIMARY KEY(`accountID`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `BannedAccounts` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `categoryID` ENUM('1', '2', '3') NOT NULL DEFAULT '1',
  `reasonID` ENUM('1', '2', '3', '4', '5', '6') NOT NULL DEFAULT '1',
  `expiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `News` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `categoryID` INT(11) NOT NULL,
  `imageID` CHAR(32) NOT NULL,
  `imageType` VARCHAR(6) NOT NULL DEFAULT 'jpg',
  `title` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `content` TEXT NOT NULL,
  `views` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  `commentsStatus` ENUM('0', '1') NOT NULL DEFAULT '1',
  `status` VARCHAR(255) NOT NULL DEFAULT 'published',
  `updateDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `NewsTags` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `newsID` INT(11) NOT NULL,
  `name` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `NewsCategories` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `NewsComments` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `newsID` INT(11) NOT NULL,
  `message` TEXT NOT NULL,
  `status` ENUM('0', '1') NOT NULL DEFAULT '0',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Servers` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `ip` VARCHAR(255) NOT NULL,
  `port` INT(11) NOT NULL,
  `consoleID` TINYINT(2) NOT NULL DEFAULT '1',
  `consolePort` INT(11) NULL,
  `consolePassword` VARCHAR(255) NULL,
  `consoleToken` VARCHAR(32) NULL,
  `isActive` ENUM('0', '1') NOT NULL DEFAULT '1',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `StoreVariables` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `identifier` VARCHAR(255) NOT NULL,
    `name` VARCHAR(255) NOT NULL,
    `description` VARCHAR(255) NULL,
    `type` VARCHAR(255) NOT NULL,
    PRIMARY KEY(`id`),
    UNIQUE KEY(`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `StoreVariableDropdownOptions` (
    `variableID` INT(11) NOT NULL,
    `name` VARCHAR(255) NOT NULL,
    `value` VARCHAR(255) NOT NULL,
    `price` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Products` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `categoryID` INT(11) NOT NULL,
  `giveRoleID` varchar(255) DEFAULT NULL DEFAULT '0',
  `name` VARCHAR(255) NOT NULL,
  `imageID` CHAR(32) NOT NULL,
  `imageType` VARCHAR(6) NOT NULL DEFAULT 'jpg',
  `details` TEXT NOT NULL,
  `price` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `discountedPrice` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `discountExpiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `duration` INT(4) NOT NULL,
  `stock` INT(5) NOT NULL DEFAULT '-1',
  `priority` int(11) NOT NULL DEFAULT '0',
  `isFeaturedProduct` ENUM('0', '1') NOT NULL DEFAULT '0',
  `minecraftStatus` ENUM('0', '1') NOT NULL DEFAULT '0',
  `minecraftTitle` varchar(255) DEFAULT NULL,
  `minecraftDescription` TEXT DEFAULT NULL,
  `minecraftItem` varchar(255) DEFAULT NULL,
  `minecraftItemModelID` varchar(255) DEFAULT NULL,
  `requireOnlyOneProduct` ENUM('0', '1') NOT NULL DEFAULT '0',
  `disableGifting` ENUM('0', '1') NOT NULL DEFAULT '0',
  `disableQuantity` ENUM('0', '1') NOT NULL DEFAULT '0',
  `isActive` ENUM('0', '1') NOT NULL DEFAULT '1',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ProductVariables` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `productID` INT(11) NOT NULL,
    `variableID` INT(11) NOT NULL,
    PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ProductRequiredProducts` (
    `productID` INT(11) NOT NULL,
    `requiredProductID` INT(11) NOT NULL,
    PRIMARY KEY(`productID`, `requiredProductID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ProductRequiredLinkedAccounts` (
    `productID` INT(11) NOT NULL,
    `requiredProviderID` INT(11) NOT NULL,
    PRIMARY KEY(`productID`, `requiredProviderID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ProductCommands` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `serverID` INT(11) NOT NULL,
  `productID` INT(11) NOT NULL,
  `command` TEXT NOT NULL,
  `isActive` ENUM('0', '1') NOT NULL DEFAULT '1',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ProductCategories` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `parentID` INT(11) NOT NULL DEFAULT '0',
  `name` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `imageID` CHAR(32) NOT NULL,
  `imageType` VARCHAR(6) NOT NULL DEFAULT 'jpg',
  `priority` int(11) NOT NULL DEFAULT '0',
  `minecraftStatus` ENUM('0', '1') NOT NULL DEFAULT '0',
  `minecraftTitle` varchar(255) DEFAULT NULL,
  `minecraftDescription` TEXT DEFAULT NULL,
  `minecraftItem` varchar(255) DEFAULT NULL,
  `minecraftItemModelID` varchar(255) DEFAULT NULL,
  `isActive` ENUM('0', '1') NOT NULL DEFAULT '1',
  `isCumulative` ENUM('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY(`id`),
  UNIQUE KEY(`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ProductCategoryRequiredProducts` (
    `categoryID` INT(11) NOT NULL,
    `productID` INT(11) NOT NULL,
    PRIMARY KEY(`categoryID`, `productID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Chests` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `productID` INT(11) NOT NULL,
  `status` ENUM('0', '1') NOT NULL DEFAULT '0',
  `isLocked` ENUM('0', '1') NOT NULL DEFAULT '0',
  `canGift` ENUM('0', '1') NOT NULL DEFAULT '1',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ChestProductVariableValues` (
    `chestID` INT(11) NOT NULL,
    `variableID` INT(11) NOT NULL,
    `value` VARCHAR(255) NOT NULL,
    PRIMARY KEY (`chestID`, `variableID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Lotteries` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `price` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `duration` INT(4) NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE KEY(`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `LotteryAwards` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `lotteryID` INT(11) NOT NULL,
  `title` VARCHAR(255) NOT NULL,
  `chance` DECIMAL(5,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `awardType` ENUM('1', '2', '3') NOT NULL DEFAULT '1',
  `award` INT(11) NOT NULL,
  `color` VARCHAR(32) NOT NULL DEFAULT '#000000',
  `isEnabled` ENUM('0', '1') NOT NULL DEFAULT '1',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ProductGifts` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `giftType` ENUM('1', '2') NOT NULL DEFAULT '1',
  `gift` INT(11) NOT NULL,
  `redeemLimit` INT(6) NOT NULL DEFAULT '-1',
  `expiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`),
  UNIQUE KEY(`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ProductCoupons` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `products` TEXT NOT NULL,
  `discount` INT(3) UNSIGNED NOT NULL DEFAULT '0',
  `redeemLimit` INT(6) NOT NULL DEFAULT '-1',
  `redeemLimitPerCustomer` INT(6) NOT NULL DEFAULT '1',
  `minPayment` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `expiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`),
  UNIQUE KEY(`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `CreatorCodes` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `creatorID` INT(11) NOT NULL,
    `code` VARCHAR(255) NOT NULL,
    `discount` INT(3) UNSIGNED NOT NULL DEFAULT '0',
    `share` INT(3) UNSIGNED NOT NULL DEFAULT '0',
    `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY(`id`),
    UNIQUE KEY(`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ChestsHistory` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `otherAccountID` INT(11) DEFAULT NULL,
  `chestID` INT(11) NOT NULL,
  `type` ENUM('1', '2', '3') NOT NULL DEFAULT '1',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `LotteryHistory` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `lotteryAwardID` INT(11) UNSIGNED NOT NULL,
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ProductGiftsHistory` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `giftID` INT(11) UNSIGNED NOT NULL,
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ProductCouponsHistory` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `couponID` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  `productID` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `CreditHistory` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `otherAccountID` INT(11) DEFAULT NULL,
  `type` INT(2) NOT NULL DEFAULT '1',
  `price` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `OrderCreatorCodes` (
    `orderID` INT(11) NOT NULL,
    `codeID` INT(11) NOT NULL,
    `discount` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
    `revenueShare` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
    PRIMARY KEY(`orderID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Leaderboards` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `serverName` VARCHAR(255) NOT NULL,
  `serverSlug` VARCHAR(255) NOT NULL,
  `mysqlServer` VARCHAR(255) NOT NULL DEFAULT '0',
  `mysqlPort` INT(11) NOT NULL,
  `mysqlUsername` VARCHAR(255) NOT NULL,
  `mysqlPassword` VARCHAR(255) NOT NULL,
  `mysqlDatabase` VARCHAR(255) NOT NULL,
  `mysqlTable` VARCHAR(255) NOT NULL,
  `usernameColumn` VARCHAR(255) NOT NULL,
  `tableTitles` TEXT NOT NULL,
  `tableData` TEXT NOT NULL,
  `sorter` VARCHAR(255) NOT NULL,
  `dataLimit` ENUM('10', '25', '50', '100') NOT NULL DEFAULT '100',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Supports` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `categoryID` INT(11) NOT NULL,
  `title` VARCHAR(255) NOT NULL,
  `statusID` ENUM('1', '2', '3', '4') NOT NULL DEFAULT '1',
  `readStatus` ENUM('0', '1') NOT NULL DEFAULT '0',
  `discordChannelID` VARCHAR(32) NULL,
  `updateDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `SupportMessages` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `supportID` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  `message` TEXT NOT NULL,
  `writeLocation` ENUM('1', '2') NOT NULL DEFAULT '1',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `SupportCategories` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(255) NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `SupportCategoryPermissions` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `name` varchar(255) NOT NULL,
    `description` TEXT NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY(`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `SupportCategoryRolePermissions` (
    `roleID` int(11) NOT NULL,
    `permissionID` int(11) NOT NULL,
    `categoryID` int(11) NOT NULL,
    PRIMARY KEY (`roleID`, `permissionID`, `categoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `SupportAnswers` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `content` TEXT NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Games` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `imageID` CHAR(32) NOT NULL,
  `imageType` VARCHAR(6) NOT NULL DEFAULT 'jpg',
  `content` TEXT NOT NULL,
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Pages` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `content` MEDIUMTEXT NOT NULL,
  `isActive` ENUM('0', '1') NOT NULL DEFAULT '1',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Downloads` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `content` TEXT NOT NULL,
  `downloadURL` TEXT NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `PaymentGateways` (
  `name` VARCHAR(255) NOT NULL,
  `title` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `currency` CHAR(3) DEFAULT NULL,
  `feeStatus` ENUM('0','1') NOT NULL DEFAULT '0',
  `transactionFee` DECIMAL(5,2) NOT NULL DEFAULT '0.00',
  `fixedFee` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `config` TEXT NOT NULL,
  `order` int(11) NOT NULL DEFAULT '0',
  `status` ENUM('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY(`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Broadcast` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `url` VARCHAR(255) NOT NULL DEFAULT '#',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ApplicationForms` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `description` TEXT NOT NULL,
  `reappliable` ENUM('0', '1') NOT NULL DEFAULT '1',
  `isEnabled` ENUM('0', '1') NOT NULL DEFAULT '1',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ApplicationFormQuestions` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `formID` INT(11) NOT NULL,
  `question` TEXT NOT NULL,
  `type` INT(2) NOT NULL,
  `variables` TEXT NOT NULL,
  `isEnabled` ENUM('0', '1') NOT NULL DEFAULT '1',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Applications` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `formID` INT(11) NOT NULL,
  `reason` TEXT DEFAULT NULL,
  `status` INT(1) UNSIGNED NOT NULL DEFAULT '2',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ApplicationAnswers` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `applicationID` INT(11) NOT NULL,
  `questionID` INT(11) NOT NULL,
  `answer` TEXT NOT NULL,
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Slider` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `content` TEXT NOT NULL,
  `url` VARCHAR(255) NOT NULL DEFAULT '#',
  `imageID` CHAR(32) NOT NULL,
  `imageType` VARCHAR(6) NOT NULL DEFAULT 'jpg',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Settings` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `value` LONGTEXT NULL,
  PRIMARY KEY(`id`),
  UNIQUE KEY(`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Notifications` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `type` ENUM('1', '2', '3', '4') NOT NULL DEFAULT '1',
  `variables` VARCHAR(255) NOT NULL,
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ConsoleHistory` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `serverID` INT(11) NOT NULL,
  `command` VARCHAR(255) NOT NULL,
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ChatHistory` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `message` TEXT NOT NULL,
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `OnlineAccountsHistory` (
  `accountID` INT(11) NOT NULL,
  `type` ENUM('0', '1') NOT NULL DEFAULT '0',
  `expiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`accountID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `HelpArticles` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `accountID` int(11) NOT NULL,
    `topicID` int(11) NOT NULL,
    `title` varchar(255) NOT NULL,
    `slug` varchar(255) NOT NULL,
    `content` text NOT NULL,
    `views` int(10) unsigned NOT NULL DEFAULT 0,
    `likesCount` int(10) unsigned NOT NULL DEFAULT 0,
    `dislikesCount` int(10) unsigned NOT NULL DEFAULT 0,
    `order` int(11) NOT NULL DEFAULT '0',
    `updateDate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
    `creationDate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `HelpTopics` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `name` varchar(255) NOT NULL,
    `slug` varchar(255) NOT NULL,
    `description` text NOT NULL,
    `imageID` char(32) NOT NULL,
    `imageType` varchar(6) NOT NULL DEFAULT 'jpg',
    `order` int(11) NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Languages` (
    `code` VARCHAR(10) NOT NULL,
    `name` VARCHAR(255) NOT NULL,
    `isActive` ENUM('0', '1') NOT NULL DEFAULT '1',
    PRIMARY KEY(`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Modules` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `description` TEXT NOT NULL,
  `isEnabled` ENUM('0', '1') NOT NULL DEFAULT '1',
  PRIMARY KEY(`id`),
  UNIQUE KEY(`name`, `slug`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ModuleSettings` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `moduleID` int(11) NOT NULL,
    `name` VARCHAR(255) NOT NULL,
    `value` LONGTEXT NULL,
    PRIMARY KEY(`id`),
    CONSTRAINT UQ_Module_Key UNIQUE (moduleID, `name`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `CustomForms` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `description` TEXT NOT NULL,
  `isEnabled` ENUM('0', '1') NOT NULL DEFAULT '1',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `CustomFormQuestions` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `formID` INT(11) NOT NULL,
  `question` TEXT NOT NULL,
  `type` INT(2) NOT NULL,
  `variables` TEXT NOT NULL,
  `isEnabled` ENUM('0', '1') NOT NULL DEFAULT '1',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Forms` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `formID` INT(11) NOT NULL,
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `FormAnswers` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `applicationID` INT(11) NOT NULL,
  `questionID` INT(11) NOT NULL,
  `answer` TEXT NOT NULL,
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `BazaarServers` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(255) NOT NULL,
    `slug` VARCHAR(255) NOT NULL,
    `imageID` CHAR(32) NOT NULL,
    `imageType` VARCHAR(6) NOT NULL DEFAULT 'jpg',
    `priority` int(11) NOT NULL DEFAULT '0',
    `isActive` ENUM('0', '1') NOT NULL DEFAULT '1',
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `BazaarItems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner` int(11) NOT NULL,
  `serverID` int(11) NOT NULL,
  `itemID` varchar(255) NOT NULL,
  `modelID` int(11) DEFAULT NULL,
  `name` text NULL,
  `lore` text NULL,
  `amount` int(11) NOT NULL DEFAULT 1,
  `durability` int(11) NOT NULL,
  `maxDurability` int(11) NOT NULL,
  `enchantments` text NULL,
  `base64` text NOT NULL,
  `description` text NULL,
  `price` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `sold` ENUM('0', '1') NOT NULL DEFAULT '0',
  `creationDate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `BazaarCustomItemImages` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `serverID` INT(11) NOT NULL,
  `itemID` varchar(255) NOT NULL,
  `modelID` int(11) NOT NULL,
  `imageID` CHAR(32) NOT NULL,
  `imageType` VARCHAR(6) NOT NULL DEFAULT 'jpg',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `BazaarHistory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `itemID` int(11) NOT NULL,
  `accountID` int(11) NOT NULL,
  `type` ENUM('0', '1') NOT NULL DEFAULT '0',
  `creationDate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `usernameCSS` TEXT NULL,
  `badgeCSS` TEXT NULL,
  `priority` int(11) NOT NULL DEFAULT '0',
  `discordRoleID` varchar(32) NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY(`name`, `slug`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` TEXT NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY(`name`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `RolePermissions` (
  `roleID` int(11) NOT NULL,
  `permissionID` int(11) NOT NULL,
  PRIMARY KEY (`roleID`, `permissionID`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountPermissions` (
  `accountID` int(11) NOT NULL,
  `permissionID` int(11) NOT NULL,
  PRIMARY KEY (`accountID`, `permissionID`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountRoles` (
  `accountID` int(11) NOT NULL,
  `roleID` int(11) NOT NULL,
  `expiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`accountID`, `roleID`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ForumPermissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` TEXT NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY(`name`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ForumRolePermissions` (
  `roleID` int(11) NOT NULL,
  `permissionID` int(11) NOT NULL,
  `categoryID` int(11) NOT NULL,
  PRIMARY KEY (`roleID`, `permissionID`, `categoryID`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `accountID` int(11) NOT NULL,
  `action` varchar(255) NOT NULL,
  `data` TEXT NULL,
  `ip` varchar(255) NOT NULL,
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ShoppingCarts` (
  `accountID` int(11) NOT NULL,
  `couponID` int(11) NULL,
  `creatorCodeID` INT(11) NULL,
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`accountID`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ShoppingCartProducts` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `shoppingCartID` int(11) NOT NULL,
    `productID` int(11) NOT NULL,
    `quantity` int(11) NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ShoppingCartProductVariableValues` (
    `cartProductID` INT(11) NOT NULL,
    `variableID` INT(11) NOT NULL,
    `value` VARCHAR(255) NOT NULL,
    PRIMARY KEY (`cartProductID`, `variableID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `accountID` int(11) NOT NULL,
  `coupon` varchar(255) NULL,
  `total` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `discount` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `subtotal` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `tax` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `gatewayFee` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `paymentID` VARCHAR(255) NOT NULL DEFAULT '0',
  `paymentAPI` VARCHAR(255) NOT NULL DEFAULT 'other',
  `type` int(3) NOT NULL DEFAULT '1',
  `credit` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `earnings` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `cashback` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `status` int(3) NOT NULL DEFAULT '0',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `OrderProducts` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `orderID` int(11) NOT NULL,
    `productID` int(11) NOT NULL,
    `quantity` int(11) NOT NULL,
    `unitPrice` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `OrderProductVariableValues` (
    `orderProductID` INT(11) NOT NULL,
    `variableID` INT(11) NOT NULL,
    `value` VARCHAR(255) NOT NULL,
    PRIMARY KEY (`orderProductID`, `variableID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `OrderCredits` (
    `orderID` int(11) NOT NULL,
    `amount` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
    `bonus` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
    PRIMARY KEY (`orderID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `OrderCreditPackages` (
  `orderID` int(11) NOT NULL,
  `packageID` int(11) NOT NULL,
  PRIMARY KEY (`orderID`, `packageID`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `CommandLogs` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `dataType` VARCHAR(255) NOT NULL DEFAULT 'order',
    `dataID` VARCHAR(255) NOT NULL,
    `commandID` INT(11) NOT NULL,
    `identifier` VARCHAR(255) NOT NULL,
    `command` TEXT NOT NULL,
    `retry` TINYINT(3) NOT NULL DEFAULT '0',
    `status` VARCHAR(255) NOT NULL DEFAULT 'waiting',
    `updatedAt` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ForumCategories` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `parentID` INT(11) NOT NULL DEFAULT '0',
  `name` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `description` TEXT NULL,
  `imageID` CHAR(32) NOT NULL,
  `imageType` VARCHAR(6) NOT NULL DEFAULT 'jpg',
  `isEnabled` ENUM('0', '1') NOT NULL DEFAULT '1',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ForumCategoryRoles` (
  `categoryID` INT(11) NOT NULL,
  `roleID` INT(11) NOT NULL,
  `type` INT(11) NOT NULL,
  PRIMARY KEY(`categoryID`, `roleID`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ForumThreads` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `categoryID` INT(11) NOT NULL,
  `title` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `content` TEXT NOT NULL,
  `views` INT(11) NOT NULL,
  `isLocked` ENUM('0', '1') NOT NULL DEFAULT '0',
  `isPinned` ENUM('0', '1') NOT NULL DEFAULT '0',
  `updatedDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ForumReplies` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `accountID` INT(11) NOT NULL,
  `threadID` INT(11) NOT NULL,
  `replyTo` INT(11) NULL DEFAULT NULL,
  `message` TEXT NOT NULL,
  `updatedDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `VIPTables` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `categoryID` INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `VIPs` (
  `tableID` INT(11) NOT NULL,
  `vipID` INT(11) NOT NULL,
  PRIMARY KEY(`tableID`, `vipID`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `VIPTitles` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `tableID` INT(11) NOT NULL,
  `title` VARCHAR(255) NOT NULL,
  `priority` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `VIPDesc` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `vipID` INT(11) NOT NULL,
  `titleID` INT(11) NOT NULL,
  `description` VARCHAR(255) NOT NULL,
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `VIPExplain` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `titleID` INT(11) NOT NULL,
  `name` VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `SeoPages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` TEXT NULL,
  `image` TEXT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY(`page`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `GamingNightProducts` (
  `productID` INT(11) NOT NULL,
  `price` INT(11) NOT NULL,
  `stock` INT(11) NOT NULL,
  PRIMARY KEY(`productID`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Currencies` (
  `code` CHAR(3) NOT NULL,
  `symbol` VARCHAR(5) NOT NULL,
  `rate` DECIMAL(20,10) UNSIGNED NOT NULL DEFAULT '1.0',
  `label` VARCHAR(255) NULL,
  `prefix` VARCHAR(255) NULL,
  `suffix` VARCHAR(255) NULL,
  `autoUpdate` ENUM('0', '1') NOT NULL DEFAULT '1',
  `isActive` ENUM('0', '1') NOT NULL DEFAULT '1',
  PRIMARY KEY(`code`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `CreditPackages` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `imageID` CHAR(32) NOT NULL,
  `imageType` VARCHAR(6) NOT NULL DEFAULT 'jpg',
  `amount` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  `bonus` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  `price` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `discountedPrice` DECIMAL(8,2) UNSIGNED NOT NULL DEFAULT '0.00',
  `discountExpiryDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  `stock` INT(5) NOT NULL DEFAULT '-1',
  `details` TEXT NOT NULL,
  `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `VoteLinks` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `link` VARCHAR(255) NOT NULL,
  PRIMARY KEY(`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `CustomSupportFields` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `categoryID` INT(11) NOT NULL,
    `field` TEXT NOT NULL,
    `type` INT(2) NOT NULL,
    `variables` TEXT NOT NULL,
    `isEnabled` ENUM('0', '1') NOT NULL DEFAULT '1',
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `CustomSupportFieldValues` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `supportID` INT(11) NOT NULL,
    `fieldID` INT(11) NOT NULL,
    `value` TEXT NOT NULL,
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Suggestions` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `accountID` int(11) NOT NULL,
    `categoryID` int(11) NOT NULL,
    `title` varchar(255) NOT NULL,
    `slug` varchar(255) NOT NULL,
    `content` text NOT NULL,
    `views` int(10) unsigned NOT NULL DEFAULT 0,
    `likesCount` int(10) unsigned NOT NULL DEFAULT 0,
    `dislikesCount` int(10) unsigned NOT NULL DEFAULT 0,
    `updatedDate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
    `creationDate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `SuggestionLikes` (
    `accountID` VARCHAR(255) NOT NULL,
    `suggestionID` INT(11) NOT NULL,
    PRIMARY KEY(`accountID`, `suggestionID`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `SuggestionDislikes` (
    `accountID` VARCHAR(255) NOT NULL,
    `suggestionID` INT(11) NOT NULL,
    PRIMARY KEY(`accountID`, `suggestionID`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `SuggestionCategories` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(255) NOT NULL,
    `slug` VARCHAR(255) NOT NULL,
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `SuggestionReplies` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `suggestionID` INT(11) NOT NULL,
    `accountID` INT(11) NOT NULL,
    `message` TEXT NOT NULL,
    `updatedDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `CustomTranslate` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `language` VARCHAR(10) NOT NULL,
    `key` TEXT NOT NULL,
    `value` TEXT NOT NULL,
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Subscriptions` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `accountID` INT(11) NOT NULL,
    `productID` INT(11) NOT NULL,
    `reference` VARCHAR(255) NULL DEFAULT NULL,
    `isCancelled` ENUM('0', '1') NOT NULL DEFAULT '0',
    `endsAt` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `startsAt` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `updatedDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY(`id`),
    UNIQUE KEY(`reference`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `UrlRedirects` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `from` VARCHAR(255) NULL,
    `to` VARCHAR(255) NULL,
    `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `TebexProducts` (
    `id` INT(11) NOT NULL,
    `name` VARCHAR(255) NOT NULL,
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `DiscordWebhooks` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(255) NULL,
    `url` VARCHAR(255) NULL,
    `event` VARCHAR(255) NULL,
    `botName` VARCHAR(255) NULL,
    `botAvatar` VARCHAR(255) NULL,
    `data` TEXT NULL,
    `isActive` ENUM('0', '1') NOT NULL DEFAULT '1',
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `PurchasedProducts` (
    `accountID` INT(11) NOT NULL,
    `productID` INT(11) NOT NULL,
    `expiresAt` DATETIME NULL DEFAULT NULL,
    `purchasedAt` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY(`accountID`, `productID`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `Changelogs` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `title` VARCHAR(255) NOT NULL,
    `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ChangelogTags` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(255) NOT NULL,
    `badgeCSS` TEXT NULL,
    PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ChangelogItems` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `changelogID` int(11) NOT NULL,
    `tagID` int(11) NOT NULL,
    `content` TEXT NULL,
    PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `AccountLinkingProviders` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(255) NOT NULL,
    `slug` VARCHAR(255) NOT NULL,
    `isEnabled` ENUM('0', '1') NOT NULL DEFAULT '1',
    PRIMARY KEY(`id`),
    UNIQUE KEY(`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `LinkedAccounts` (
    `providerID` INT(11) NOT NULL,
    `accountID` INT(11) NOT NULL,
    `identifier` VARCHAR(255) NOT NULL,
    `displayName` VARCHAR(255) NOT NULL,
    `customData` TEXT NULL,
    `creationDate` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY(`providerID`, `accountID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `FailedJobs` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(255) NOT NULL,
    `payload` TEXT NOT NULL,
    `attempts` INT DEFAULT 1,
    `maxAttempts` INT DEFAULT 3,
    `error` TEXT NULL,
    `isProcessing` ENUM('0', '1') NOT NULL DEFAULT '0',
    `lastRetryAt` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `createdAt` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
