<?php
	define("__ROOT__", $_SERVER["DOCUMENT_ROOT"]);
	const INSTALLER_PREFIX = "install";
	
	if(!session_id()) session_start();
	
	require '../vendor/autoload.php';
	
	require_once '../../main/app/config/status.php';
	if (isset($_GET["action"]) && $_GET["action"] == "check") {
		echo json_encode([
			'status' => INSTALL_STATUS
		]);
		exit;
	}
	if (INSTALL_STATUS) {
		header("Location: /");
		exit;
	}
	require_once '../../main/app/config/app.php';
	require_once '../core/helper.php';
	
	use Install\Handlers\CsrfExceptionHandler;
	use Install\Handlers\RouteExceptionHandler;
	use Install\Middlewares\CsrfVerifier;
	use Pecee\SimpleRouter\SimpleRouter;
	
	// Routes
	SimpleRouter::group(['exceptionHandler' => [
		RouteExceptionHandler::class,
		CsrfExceptionHandler::class
	]], function () {
		SimpleRouter::group([
			'prefix' => '/' . INSTALLER_PREFIX,
		], function () {
			require_once '../app/config/routes.php';
		});
	});
	
	SimpleRouter::csrfVerifier(new CsrfVerifier());
	SimpleRouter::setDefaultNamespace('\Install\Controllers');
	
	try {
		SimpleRouter::start();
	} catch (Exception $e) {
		var_dump($e);
		return;
	}
