<?php
	
	use Main\Controllers\Account\SettingsController as AccountSettingsController;
	use Main\Controllers\Account\AccountController;
	use Main\Controllers\AiController;
	use Main\Controllers\Auth\EmailController;
	use Main\Controllers\ChangelogController;
	use Main\Controllers\DiscordController;
	use Main\Controllers\ErrorController;
	use Main\Controllers\Account\ContactController as AccountContactController;
	use Main\Controllers\Application\ApplicationController;
	use Main\Controllers\Application\FormController as ApplicationFormController;
	use Main\Controllers\Auth\ForgotPasswordController;
	use Main\Controllers\Auth\LoginController;
	use Main\Controllers\Auth\LogoutController;
	use Main\Controllers\Auth\RegisterController;
	use Main\Controllers\Auth\ResetPasswordController;
	use Main\Controllers\Bazaar\BazaarController;
	use Main\Controllers\Bazaar\ManagementController as BazaarManagementController;
	use Main\Controllers\Bazaar\ProductController as BazaarProductController;
	use Main\Controllers\Bazaar\ServerController as BazaarServerController;
	use Main\Controllers\Blog\CategoryController as BlogCategoryController;
	use Main\Controllers\Blog\CommentController as BlogCommentController;
	use Main\Controllers\Blog\PostController as BlogPostController;
	use Main\Controllers\Blog\TagController as BlogTagController;
	use Main\Controllers\Chest\ChestController;
	use Main\Controllers\Chest\GiftController as ChestGiftController;
	use Main\Controllers\Credit\ChargeController as ChargeCreditController;
	use Main\Controllers\Credit\PackageController as CreditPackageController;
	use Main\Controllers\Credit\SendCreditController;
	use Main\Controllers\CustomForm\AnswerController as CustomFormAnswerController;
	use Main\Controllers\CustomForm\CustomFormController;
	use Main\Controllers\DiscordLegacyController;
	use Main\Controllers\DownloadController;
	use Main\Controllers\EmailVerificationController;
	use Main\Controllers\Forum\CategoryController as ForumCategoryController;
	use Main\Controllers\Forum\ForumController;
	use Main\Controllers\Forum\ReplyController as ForumReplyController;
	use Main\Controllers\Forum\ThreadController as ForumThreadController;
	use Main\Controllers\GameController;
	use Main\Controllers\GamingNight\GamingNightController;
	use Main\Controllers\GamingNight\ProductController as GamingNightProductController;
	use Main\Controllers\GiftController;
	use Main\Controllers\Help\ArticleController as HelpArticleController;
	use Main\Controllers\Help\HelpController;
	use Main\Controllers\Help\TopicController as HelpTopicController;
	use Main\Controllers\HomeController;
	use Main\Controllers\LeaderboardController;
	use Main\Controllers\FortuneWheelController;
	use Main\Controllers\MemberController;
	use Main\Controllers\OrderController;
	use Main\Controllers\PageController;
	use Main\Controllers\PaymentController;
	use Main\Controllers\PlayController;
	use Main\Controllers\PunishmentController;
	use Main\Controllers\RobotTxtController;
	use Main\Controllers\SitemapController;
	use Main\Controllers\AccountLinkingController;
	use Main\Controllers\StaffController;
	use Main\Controllers\Store\CategoryController as StoreCategoryController;
	use Main\Controllers\Store\CartController;
	use Main\Controllers\Store\ProductController as StoreProductController;
	use Main\Controllers\Store\StoreController;
	use Main\Controllers\Suggestion\CategoryController as SuggestionCategoryController;
	use Main\Controllers\Suggestion\ReplyController as SuggestionReplyController;
	use Main\Controllers\Suggestion\SuggestionController;
	use Main\Controllers\Support\TicketController as SupportTicketController;
	use Main\Controllers\Tebex\WebhookController as TebexWebhookController;
	use Main\Controllers\TFA\RecoverController as TfaRecoverController;
	use Main\Controllers\TFA\SetupController as TfaSetupController;
	use Main\Controllers\TFA\TfaController;
	use Main\Controllers\VoteController;
	use Main\Controllers\Tebex\StoreController as TebexStoreController;
	use Main\Middlewares\ProtectedRouteMiddleware;
	use Pecee\SimpleRouter\SimpleRouter as Router;
	
	/**
	 * Errors
	 */
	Router::get('/403', [ErrorController::class, 'forbidden'])->name('403');
	Router::get('/404', [ErrorController::class, 'notFound'])->name('404');
	
	/**
	 * Homepage
	 */
	Router::get('/', [HomeController::class, 'index'])->name('home');
	
  /**
   * Auth routes
   */
	Router::get('/login', [LoginController::class, 'index'])->name('auth.login');
	Router::post('/login', [LoginController::class, 'login']);
	
	Router::get('/register', [RegisterController::class, 'index'])->name('auth.register');
	Router::post('/register', [RegisterController::class, 'register']);
	
	Router::get('/forgot-password', [ForgotPasswordController::class, 'index'])->name('auth.forgot-password');
	Router::post('/forgot-password', [ForgotPasswordController::class, 'forgotPassword']);
	
	Router::get('/reset-password/{token}', [ResetPasswordController::class, 'index'])->name('auth.reset-password');
	Router::post('/reset-password/{token}', [ResetPasswordController::class, 'resetPassword']);
	
	Router::get('/set-email', [EmailController::class, 'index'])->name('auth.email')->addMiddleware(ProtectedRouteMiddleware::class);
	Router::post('/set-email', [EmailController::class, 'setEmail'])->addMiddleware(ProtectedRouteMiddleware::class);
	
	Router::post('/logout', [LogoutController::class, 'logout'])->name('auth.logout')->addMiddleware(ProtectedRouteMiddleware::class);
	
	/**
	 * Download
	 */
	if (modules('download')->isActive()) {
		Router::get('/download', [DownloadController::class, 'index'])->name('download.index');
		Router::get('/download/{id}/{slug}', [DownloadController::class, 'show'])->name('download.show');
	}
	
	
	/**
	 * Members
	 */
	if (modules('player')->isActive()) {
		Router::get('/members', [MemberController::class, 'index'])->name('members.index');
		Router::get('/members/{id}', [MemberController::class, 'show'])->name('members.show');
	}
	
	/**
	 * Blog
	 */
	if (modules('blog')->isActive()) {
		Router::get('/blog', [BlogPostController::class, 'index'])->name('blog.posts.index');
		Router::get('/blog/posts/{slug}', [BlogPostController::class, 'show'])->name('blog.posts.show');
		Router::get('/blog/categories/{slug}', [BlogCategoryController::class, 'show'])->name('blog.categories.show');
		Router::get('/blog/tags/{slug}', [BlogTagController::class, 'show'])->name('blog.tags.show');
		Router::post('/blog/posts/{postId}/comments', [BlogCommentController::class, 'store'])->name('blog.comments.store')->addMiddleware(ProtectedRouteMiddleware::class);
	}
	
	/**
	 * Discord
	 */
	if (modules('discord_bot')->isActive()) {
		Router::group(['middleware' => ProtectedRouteMiddleware::class], function () {
			Router::get('/discord/link', [DiscordController::class, 'link'])->name('discord.link');
			Router::post('/discord/unlink', [DiscordController::class, 'unlink'])->name('discord.unlink');
		});
	} else if (modules('discord')->isActive()) { // Legacy Bot
		Router::get('/discord/login', [DiscordLegacyController::class, 'login'])->name('discord.login');
		Router::group(['middleware' => ProtectedRouteMiddleware::class], function () {
			Router::get('/discord/link', [DiscordLegacyController::class, 'link'])->name('discord.link');
			Router::post('/discord/unlink', [DiscordLegacyController::class, 'unlink'])->name('discord.unlink');
		});
	}
	
	/**
	 * Account Linking
	 */
	if (modules('account_linking')->isActive()) {
		Router::get('/login-with/{provider}', [AccountLinkingController::class, 'login'])->name('account-linking.login');
		Router::group(['middleware' => ProtectedRouteMiddleware::class], function () {
			Router::get('/account-linking/{provider}/link', [AccountLinkingController::class, 'link'])->name('account-linking.link');
			Router::post('/account-linking/{provider}/unlink', [AccountLinkingController::class, 'unlink'])->name('account-linking.unlink');
		});
	}
	
	/**
	 * Store
	 */
	if (modules('store')->isActive() && !modules('tebex_store')->isActive()) {
		Router::get('/store', [StoreController::class, 'index'])->name('store.index');
		Router::get('/store/products/{id}', [StoreProductController::class, 'show'])->name('store.products.show');
		Router::get('/store/{slug}', [StoreCategoryController::class, 'show'])->name('store.categories.show');
	}
	
	/**
	 * Credit
	 */
	if (modules('credit')->isActive()) {
		Router::group(['middleware' => ProtectedRouteMiddleware::class], function () {
			Router::get('/credits/packages', [CreditPackageController::class, 'index'])->name('credits.packages.index');
			Router::get('/credits/packages/{id}', [CreditPackageController::class, 'show'])->name('credits.packages.show');
			Router::post('/credits/packages/{id}/buy', [CreditPackageController::class, 'buy'])->name('credits.packages.buy');
			Router::get('/credits/charge', [ChargeCreditController::class, 'index'])->name('credits.charge.index');
			Router::post('/credits/charge', [ChargeCreditController::class, 'charge'])->name('credits.charge.action');
			Router::get('/credits/send', [SendCreditController::class, 'index'])->name('credits.send.index');
			Router::get('/credits/send/{id}', [SendCreditController::class, 'to'])->name('credits.send.to');
			Router::post('/credits/send', [SendCreditController::class, 'send'])->name('credits.send.action');
		});
	}
	
	/**
	 * Payment
	 */
	Router::all('/payment/callback/{provider}', [PaymentController::class, 'callback'])->name('payment.callback');
	Router::all('/callback/{provider}', [PaymentController::class, 'callback']);
	Router::all('/islem/{provider}', [PaymentController::class, 'callback']);
	
	Router::group(['middleware' => ProtectedRouteMiddleware::class], function () {
		Router::get('/payment/pay/manual/{orderId}', [PaymentController::class, 'payManual'])->name('payment.pay.manual');
		Router::get('/payment/pay/{provider}/{orderId}', [PaymentController::class, 'pay'])->name('payment.pay');
		
		Router::all('/payment/success', [PaymentController::class, 'success'])->name('payment.success');
		Router::all('/payment/error', [PaymentController::class, 'error'])->name('payment.error');
	});
	
	/**
	 * Leaderboards
	 */
	if (modules('leaderboards')->isActive()) {
		Router::get('/leaderboards', [LeaderboardController::class, 'index'])->name('leaderboards.index');
		Router::get('/leaderboards/{slug}', [LeaderboardController::class, 'show'])->name('leaderboards.show');
	}
	
	/**
	 * Games
	 */
	if (modules('games')->isActive()) {
		Router::get('/games', [GameController::class, 'index'])->name('games.index');
		Router::get('/games/{slug}', [GameController::class, 'show'])->name('games.show');
	}
	
	/**
	 * Help
	 */
	if (modules('help')->isActive()) {
		Router::get('/help', [HelpController::class, 'index'])->name('help.index');
		Router::get('/help/search', [HelpController::class, 'search'])->name('help.search');
		Router::post('/help/articles/{id}/rate', [HelpArticleController::class, 'rate'])->name('help.articles.rate');
		Router::get('/help/articles/{id}/{slug}', [HelpArticleController::class, 'show'])->name('help.articles.show');
		Router::get('/help/topics/{slug}', [HelpTopicController::class, 'show'])->name('help.topics.show');
	}
	
	/**
	 * Gaming Night
	 */
	if (modules('gaming_night')->isActive()) {
		Router::get('/gaming-night', [GamingNightController::class, 'index'])->name('gaming-night.index');
		Router::get('/gaming-night/products/{id}', [GamingNightProductController::class, 'show'])->name('gaming-night.products.show');
		Router::post('/gaming-night/products/{id}/buy', [GamingNightProductController::class, 'buy'])->name('gaming-night.products.buy')->addMiddleware(ProtectedRouteMiddleware::class);
	}

	/**
	 * Forum
	 */
	if (modules('forum')->isActive()) {
		Router::get('/forum', [ForumController::class, 'index'])->name('forum.index');
		
		Router::get('/forum/categories/{id}/{slug}', [ForumCategoryController::class, 'show'])->name('forum.categories.show');
		
		Router::group(['middleware' => ProtectedRouteMiddleware::class], function () {
			Router::get('/forum/threads/create', [ForumThreadController::class, 'create'])->name('forum.threads.create');
			Router::post('/forum/threads', [ForumThreadController::class, 'store'])->name('forum.threads.store');
			Router::get('/forum/threads/{id}/edit', [ForumThreadController::class, 'edit'])->name('forum.threads.edit');
			Router::patch('/forum/threads/{id}', [ForumThreadController::class, 'update'])->name('forum.threads.update');
			Router::post('/forum/threads/{id}/pin', [ForumThreadController::class, 'pin'])->name('forum.threads.pin');
			Router::post('/forum/threads/{id}/lock', [ForumThreadController::class, 'lock'])->name('forum.threads.lock');
			Router::post('/forum/threads/{id}/reply', [ForumThreadController::class, 'reply'])->name('forum.threads.reply');
			Router::delete('/forum/threads/{id}', [ForumThreadController::class, 'destroy'])->name('forum.threads.destroy');
			
			Router::get('/forum/replies/{id}/edit', [ForumReplyController::class, 'edit'])->name('forum.replies.edit');
			Router::patch('/forum/replies/{id}', [ForumReplyController::class, 'update'])->name('forum.replies.update');
			Router::delete('/forum/replies/{id}', [ForumReplyController::class, 'destroy'])->name('forum.replies.destroy');
			
			Router::post('/forum/upload', [ForumController::class, 'upload'])->name('forum.upload');
		});
		Router::get('/forum/threads/{id}/{slug}', [ForumThreadController::class, 'show'])->name('forum.threads.show');
	}
	
	/**
	 * Punishments
	 */
	if (modules('punishments')->isActive()) {
		Router::get('/punishments', [PunishmentController::class, 'index'])->name('punishments.index');
		Router::get('/punishments/bans', [PunishmentController::class, 'bans'])->name('punishments.bans');
		Router::get('/punishments/mutes', [PunishmentController::class, 'mutes'])->name('punishments.mutes');
		Router::get('/punishments/kicks', [PunishmentController::class, 'kicks'])->name('punishments.kicks');
		Router::get('/punishments/warnings', [PunishmentController::class, 'warnings'])->name('punishments.warnings');
	}
	
	/**
	 * Suggestions
	 */
	if (modules('suggestions')->isActive()) {
		Router::get('/suggestions', [SuggestionController::class, 'index'])->name('suggestions.index');
		
		Router::group(['middleware' => ProtectedRouteMiddleware::class], function () {
			Router::post('/suggestions', [SuggestionController::class, 'store'])->name('suggestions.store');
			Router::get('/suggestions/create', [SuggestionController::class, 'create'])->name('suggestions.create');
			Router::post('/suggestions/{id}/reply', [SuggestionController::class, 'reply'])->name('suggestions.reply');
			Router::post('/suggestions/{id}/reaction', [SuggestionController::class, 'reaction'])->name('suggestions.reaction');
			Router::get('/suggestions/{id}/edit', [SuggestionController::class, 'edit'])->name('suggestions.edit');
			Router::patch('/suggestions/{id}', [SuggestionController::class, 'update'])->name('suggestions.update');
			Router::delete('/suggestions/{id}', [SuggestionController::class, 'destroy'])->name('suggestions.destroy');
			
			Router::get('/suggestions/replies/{id}/edit', [SuggestionReplyController::class, 'edit'])->name('suggestions.replies.edit');
			Router::patch('/suggestions/replies/{id}', [SuggestionReplyController::class, 'update'])->name('suggestions.replies.update');
			Router::delete('/suggestions/replies/{id}', [SuggestionReplyController::class, 'destroy'])->name('suggestions.replies.destroy');
			
			Router::post('/suggestions/upload', [SuggestionController::class, 'upload'])->name('suggestions.upload');
		});
		Router::get('/suggestions/categories/{slug}', [SuggestionCategoryController::class, 'show'])->name('suggestions.categories.show');
		Router::get('/suggestions/{id}/{slug}', [SuggestionController::class, 'show'])->name('suggestions.show');
	}
	
	/**
	 * Misc
	 */
	if (modules('changelog')->isActive()) {
		Router::get('/changelog', [ChangelogController::class, 'index'])->name('changelog.index');
		Router::get('/changelog/{id}', [ChangelogController::class, 'show'])->name('changelog.show');
	}
	
	Router::get('/play', [PlayController::class, 'index'])->name('play');
	if (modules('staff')->isActive()) {
		Router::get('/staff', [StaffController::class, 'index'])->name('staff');
	}
	if (modules('vote')->isActive()) {
		Router::get('/vote', [VoteController::class, 'index'])->name('vote');
	}
	if (modules('page')->isActive()) {
		Router::get('/pages/{slug}', [PageController::class, 'index'])->name('custom-page');
	}
	Router::get('/sitemap.xml', [SitemapController::class, 'index'])->name('sitemap.index');
	Router::get('/sitemaps/sitemap-{index}.xml', [SitemapController::class, 'show'])->name('sitemap.show');
	
	Router::get('/robots.txt', [RobotTxtController::class, 'index'])->name('robots-txt');
	
	/**
	 * Tebex
	 */
	if (modules('tebex_store')->isActive()) {
		Router::get('/store', [TebexStoreController::class, 'index'])->name('store.index');
		Router::get('/store/login', [TebexStoreController::class, 'login'])->name('store.login');
		Router::get('/store/products/{id}', [TebexStoreController::class, 'product'])->name('store.products.show');
		Router::get('/store/{id}', [TebexStoreController::class, 'category'])->name('store.categories.show');
		Router::get('/cart', [TebexStoreController::class, 'cart'])->name('cart.index');
		
		Router::get('/orders/{id}', [TebexStoreController::class, 'order'])->name('orders.show')->addMiddleware(ProtectedRouteMiddleware::class);;
		
		Router::get('/tebex/auth/callback', [TebexStoreController::class, 'authCallback'])->name('tebex.auth.callback');
		Router::post('/tebex/webhook', [TebexWebhookController::class, 'webhook'])->name('tebex.webhook');
	}
	
	/**
	 * Protected routes
	 */
	Router::group(['middleware' => ProtectedRouteMiddleware::class], function () {
		/*
		 * Email Verification
		 */
		if (modules('email_verification')->isActive()) {
			Router::get('/verify-email', [EmailVerificationController::class, 'index'])->name('email.verification.index');
			Router::post('/verify-email/send', [EmailVerificationController::class, 'send'])->name('email.verification.send');
			Router::post('/verify-email/send-again', [EmailVerificationController::class, 'sendAgain'])->name('email.verification.send-again');
			Router::get('/verify-email/{token}', [EmailVerificationController::class, 'verify'])->name('email.verification.verify');
		}
		
		/*
		 * TFA
		 */
		if (modules('tfa')->isActive()) {
			Router::get('/tfa', [TfaController::class, 'index'])->name('tfa.index');
			Router::post('/tfa', [TfaController::class, 'verify'])->name('tfa.verify');
			Router::get('/tfa/setup', [TfaSetupController::class, 'index'])->name('tfa.setup.index');
			Router::post('/tfa/setup', [TfaSetupController::class, 'setup'])->name('tfa.setup.action');
			Router::get('/tfa/recover', [TfaRecoverController::class, 'index'])->name('tfa.recover.index');
			Router::post('/tfa/recover', [TfaRecoverController::class, 'send'])->name('tfa.recover.send');
			Router::get('/tfa/recover/{token}', [TfaRecoverController::class, 'recover'])->name('tfa.recover.action');
		}
		
		/**
		 * Account
		 */
		Router::get('/profile', [AccountController::class, 'profile'])->name('account.profile.index');
		
		if (modules('store')->isActive() && !modules('tebex_store')->isActive()) {
			Router::get('/account/orders', [AccountController::class, 'orders'])->name('account.orders');
			Router::get('/account/subscriptions', [AccountController::class, 'subscriptions'])->name('account.subscriptions');
		}
		if (modules('credit')->isActive()) {
			Router::get('/account/credit-history', [AccountController::class, 'creditHistory'])->name('account.credit-history');
		}
		if (modules('application')->isActive()) {
			Router::get('/account/applications', [AccountController::class, 'applications'])->name('account.applications');
		}
		
		Router::get('/account/settings/profile', [AccountSettingsController::class, 'profile'])->name('account.settings.profile');
		Router::get('/account/settings/security', [AccountSettingsController::class, 'security'])->name('account.settings.security');
		Router::get('/account/settings/linked-accounts', [AccountSettingsController::class, 'linkedAccounts'])->name('account.settings.linked-accounts');
		
		Router::post('/account/settings/profile/upload-avatar', [AccountSettingsController::class, 'uploadAvatar'])->name('account.settings.profile.upload-avatar');
		Router::post('/account/settings/profile/remove-avatar', [AccountSettingsController::class, 'removeAvatar'])->name('account.settings.profile.remove-avatar');
		Router::post('/account/settings/profile/update-details', [AccountSettingsController::class, 'updateDetails'])->name('account.settings.profile.update-details');
		Router::post('/account/settings/security/change-email', [AccountSettingsController::class, 'changeEmail'])->name('account.settings.security.change-email');
		Router::get('/account/settings/security/confirm-email-change/{token}', [AccountSettingsController::class, 'confirmEmailChange'])->name('account.settings.security.confirm-email-change');
		Router::post('/account/settings/security/change-password', [AccountSettingsController::class, 'changePassword'])->name('account.settings.security.change-password');
		if (modules('tfa')->isActive()) {
			Router::post('/account/settings/security/toggle-tfa', [AccountSettingsController::class, 'toggleTfa'])->name('account.settings.security.toggle-tfa');
		}
		
		Router::get('/account/contact', [AccountContactController::class, 'edit'])->name('account.contact.edit');
		Router::patch('/account/contact', [AccountContactController::class, 'update'])->name('account.contact.update');
		
		/**
		 * Chest
		 */
		if (modules('chest')->isActive()) {
			Router::get('/chest', [ChestController::class, 'index'])->name('chest.index');
			Router::get('/chest/logs', [ChestController::class, 'logs'])->name('chest.logs');
			Router::post('/chest/{id}/deliver', [ChestController::class, 'deliver'])->name('chest.deliver');
			Router::get('/chest/{id}/gift', [ChestGiftController::class, 'index'])->name('chest.gift.index');
			Router::post('/chest/{id}/gift', [ChestGiftController::class, 'send'])->name('chest.gift.send');
		}
		
		/**
		 * Gift
		 */
		if (modules('gift')->isActive()) {
			Router::get('/gifts', [GiftController::class, 'index'])->name('gifts.index');
			Router::post('/gifts', [GiftController::class, 'check'])->name('gifts.check');
			Router::get('/gifts/logs', [GiftController::class, 'logs'])->name('gifts.logs');
			Router::get('/gifts/{id}', [GiftController::class, 'show'])->name('gifts.show');
			Router::post('/gifts/{id}/use', [GiftController::class, 'use'])->name('gifts.use');
		}
		
		/**
		 * Cart
		 */
		if (modules('store')->isActive() && !modules('tebex_store')->isActive()) {
			Router::get('/cart', [CartController::class, 'index'])->name('cart.index');
			Router::post('/cart/pay', [CartController::class, 'pay'])->name('cart.pay');
			Router::get('/cart/featured-products', [CartController::class, 'featuredProducts'])->name('cart.featured-products');
			Router::get('/cart/items', [CartController::class, 'items'])->name('cart.items.index');
			Router::match(['get', 'post'], '/cart/items/add', [CartController::class, 'addItem'])->name('cart.items.add');
			Router::post('/cart/items/update-quantity', [CartController::class, 'updateItemQuantity'])->name('cart.items.update-quantity');
			Router::post('/cart/items/delete', [CartController::class, 'deleteItem'])->name('cart.items.delete');
			Router::post('/cart/coupons/apply', [CartController::class, 'applyCoupon'])->name('cart.coupons.apply');
			Router::post('/cart/coupons/remove', [CartController::class, 'removeCoupon'])->name('cart.coupons.remove');
			Router::post('/cart/creator-codes/apply', [CartController::class, 'applyCreatorCode'])->name('cart.creator-codes.apply');
			Router::post('/cart/creator-codes/remove', [CartController::class, 'removeCreatorCode'])->name('cart.creator-codes.remove');
		}
		
		/**
		 * Orders
		 */
		if (modules('store')->isActive() && !modules('tebex_store')->isActive()) {
			Router::get('/orders/{id}', [OrderController::class, 'show'])->name('orders.show');
		}
		
		/**
		 * Support
		 */
		if (modules('support')->isActive()) {
			Router::get('/support/tickets', [SupportTicketController::class, 'index'])->name('support.tickets.index');
			Router::get('/support/tickets/submit', [SupportTicketController::class, 'create'])->name('support.tickets.create');
			Router::post('/support/tickets', [SupportTicketController::class, 'store'])->name('support.tickets.store');
			Router::get('/support/tickets/{id}', [SupportTicketController::class, 'show'])->name('support.tickets.show');
			//Router::delete('/support/tickets/{id}', [SupportTicketController::class, 'destroy'])->name('support.tickets.destroy');
			Router::post('/support/tickets/{id}/close', [SupportTicketController::class, 'close'])->name('support.tickets.close');
			Router::post('/support/tickets/{id}/reply', [SupportTicketController::class, 'reply'])->name('support.tickets.reply');
			Router::post('/support/tickets/upload', [SupportTicketController::class, 'upload'])->name('support.tickets.upload');
		}
		
		if (modules('ai')->isActive()) {
			Router::post('/ai/reply-ticket/{id}', [AiController::class, 'replyTicket'])->name('ai.replyTicket');
		}
		
		/**
		 * Applications
		 */
		if (modules('application')->isActive()) {
			Router::get('/applications/{id}', [ApplicationController::class, 'show'])->name('applications.show');
			Router::get('/applications/forms/{slug}', [ApplicationFormController::class, 'show'])->name('applications.forms.show');
			Router::post('/applications/forms/{id}/apply', [ApplicationFormController::class, 'apply'])->name('applications.forms.apply');
		}
		
		/**
		 * Form
		 */
		if (modules('form')->isActive()) {
			Router::get('/forms/{slug}', [CustomFormController::class, 'show'])->name('forms.show');
			Router::post('/forms/{id}/submit', [CustomFormController::class, 'submit'])->name('forms.submit');
			Router::get('/forms/answers/{id}', [CustomFormAnswerController::class, 'show'])->name('forms.answers.show');
		}
		
		/**
		 * Fortune Wheel
		 */
		if (modules('lottery')->isActive()) {
			Router::get('/fortune-wheel', [FortuneWheelController::class, 'index'])->name('fortune-wheel.index');
			Router::get('/fortune-wheel/logs', [FortuneWheelController::class, 'logs'])->name('fortune-wheel.logs');
			Router::get('/fortune-wheel/{slug}', [FortuneWheelController::class, 'show'])->name('fortune-wheel.show');
			Router::post('/fortune-wheel/{id}/spin', [FortuneWheelController::class, 'spin'])->name('fortune-wheel.spin');
		}
		
		/**
		 * Bazaar
		 */
		if (modules('bazaar')->isActive()) {
			Router::get('/bazaar', [BazaarController::class, 'index'])->name('bazaar.index');
			Router::get('/bazaar/logs', [BazaarController::class, 'logs'])->name('bazaar.logs');
			Router::get('/bazaar/help', [BazaarController::class, 'help'])->name('bazaar.help');
			Router::get('/bazaar/servers/{slug}', [BazaarServerController::class, 'show'])->name('bazaar.servers.show');
			Router::get('/bazaar/products/{id}', [BazaarProductController::class, 'show'])->name('bazaar.products.show');
			Router::post('/bazaar/products/{id}/buy', [BazaarProductController::class, 'buy'])->name('bazaar.products.buy');
			Router::get('/bazaar/manage', [BazaarManagementController::class, 'index'])->name('bazaar.manage.index');
			Router::get('/bazaar/manage/{id}', [BazaarManagementController::class, 'edit'])->name('bazaar.manage.edit');
			Router::post('/bazaar/manage/{id}/sell', [BazaarManagementController::class, 'sell'])->name('bazaar.manage.sell');
			Router::post('/bazaar/manage/{id}/remove', [BazaarManagementController::class, 'remove'])->name('bazaar.manage.remove');
		}
	});
	
	// Custom Routes
	if (file_exists(__DIR__ . '/custom-routes.php')) {
		require __DIR__ . '/custom-routes.php';
	}
	
	// Custom Theme Routes
	if (file_exists(theme()->realPath() . '/routes.php')) {
		require theme()->realPath() . '/routes.php';
	}
	
	if (modules('page')->isActive()) {
		Router::get('/{slug}', [PageController::class, 'index'])->name('pages.show');
	}
	