<?php

namespace Main\Controllers;

use Curl\Curl;
use Main\Core\Controller;
use PDO;

class AiController extends Controller
{
    public function replyTicket($id)
    {
	    if (modules('ai')->settings('autoReply') == '0') abort_404();
	    
			global $lang;
	    
	    $ticket = db()->prepare("SELECT S.*, A.username, A.realname, SC.name as categoryName FROM Supports S INNER JOIN Accounts A ON S.accountID = A.id INNER JOIN SupportCategories SC ON S.categoryID = SC.id WHERE S.id = ? AND S.accountID = ? AND S.statusID = ?");
	    $ticket->execute(array($id, auth()->user()->id(), 1));
	    $ticket = $ticket->fetch();
	    
	    if (!$ticket) {
		    response()->json([
			    'status' => false,
		    ]);
	    }
	    
	    $aiMessage = db()->prepare("SELECT id, message FROM SupportMessages WHERE supportID = ? AND accountID = ? AND writeLocation = ?");
	    $aiMessage->execute(array($id, 0, 2));
	    $aiMessage = $aiMessage->fetch();
	    
	    if (!$aiMessage) {
		    response()->json([
			    'status' => false,
		    ]);
	    }
	    
	    if ($aiMessage["message"] === "...") {
		    response()->json([
			    'status' => false,
		    ]);
	    }
	    
	    $userMessage = db()->prepare("SELECT message FROM SupportMessages WHERE supportID = ? ORDER BY creationDate ASC LIMIT 1");
	    $userMessage->execute(array($id));
	    $userMessage = $userMessage->fetch();
	    
	    if (!$userMessage) {
		    response()->json([
			    'status' => false,
		    ]);
	    }
	    
			// Update the AI message to prevent page refresh issues
	    $updateAiMessage = db()->prepare("UPDATE SupportMessages SET message = ? WHERE id = ?");
	    $updateAiMessage->execute(array("...", $aiMessage["id"]));
			
			// Get ticket details for sending to AI
			$title = $ticket['title'];
			$categoryName = $ticket['categoryName'];
			$message = $userMessage['message'];
	    
	    $customFields = db()->prepare("SELECT CSFV.value, CSV.field FROM CustomSupportFieldValues CSFV INNER JOIN CustomSupportFields CSV ON CSV.id = CSFV.fieldID WHERE CSFV.supportID = ?");
	    $customFields->execute(array($id));
	    $customFields = $customFields->fetchAll(PDO::FETCH_ASSOC);
			
			// Default: "Answered"
			$supportStatusID = 2;
			
	    // Send request to LeaderOS AI API
	    $curl = new Curl();
	    $curl->setHeader('Content-Type', 'application/json');
	    $curl->setHeader('Accept', 'application/json');
	    $curl->setHeader('X-Api-Key', settings('apiKey'));
	    $curl->post("https://ai-service-api.leaderos.net/reply-ticket", [
				"language" => $lang,
				"game" => settings('gameType'),
				"serverName" => settings('serverName'),
		    "title" => $title,
		    "category" => $categoryName,
		    "message" => $message,
		    "fields" => $customFields,
	    ]);
			if (!$curl->error && isset($curl->response->status) && $curl->response->status === true) {
				$aiMessageContent = $curl->response->message;
			} else if (!$curl->error && isset($curl->response->error)) {
		    $aiMessageContent = $curl->response->error;
	    } else {
				// Set status to "Open"
				$supportStatusID = 1;
		    $aiMessageContent = t__("Unfortunately, I don’t have detailed information on this matter. I’ve forwarded your ticket to our support team, who will be able to assist you further.");
			}
			
			if ($aiMessageContent === 'LIMIT_REACHED') {
				$aiMessageContent = t__('Sorry, the AI service usage limit has been reached and we are unable to provide an AI response at this time.');
			}
			if ($aiMessageContent === 'NO_ACTIVE_SUBSCRIPTION') {
				$aiMessageContent = t__('Sorry, there is no active AI subscription for this website.');
			}
	    
	    $updateTicket = db()->prepare("UPDATE Supports SET updateDate = ?, statusID = ? WHERE id = ?");
	    $updateTicket->execute(array(datetime(), $supportStatusID, $id));
	    
			// Update the AI message in the database
	    $updateAiMessage->execute(array($aiMessageContent, $aiMessage["id"]));
	    
	    response()->json([
		    'status' => true,
		    'message' => $aiMessageContent,
	    ]);
    }
}