<?php

namespace Main\Controllers\Application;

use Main\Core\Controller;
use Main\Services\SeoService;

class ApplicationController extends Controller
{
		protected string $route_type = 'application';
		
    public function show($id)
    {
        $application = db()->prepare("SELECT AP.*, A.username, A.realname, AF.title FROM Applications AP INNER JOIN Accounts A ON A.id = AP.accountID INNER JOIN ApplicationForms AF ON AP.formID = AF.id WHERE AP.id = ? AND AP.accountID = ?");
        $application->execute(array($id, auth()->user()->id()));
        $application = $application->fetch();

        if (!$application) abort_404();
	      
				SeoService::set('applications.show', [
					'form_title' => $application['title'],
				]);

        $answers = db()->prepare("SELECT GROUP_CONCAT(AA.answer) as answer, AFQ.question FROM ApplicationAnswers AA INNER JOIN ApplicationFormQuestions AFQ ON AFQ.id = AA.questionID WHERE AA.applicationID = ? GROUP BY AFQ.id");
        $answers->execute(array($application["id"]));
		    $application["answers"] = $answers->fetchAll();

        return $this->view('applications.show', compact('application'));
    }
}