<?php
	
	namespace Main\Controllers\Auth;
	
	use Main\Core\Controller;
	use Main\Core\Redirect;
	
	class EmailController extends Controller
	{
		protected string $route_type = 'email';
		
		public function __construct()
		{
			if (auth()->user()->email() != null && auth()->user()->email() != "" && auth()->user()->email() != "your@email.com") abort_404();
		}
		
		public function index()
		{
			return $this->view('auth.email');
		}
		
		public function setEmail()
		{
			$email = sanitize(input('email'));
			
			if (!is_email($email)) {
				return back()->flash('error', t__('Please enter a valid email address!'));
			}
			
			$emailValid = db()->prepare("SELECT COUNT(id) FROM Accounts WHERE email = ? LIMIT 1");
			$emailValid->execute(array($email));
			$emailCount = $emailValid->fetchColumn();
			if ($emailCount > 0) {
				return back()->flash('error', t__('<strong>%email%</strong> already registered!', ['%email%' => $email]));
			}
			
			$update = db()->prepare("UPDATE Accounts SET email = ? WHERE id = ?");
			$update->execute(array($email, auth()->user()->id()));
			
			// Redirect to the profile page
			$redirect = new Redirect(url('account.profile.index'));
			return $redirect->flash('success', t__('Your email has been changed!'));
		}
	}