<?php

namespace Main\Controllers\Auth;

use Main\Core\Controller;
use Main\Core\Jobs\JobDispatcher;
use Main\Jobs\SendEmail;
use Main\Services\SeoService;
use PHPMailer\PHPMailer\Exception;

class ForgotPasswordController extends Controller
{
		protected string $route_type = 'forgot-password';
	
		public function __construct()
		{
			if (settings('loginProvider') != 'default') abort_404();
			
			if (auth()->check()) {
				redirect(url('account.profile.index'));
			}
		}
	
    public function index()
    {
	      SeoService::set('auth.forgot-password');

        return $this->view('auth.forgot-password');
    }

    public function forgotPassword()
    {
        validate([
            'email' => 'required|email',
            'username' => 'required'
        ]);
	    
		    if (recaptcha()->isEnabled('forgot_password') && !recaptcha()->verify()) {
			    return back()->flash('error', t__('Spam detected!'));
		    }

        $account = db()->prepare("SELECT * FROM Accounts WHERE realname = ? AND email = ?");
		    $account->execute(array(input("username"), input("email")));
		    $account = $account->fetch();
				
				if (!$account) {
					return back()->flash('error', t__('Username and email address do not match!'));
				}
	    
		    try {
			    $resetRequest = db()->prepare("SELECT * FROM AccountPasswordResetTokens WHERE accountID = ? AND expiryDate > ?");
			    $resetRequest->execute(array($account["id"], datetime()));
			    $resetRequest = $resetRequest->fetch();
			    
			    if ($resetRequest) {
				    // Last try is less than 2 min ago
				    if ($resetRequest["lastSend"] > date('Y-m-d H:i:s', strtotime('-2 minutes'))) {
					    return back()->flash('error', t__('Please wait a few minutes before trying again.'));
				    }
				    $token = $resetRequest['token'];
				    $updateAccountPasswordResetTokens = db()->prepare("UPDATE AccountPasswordResetTokens SET lastSend = ? WHERE id = ?");
				    $updateAccountPasswordResetTokens->execute(array(datetime(), $resetRequest['id']));
			    } else {
				    $token = rand_token();
				    $insertAccountPasswordResetTokens = db()->prepare("INSERT INTO AccountPasswordResetTokens (accountID, token, creationIP, expiryDate, lastSend, creationDate) VALUES (?, ?, ?, ?, ?, ?)");
				    $insertAccountPasswordResetTokens->execute(array($account["id"], $token, getIP(), createDuration(0.04166666666), datetime(), datetime()));
			    }
			    
			    $url = website_url(url('auth.reset-password', ['token' => $token]));
			    $search = array("%username%", "%url%");
			    $replace = array($account["realname"], $url);
			    $template = settings("smtpPasswordTemplate");
			    $content = str_replace($search, $replace, $template);
			    JobDispatcher::dispatch((new SendEmail($account["email"], settings("smtpPasswordTitle"), $content)));
			    
			    return back()->flash('success', t__('A reset link has been sent to your email address!'));
		    } catch (Exception $e) {
			    return back()->flash('error', t__('Could not send mail due to a system error:')." ".$e->errorMessage());
		    }
    }
}