<?php

namespace Main\Controllers\Auth;

use Main\Core\Controller;
use Main\Services\PasswordService;
use Main\Services\SeoService;

class RegisterController extends Controller
{
		protected string $route_type = 'register';
		
		public function __construct()
		{
			if (auth()->check()) {
				redirect(url('account.profile.index'));
			}
			
			if (settings('loginProvider') != 'default') {
				redirect(url('auth.login'));
			}
			
			if (settings("registrationStatus") == 0 && !input("token")) abort_404();
		}
	
    public function index()
    {
	      SeoService::set('auth.register');
				
        return $this->view('auth.register');
    }

    public function register()
    {
        validate([
            'username' => 'required',
            'email' => 'required',
            'password' => 'required|min:4',
            'passwordRe' => 'required'
        ]);
	    
		    if (recaptcha()->isEnabled('register') && !recaptcha()->verify()) {
			    return back()->flash('error', t__('Spam detected!'));
		    }

        $username = sanitize(input("username"));
		    $email = input("email");
	    
		    if (!validate_username($username)) {
			    return back()->flash('error', t__('Username is not valid!'));
		    }
		    
		    if (!is_email($email)) {
			    return back()->flash('error', t__('Please enter a valid email address!'));
		    }
	    
		    if (!validate_password(input("password"))) {
			    return back()->flash('error', t__('Your password is too weak!'));
		    }
				
				if (input("password") != input("passwordRe")) {
					return back()->flash('error', t__('Passwords do not match!'));
				}

        $usernameValid = db()->prepare("SELECT COUNT(id) FROM Accounts WHERE username = ?");
        $usernameValid->execute(array($username));
        $usernameCount = $usernameValid->fetchColumn();
		    if ($usernameCount > 0) {
			    return back()->flash('error', t__('<strong>%username%</strong> already registered!', ['%username%' => $username]));
		    }

        $emailValid = db()->prepare("SELECT COUNT(id) FROM Accounts WHERE email = ? LIMIT 1");
        $emailValid->execute(array($email));
        $emailCount = $emailValid->fetchColumn();
		    if ($emailCount > 0) {
			    return back()->flash('error', t__('<strong>%email%</strong> already registered!', ['%email%' => $email]));
		    }

				if (settings("registerLimit") != "-1") {
					$ipCount = db()->prepare("SELECT COUNT(id) FROM Accounts WHERE creationIP = ?");
					$ipCount->execute(array(getIP()));
					$ipCount = $ipCount->fetchColumn();
					
					if ($ipCount >= (int)settings("registerLimit")) {
						return back()->flash('error', t__('You have reached the limit of registrations!'));
					}
				}
				
        $loginToken = rand_token();
        $password = PasswordService::hash(input("password"));

        $insertAccounts = db()->prepare("INSERT INTO Accounts (uuid, username, realname, email, password, isVerified, creationIP, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $insertAccounts->execute(array(null, strtolower($username), $username, $email, $password, (modules("email_verification")->isActive() ? "0" : "1"), getIP(), datetime()));
        $accountID = db()->lastInsertId();
        $insertAccountSessions = db()->prepare("INSERT INTO AccountSessions (accountID, loginToken, useragent, creationIP, expiryDate, creationDate) VALUES (?, ?, ?, ?, ?, ?)");
        $insertAccountSessions->execute(array($accountID, $loginToken, $_SERVER['HTTP_USER_AGENT'], getIP(), createDuration(0.01666666666), datetime()));
        session()->set('login', $loginToken);

        redirect(url('account.profile.index'));
    }
}