<?php

namespace Main\Controllers\Auth;

use Main\Core\Controller;
use Main\Services\PasswordService;
use Main\Services\SeoService;

class ResetPasswordController extends Controller
{
		protected string $route_type = 'reset-password';
	
		public function __construct()
		{
			if (settings('loginProvider') != 'default') abort_404();
			
			if (auth()->check()) {
				redirect(url('account.profile.index'));
			}
		}
		
    public function index($token)
    {
	      SeoService::set('auth.reset-password');

        $resetRequest = db()->prepare("SELECT * FROM AccountPasswordResetTokens WHERE token = ? AND expiryDate > ?");
		    $resetRequest->execute(array($token, datetime()));
		    $resetRequest = $resetRequest->fetch();

        if (!$resetRequest) abort_404();

        return $this->view('auth.reset-password');
    }

    public function resetPassword($token)
    {
        validate([
            'password' => 'required|min:4',
            'passwordRe' => 'required|same:password'
        ]);

        if (!validate_password(input("password"))) {
            return back()->flash('error', t__('Your password is too weak!'));
        }
	    
		    $resetRequest = db()->prepare("SELECT * FROM AccountPasswordResetTokens WHERE token = ? AND expiryDate > ?");
		    $resetRequest->execute(array($token, datetime()));
		    $resetRequest = $resetRequest->fetch();

        if (!$resetRequest) abort_404();
	    
				$expireToken = db()->prepare("UPDATE AccountPasswordResetTokens SET expiryDate = ? WHERE id = ?");
		    $expireToken->execute(array(datetime(), $resetRequest["id"]));
				
		    $password = PasswordService::hash(input("password"));
        $updateAccounts = db()->prepare("UPDATE Accounts SET password = ? WHERE id = ?");
        $updateAccounts->execute(array($password, $resetRequest["accountID"]));
				
        $deleteAccountSessions = db()->prepare("DELETE FROM AccountSessions WHERE accountID = ?");
        $deleteAccountSessions->execute(array($resetRequest["accountID"]));

        redirect(url('auth.login'));
    }
}