<?php

namespace Main\Controllers\Bazaar;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;
use Spirit55555\Minecraft\MinecraftColors;

class BazaarController extends Controller
{
		protected string $route_type = 'bazaar';
		
    public function index()
    {
	      SeoService::set('bazaar.index');
				
        $servers = db()->prepare("SELECT * FROM BazaarServers WHERE isActive = ? ORDER BY priority DESC");
        $servers->execute(array(1));
        $servers = array_map(function ($server) {
					$server['image'] = '/assets/core/images/bazaar/'.$server['imageID'].'.'.$server['imageType'];
					
					return $server;
        }, $servers->fetchAll());

        return $this->view('bazaar.index', compact('servers'));
    }

    public function help()
    {
		    SeoService::set('bazaar.help');

        return $this->view('bazaar.help');
    }
	
		public function logs()
		{
			SeoService::set('bazaar.logs');
			
			$logs = db()->prepare("SELECT BH.*, BI.name as itemName, BI.price as itemPrice FROM BazaarHistory BH INNER JOIN BazaarItems BI ON BH.itemID = BI.id WHERE BH.accountID = ? ORDER BY BH.id DESC LIMIT 50");
			$logs->execute(array(auth()->user()->id()));
			$logs = array_map(function($log) {
				$log['coleredName'] = MinecraftColors::convertToHTML($log["itemName"]);
				return $log;
			}, $logs->fetchAll());
			
			return $this->view('bazaar.logs', compact('logs'));
		}
}