<?php

namespace Main\Controllers\Bazaar;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;
use Spirit55555\Minecraft\MinecraftColors;

class ManagementController extends Controller
{
		protected string $route_type = 'bazaar';
	
    public function index()
    {
	      SeoService::set('bazaar.manage.index');
				
        $items = db()->prepare("SELECT BI.*, S.name as serverName FROM BazaarItems BI INNER JOIN BazaarServers S ON S.id = BI.serverID WHERE BI.owner = ? AND S.isActive = ? ORDER BY BI.id DESC");
        $items->execute(array(auth()->user()->id(), 1));
        $items = array_map(function ($item) {
					$item["coloredName"] = MinecraftColors::convertToHTML($item["name"]);
					
					return $item;
        }, $items->fetchAll(PDO::FETCH_ASSOC));

        $logs = db()->prepare("SELECT BH.*, BI.name as itemName, BI.price as itemPrice FROM BazaarHistory BH INNER JOIN BazaarItems BI ON BH.itemID = BI.id WHERE BH.accountID = ? ORDER BY BH.id DESC LIMIT 5");
		    $logs->execute(array(auth()->user()->id()));
		    $logs = array_map(function ($log) {
					$log["coloredItemName"] = MinecraftColors::convertToHTML($log["itemName"]);
					
					return $log;
		    }, $logs->fetchAll(PDO::FETCH_ASSOC));

        return $this->view('bazaar.manage.index', compact('items', 'logs'));
    }

    public function edit($id)
    {
        $item = db()->prepare("SELECT BI.*, S.name as serverName FROM BazaarItems BI INNER JOIN BazaarServers S ON S.id = BI.serverID WHERE BI.owner = ? AND BI.sold = ? AND S.isActive = ? AND BI.id = ?");
        $item->execute(array(auth()->user()->id(), 0, 1, $id));
        $item = $item->fetch();

        if (!$item) abort_404();
	    
	      SeoService::set('bazaar.manage.edit', [
					'product_name' => MinecraftColors::clean($item["name"])
	      ]);
	    
	      $item["coloredName"] = MinecraftColors::convertToHTML($item["name"]);
	      $item["coloredLore"] = $item["lore"] ? MinecraftColors::convertToHTML($item["lore"], true) : null;
				$item["durability"] = (min($item["durability"], $item["maxDurability"]))."/".$item["maxDurability"];
	    
		    $image = '/assets/core/images/items/' . strtolower($item["itemID"]) . '.png';
		    if ($item["modelID"] != null) {
			    $image = '/assets/core/images/items/custom/' . $item["imageID"] . '.' . $item["imageType"];
		    }
		    $item["image"] = $image;
			
        $enchantments = array();
        if ($item["enchantments"] != null) {
	        foreach (explode(",", $item["enchantments"]) as $enchantment) {
		        $parts = explode(":", $enchantment);
		        $enchantments[] = array(
			        'enchantment' => $parts[0],
			        'lvl' => intval($parts[1])
		        );
	        }
				}
        $item["enchantments"] = $enchantments;

        return $this->view('bazaar.manage.edit', compact('item'));
    }

    public function sell($id)
    {
        $item = db()->prepare("SELECT BI.*, S.name as serverName FROM BazaarItems BI INNER JOIN BazaarServers S ON S.id = BI.serverID WHERE BI.owner = ? AND BI.sold = ? AND S.isActive = ? AND BI.id = ?");
        $item->execute(array(auth()->user()->id(), 0, 1, $id));
        $item = $item->fetch();

        if (!$item) abort_404();

        validate([
            'price' => 'required|numeric|min:1',
            'description' => 'nullable'
        ]);
				
        $oldPrice = $item["price"];
				$price = sanitize(input("price"));
				$description = sanitize(input("description"));
				
        $updateItem = db()->prepare("UPDATE BazaarItems SET price = ?, description = ? WHERE owner = ? AND id = ?");
        $updateItem->execute(array($price, $description, auth()->user()->id(), $item["id"]));
        if ($oldPrice == 0) {
            return back()->flash('success', t__('Item has been listed for sale successfully!'));
        } else {
            return back()->flash('success', t__('Your item has been successfully updated!'));
        }
    }

    public function remove($id)
    {
        $item = db()->prepare("SELECT BI.*, S.name as serverName FROM BazaarItems BI INNER JOIN BazaarServers S ON S.id = BI.serverID WHERE BI.owner = ? AND BI.sold = ? AND S.isActive = ? AND BI.id = ?");
        $item->execute(array(auth()->user()->id(), 0, 1, $id));
        $item = $item->fetch();

        if (!$item) abort_404();
				
        $updateItem = db()->prepare("UPDATE BazaarItems SET price = ? WHERE id = ?");
        $updateItem->execute(array(0, $item["id"]));

        return back()->flash('success', t__('The item has been removed from the bazaar. You can get the item back with the /webbazaar command.'));
    }
}