<?php

namespace Main\Controllers\Bazaar;

use Main\Core\Controller;
use Main\Core\Redirect;
use Main\Services\SeoService;
use PDO;
use Spirit55555\Minecraft\MinecraftColors;

class ProductController extends Controller
{
		protected string $route_type = 'bazaar';
		
    public function show($id)
    {
        $product = db()->prepare("SELECT BI.*, A.username, A.realname FROM BazaarItems BI INNER JOIN Accounts A ON BI.owner = A.id WHERE BI.id = ? AND BI.price > ? AND BI.sold = ?");
        $product->execute(array($id, 0, 0));
        $product = $product->fetch();

        if (!$product) abort_404();
				
				$server = db()->prepare("SELECT * FROM BazaarServers WHERE id = ? AND isActive = ?");
				$server->execute(array($product["serverID"], 1));
				$server = $server->fetch();
				
				if (!$server) abort_404();
				
				$product["server"] = $server;
	    
	      SeoService::set('bazaar.products.show', [
					'product_name' => MinecraftColors::clean($product["name"]),
	      ]);
	    
				// Set the image of the product
		    $product["image"] = '/assets/core/images/items/'.strtolower($product["itemID"]).'.png';
		    if ($product["modelID"] != null && $product["modelID"] != "") {
			    $customImage = db()->prepare("SELECT imageID, imageType FROM BazaarCustomItemImages WHERE serverID = ? AND itemID = ? AND modelID = ?");
			    $customImage->execute(array($product["serverID"], $product["itemID"], $product["modelID"]));
			    $customImage = $customImage->fetch();
			    if ($customImage) {
				    $product["image"] = '/assets/core/images/items/custom/' . $customImage["imageID"] . '.' . $customImage["imageType"];
			    }
		    }

	      $product["coloredName"] = MinecraftColors::convertToHTML($product["name"]);
				$product["name"] = MinecraftColors::clean($product["name"]);
		    $product["coloredLore"] = $product["lore"] ? MinecraftColors::convertToHTML($product["lore"], true) : null;
		    $product["durability"] = (min($product["durability"], $product["maxDurability"]))."/".$product["maxDurability"];
		    
		    $enchantments = array();
		    foreach (explode(",", $product["enchantments"]) as $enchantment) {
			    $parts = explode(":", $enchantment);
			    $enchantments[] = array(
				    'enchantment' => $parts[0],
				    'lvl' => intval($parts[1])
			    );
		    }
		    $product["enchantments"] = $enchantments;
	    
		    if (request()->isAjax() || request()->isFormatAccepted('json')) {
			    response()->json([
				    'status' => true,
				    'html' => template()->render('modals/bazaar-product', compact('product'))
			    ]);
		    }

        return $this->view('bazaar.product', compact('product'));
    }

    public function buy($id)
    {
        $product = db()->prepare("SELECT * FROM BazaarItems WHERE id = ? AND price > ? AND sold = ?");
        $product->execute(array($id, 0, 0));
        $product = $product->fetch();

        if (!$product) abort_404();

        if ($product["owner"] != auth()->user()->id()) {
            $productPrice = $product["price"];

            if (auth()->user()->data("credit") >= $productPrice) {
                $insertBazaarHistory = db()->prepare("INSERT INTO BazaarHistory (itemID, accountID, type, creationDate) VALUES (?, ?, ?, ?)");
                $insertBazaarHistory->execute(array($product["id"], auth()->user()->id(), 0, datetime()));
                $insertBazaarHistory->execute(array($product["id"], $product["owner"], 1, datetime()));

                $insertCreditHistory = db()->prepare("INSERT INTO CreditHistory (accountID, type, price, creationDate) VALUES (?, ?, ?, ?)");
                $insertCreditHistory->execute(array(auth()->user()->id(), 7, $productPrice, datetime()));
                $insertCreditHistory->execute(array($product["owner"], 8, $productPrice, datetime()));

                $updateCredit = db()->prepare("UPDATE Accounts SET credit = credit - ? WHERE id = ?");
                $updateCredit->execute(array($productPrice, auth()->user()->id()));


                $creditForSeller = $productPrice;
                if (modules('bazaar')->settings('commission') > 0) {
                    $creditForSeller = $productPrice - ($productPrice * modules('bazaar')->settings('commission') / 100);
                }
                $updateCredit = db()->prepare("UPDATE Accounts SET credit = credit + ? WHERE id = ?");
                $updateCredit->execute(array($creditForSeller, $product["owner"]));

                $updateProduct = db()->prepare("UPDATE BazaarItems SET sold = ? WHERE id = ?");
                $updateProduct->execute(array(1, $product["id"]));

                $insertProduct = db()->prepare("INSERT INTO BazaarItems (owner, serverID, itemID, name, lore, amount, durability, maxDurability, enchantments, base64, price, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $insertProduct->execute(array(auth()->user()->id(), $product["serverID"], $product["itemID"], $product["name"], $product["lore"], $product["amount"], $product["durability"], $product["maxDurability"], $product["enchantments"], $product["base64"], 0, datetime()));

								$redirect = new Redirect(url('bazaar.manage.index'));
                return $redirect->flash('success', t__('You have successfully bought the item!'));
            } else {
                return back()->flash('error', t__('You do not have enough credits!'));
            }
        } else {
            return back()->flash('error', t__('You cannot buy your own item!'));
        }
    }
}