<?php

namespace Main\Controllers\Bazaar;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;
use Spirit55555\Minecraft\MinecraftColors;

class ServerController extends Controller
{
		protected string $route_type = 'bazaar';
		
    public function show($slug)
    {
        $server = db()->prepare("SELECT * FROM BazaarServers WHERE slug = ? AND isActive = ?");
		    $server->execute(array($slug, 1));
		    $server = $server->fetch();
				
				if (!$server) abort_404();
	    
		    SeoService::set('bazaar.servers.show', [
					'server_name' => $server["name"],
		    ]);
	    
		    $servers = db()->prepare("SELECT * FROM BazaarServers WHERE isActive = ? ORDER BY priority DESC");
		    $servers->execute(array(1));
	    
		    if (isset($_GET["page"])) {
			    if (!is_numeric($_GET["page"])) {
				    $_GET["page"] = 1;
			    }
			    $page = intval($_GET["page"]);
		    } else {
			    $page = 1;
		    }
		    $productLimit = 20;
		    $itemsCount = db()->prepare("SELECT count(id) from BazaarItems WHERE serverID = ? AND price > ? AND sold = ?");
		    $itemsCount->execute(array($server["id"], 0, 0));
		    $itemsCount = $itemsCount->fetchColumn();
		    $pageCount = ceil($itemsCount / $productLimit);
		    if ($page > $pageCount) {
			    $page = 1;
		    }
		    $visibleItemsCount = $page * $productLimit - $productLimit;
		    $visiblePageCount = 5;
		    
		    $products = db()->prepare("SELECT BI.* FROM BazaarItems BI WHERE BI.serverID = ? AND BI.price > ? AND BI.sold = ? ORDER BY BI.id DESC LIMIT $visibleItemsCount, $productLimit");
		    $products->execute(array($server["id"], 0, 0));
		    $products = array_map(function ($product) {
			    $product["image"] = '/assets/core/images/items/'.strtolower($product["itemID"]).'.png';
			    if ($product["modelID"] != null && $product["modelID"] != "") {
						$customImage = db()->prepare("SELECT imageID, imageType FROM BazaarCustomItemImages WHERE serverID = ? AND itemID = ? AND modelID = ?");
						$customImage->execute(array($product["serverID"], $product["itemID"], $product["modelID"]));
						$customImage = $customImage->fetch();
						if ($customImage) {
				      $product["image"] = '/assets/core/images/items/custom/'.$customImage["imageID"].'.'.$customImage["imageType"];
						}
			    }
					
			    $product["coloredName"] = MinecraftColors::convertToHTML($product["name"]);
			    
			    return $product;
		    }, $products->fetchAll());

        return $this->view('bazaar.server', compact('servers', 'server', 'products', 'page', 'pageCount', 'visiblePageCount'));
    }
}