<?php

namespace Main\Controllers\Blog;

use Main\Core\Controller;
use Main\Services\AvatarService;
use Main\Services\SeoService;
use PDO;

class PostController extends Controller
{
		protected string $route_type = 'blog';
		
    public function index()
    {
	      SeoService::set('blog.index');
	    
		    if (auth()->check() && auth()->user()->can('MANAGE_BLOG')) {
			    $accessibleStatuses = ['draft', 'published'];
		    } else {
			    $accessibleStatuses = ['published'];
		    }
		    $accessibleStatuses = implode(", ", array_map(function($status) {
			    return "'$status'";
		    }, $accessibleStatuses));
			
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval($_GET["page"]);
        } else {
            $page = 1;
        }
	    
	      $newsLimit = 6;

        $itemsCount = db()->prepare("SELECT count(N.id) from News N INNER JOIN NewsCategories NC ON N.categoryID = NC.id INNER JOIN Accounts A ON N.accountID = A.id WHERE N.status IN ($accessibleStatuses)");
				$itemsCount->execute();
        $itemsCount = $itemsCount->fetchColumn();

        $pageCount = ceil($itemsCount / $newsLimit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $newsLimit - $newsLimit;
        $visiblePageCount = 5;

        $posts = db()->prepare("SELECT N.*, NC.name as categoryName, NC.slug as categorySlug, A.username, A.realname from News N INNER JOIN NewsCategories NC ON N.categoryID = NC.id INNER JOIN Accounts A ON N.accountID = A.id WHERE N.status IN ($accessibleStatuses) ORDER BY N.id DESC LIMIT $visibleItemsCount, $newsLimit");
				$posts->execute();
				$posts = $posts->fetchAll(PDO::FETCH_ASSOC);
		    $posts = array_map(function($post) {
			    $newsCount = db()->prepare("SELECT COUNT(id) FROM NewsComments WHERE newsID = ? AND status = ? ORDER BY id DESC");
			    $newsCount->execute(array($post["id"], 1));
			    $post["commentsCount"] = $newsCount->fetchColumn();
			    
			    $post["user"] = [
				    'id' => $post["accountID"],
				    'username' => $post["username"],
				    'displayName' => $post["realname"],
				    'avatar' => AvatarService::get($post["accountID"], $post["realname"]),
			    ];
					
					$post["category"] = [
						'id' => $post["categoryID"],
						'name' => $post["categoryName"],
						'slug' => $post["categorySlug"],
					];
			    
			    $post['image']  = "/assets/core/images/blog/posts/" . $post['imageID'] . "." . $post['imageType'];
			    
			    return $post;
		    }, $posts);
				
        return $this->view('blog.index', compact('posts', 'page', 'pageCount', 'visiblePageCount'));
    }

    public function show($slug)
    {
		    if (auth()->check() && auth()->user()->can('MANAGE_BLOG')) {
			    $accessibleStatuses = ['draft', 'published'];
		    } else {
			    $accessibleStatuses = ['published'];
		    }
		    $accessibleStatuses = implode(", ", array_map(function($status) {
			    return "'$status'";
		    }, $accessibleStatuses));
				
		    $post = db()->prepare("SELECT N.*, A.username, A.realname FROM News N INNER JOIN Accounts A ON N.accountID = A.id WHERE N.slug = ? AND N.status IN ($accessibleStatuses)");
		    $post->execute(array($slug));
		    $post = $post->fetch();

        if (!$post) abort_404();
				
				$category = db()->prepare("SELECT * FROM NewsCategories WHERE id = ?");
				$category->execute(array($post["categoryID"]));
				$category = $category->fetch(PDO::FETCH_ASSOC);
				
				if (!$category) abort_404();
				
				$post["category"] = $category;
				$post["commentsStatus"] = modules('blog')->settings('commentsStatus') == 1 && $post["commentsStatus"] == 1;
	    
		    SeoService::set('blog.posts.show', [
			    'post_title' => $post['title'],
		    ]);
	    
	      $post["user"] = [
					'id' => $post["accountID"],
		      'username' => $post["username"],
		      'displayName' => $post["realname"],
		      'avatar' => AvatarService::get($post["accountID"], $post["realname"]),
	      ];
	    
		    $post['image']  = "/assets/core/images/blog/posts/" . $post['imageID'] . "." . $post['imageType'];
	    
		    $comments = db()->prepare("SELECT NC.*, A.username, A.realname FROM NewsComments NC INNER JOIN Accounts A ON NC.accountID = A.id WHERE NC.newsID = ? AND NC.status = ? ORDER BY NC.id DESC");
		    $comments->execute(array($post["id"], 1));
		    $post["comments"] = array_map(function($comment) {
			    $comment["user"] = [
						'id' => $comment["accountID"],
			      'username' => $comment["username"],
			      'displayName' => $comment["realname"],
			      'avatar' => AvatarService::get($comment["accountID"], $comment["realname"]),
			    ];
					
			    return $comment;
		    }, $comments->fetchAll(PDO::FETCH_ASSOC));
	    
		    $tags = db()->prepare("SELECT NT.* FROM NewsTags NT INNER JOIN News N ON NT.newsID = N.id WHERE NT.newsID = ?");
		    $tags->execute(array($post["id"]));
		    $post["tags"] = $tags->fetchAll(PDO::FETCH_ASSOC);
	    
		    $relatedPosts = db()->prepare("SELECT N.*, A.username, A.realname from News N INNER JOIN Accounts A ON N.accountID = A.id WHERE N.id != ? AND N.status IN ($accessibleStatuses) ORDER BY N.id DESC LIMIT 3");
		    $relatedPosts->execute(array($post["id"]));
		    $post["relatedPosts"] = array_map(function($relatedPost) {
					$category = db()->prepare("SELECT * FROM NewsCategories WHERE id = ?");
					$category->execute(array($relatedPost["categoryID"]));
					$category = $category->fetch(PDO::FETCH_ASSOC);
			    $relatedPost["category"] = $category;
					
					$relatedPost["user"] = [
						'id' => $relatedPost["accountID"],
			      'username' => $relatedPost["username"],
			      'displayName' => $relatedPost["realname"],
			      'avatar' => AvatarService::get($relatedPost["accountID"], $relatedPost["realname"]),
					];
					
					$relatedPost["image"] = "/assets/core/images/blog/posts/" . $relatedPost["imageID"].'.'.$relatedPost["imageType"];
					
					return $relatedPost;
		    }, $relatedPosts->fetchAll(PDO::FETCH_ASSOC));
				
				// Update views count
	      if (!cookies()->has('post_id')) {
		      $updateNews = db()->prepare("UPDATE News SET views = views + 1 WHERE id = ?");
		      $updateNews->execute(array($post["id"]));
		      setcookie('post_id', $post["id"], time() + (10 * 365 * 24 * 60 * 60), rtrim(request()->getUrl()->getAbsoluteUrl(), '/'));
	      }

        return $this->view('blog.post', compact('post'));
    }
}