<?php

namespace Main\Controllers;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;

class ChangelogController extends Controller
{
		protected string $route_type = 'changelog';
		
    public function index()
    {
	      SeoService::set('changelog');
	    
		    $changelogs = db()->query("SELECT * FROM Changelogs ORDER BY id DESC");
		    $changelogs = array_map(function ($changelog) {
			    $changelogItems = db()->prepare("SELECT I.*, T.name as tagName FROM ChangelogItems I INNER JOIN ChangelogTags T ON I.tagID = T.id WHERE I.changelogID = ?");
			    $changelogItems->execute(array($changelog["id"]));
			    $changelog['items'] = $changelogItems->fetchAll(PDO::FETCH_ASSOC);
					
			    return $changelog;
		    }, $changelogs->fetchAll(PDO::FETCH_ASSOC));
				
				$changelogTags = db()->query("SELECT * FROM ChangelogTags");
				$changelogTags = $changelogTags->fetchAll(PDO::FETCH_ASSOC);
				
        return $this->view('changelog.index', compact('changelogs', 'changelogTags'));
    }
	
	public function show($id)
	{
		$changelog = db()->prepare("SELECT * FROM Changelogs WHERE id = ?");
		$changelog->execute(array($id));
		$changelog = $changelog->fetch(PDO::FETCH_ASSOC);
		
		if (!$changelog) abort_404();
		
		$changelogItems = db()->prepare("SELECT I.*, T.name as tagName FROM ChangelogItems I INNER JOIN ChangelogTags T ON I.tagID = T.id WHERE I.changelogID = ?");
		$changelogItems->execute(array($id));
		$changelog['items'] = $changelogItems->fetchAll(PDO::FETCH_ASSOC);
		
		$changelogTags = db()->query("SELECT * FROM ChangelogTags");
		$changelogTags = $changelogTags->fetchAll(PDO::FETCH_ASSOC);
		
		SeoService::set('page', [
			'page_title' => $changelog['title']
		]);
		
		return $this->view('changelog.show', compact('changelog', 'changelogTags'));
	}
}