<?php

namespace Main\Controllers\Chest;

use Main\Core\Controller;
use Main\Core\Redirect;
use Main\Services\SeoService;
use PDO;

class GiftController extends Controller
{
		protected string $route_type = 'chest';
	
		public function __construct()
		{
			if (modules('chest')->settings('canSendGift') == 0) abort_404();
		}
		
    public function index($id)
    {
        $chest = db()->prepare("SELECT C.*, P.name as productName FROM Chests C INNER JOIN Products P ON C.productID = P.id WHERE C.accountID = ? AND C.id = ? AND C.status = ? AND C.isLocked = ?");
        $chest->execute(array(auth()->user()->id(), $id, 0, 0));
        $chest = $chest->fetch();
				
				if (!$chest) abort_404();
	    
	      SeoService::set('chest.gift.index');
				
		    if ($chest["canGift"] == 0) abort_404();
				
				$variables = db()->prepare("SELECT V.*, CV.value FROM ChestProductVariableValues CV INNER JOIN StoreVariables V ON V.id = CV.variableID WHERE CV.chestID = ?");
				$variables->execute(array($chest["id"]));
	      $chest["variables"] = $variables->fetchAll(PDO::FETCH_ASSOC);
				
		    $similarChests = db()->prepare("SELECT C.id, C.productID FROM Chests C INNER JOIN Products P ON C.productID = P.id WHERE C.accountID = ? AND C.status = ? AND C.isLocked = ? AND P.id = ? AND C.id != ?");
		    $similarChests->execute(array(auth()->user()->id(), 0, 0, $chest["productID"], $chest["id"]));
		    $similarChests = $similarChests->fetchAll(PDO::FETCH_ASSOC);
				
		    $amount = 1;
		    foreach ($similarChests as $similarChest) {
			    $variables = db()->prepare("SELECT V.*, CV.value FROM ChestProductVariableValues CV INNER JOIN StoreVariables V ON V.id = CV.variableID WHERE CV.chestID = ?");
			    $variables->execute(array($similarChest["id"]));
			    $variables = $variables->fetchAll(PDO::FETCH_ASSOC);
			    
			    if (json_encode($chest["variables"]) == json_encode($variables)) {
				    $amount++;
			    }
		    }
		    $chest["max"] = $amount;
	      $similarChests = null; // Free memory
				
        $logs = db()->prepare("SELECT CH.*, P.name as productName, OA.realname as otherAccountDisplayName FROM ChestsHistory CH INNER JOIN Chests C ON CH.chestID = C.id INNER JOIN Products P ON C.productID = P.id LEFT JOIN Accounts OA ON OA.id = CH.otherAccountID WHERE CH.accountID = ? ORDER BY CH.id DESC LIMIT 5");
		    $logs->execute(array(auth()->user()->id()));
		    $logs = $logs->fetchAll();

        return $this->view('chest.gift', compact('chest', 'logs'));
    }

    public function send($id)
    {
        validate([
            'username' => 'required',
            'amount' => 'required|numeric',
        ]);

        $chest = db()->prepare("SELECT C.*, P.name as productName FROM Chests C INNER JOIN Products P ON C.productID = P.id WHERE C.accountID = ? AND C.id = ? AND C.status = ? AND C.isLocked = ?");
        $chest->execute(array(auth()->user()->id(), $id, 0, 0));
        $chest = $chest->fetch();
	    
		    if (!$chest) abort_404();
		    
		    $variables = db()->prepare("SELECT V.*, CV.value FROM ChestProductVariableValues CV INNER JOIN StoreVariables V ON V.id = CV.variableID WHERE CV.chestID = ?");
		    $variables->execute(array($chest["id"]));
		    $chest["variables"] = $variables->fetchAll(PDO::FETCH_ASSOC);
		    
		    $similarChests = db()->prepare("SELECT C.id, C.productID FROM Chests C INNER JOIN Products P ON C.productID = P.id WHERE C.accountID = ? AND C.status = ? AND C.isLocked = ? AND P.id = ? AND C.id != ?");
		    $similarChests->execute(array(auth()->user()->id(), 0, 0, $chest["productID"], $chest["id"]));
		    $similarChests = $similarChests->fetchAll(PDO::FETCH_ASSOC);
				$availableChests = [$chest["id"]];
		    $amount = 1;
		    foreach ($similarChests as $similarChest) {
			    $variables = db()->prepare("SELECT V.*, CV.value FROM ChestProductVariableValues CV INNER JOIN StoreVariables V ON V.id = CV.variableID WHERE CV.chestID = ?");
			    $variables->execute(array($similarChest["id"]));
			    $variables = $variables->fetchAll(PDO::FETCH_ASSOC);
			    
			    if (json_encode($chest["variables"]) == json_encode($variables)) {
				    $availableChests[] = $similarChest["id"];
				    $amount++;
			    }
		    }
	      $similarChests = null; // Free memory
	    
		    if (settings('gameType') == 'minecraft') { // Xbox Login (username => uuid / realname => username)
			    $checkAccount = db()->prepare("SELECT id FROM Accounts WHERE realname = ?");
		    } else {
			    $checkAccount = db()->prepare("SELECT id FROM Accounts WHERE username = ?");
		    }
        $checkAccount->execute(array(input("username")));
        $checkAccount = $checkAccount->fetch();
        if ($checkAccount) {
						if ($checkAccount["id"] == auth()->user()->id()) {
								return back()->flash('error', t__("You can't send yourself a gift!"));
						}
					
            if ($amount >= input("amount")) {
	              $availableChests = array_slice($availableChests, 0, input("amount"));
                foreach ($availableChests as $availableChestID) {
                    $updateChest = db()->prepare("UPDATE Chests SET accountID = ? WHERE accountID = ? AND id = ? AND status = ? AND isLocked = ?");
                    $updateChest->execute(array($checkAccount["id"], auth()->user()->id(), $availableChestID, 0, 0));

                    $insertChestHistory = db()->prepare("INSERT INTO ChestsHistory (accountID, otherAccountID, chestID, type, creationDate) VALUES (?, ?, ?, ?, ?)");
                    $insertChestHistory->execute(array(auth()->user()->id(), $checkAccount["id"], $availableChestID, 2, datetime()));
                    $insertChestHistory->execute(array($checkAccount["id"], auth()->user()->id(), $availableChestID, 3, datetime()));
                }
								
								$redirect = new Redirect(url('chest.index'));
                return $redirect->flash('success', t__('Gift has been successfully sent to %username%', ['%username%' => input("username")]));
            } else {
                return back()->flash('error', t__('You can gift a maximum of %amount%', ['%amount%' => $amount]));
            }
        } else {
            return back()->flash('error', t__('User not found!'));
        }
    }
}