<?php

namespace Main\Controllers\CustomForm;

use Main\Core\Controller;
use Main\Services\SeoService;

class AnswerController extends Controller
{
		protected string $route_type = 'form';
		
    public function show($id)
    {
        $form = db()->prepare("SELECT AP.*, A.username, A.realname, AF.title FROM Forms AP INNER JOIN Accounts A ON A.id = AP.accountID INNER JOIN CustomForms AF ON AP.formID = AF.id WHERE AP.id = ? AND AP.accountID = ?");
        $form->execute(array($id, auth()->user()->id()));
        $form = $form->fetch();

        if (!$form) abort_404();
	    
		    SeoService::set('forms.show', [
			    'form_title' => $form['title'],
		    ]);

        $answers = db()->prepare("SELECT GROUP_CONCAT(AA.answer) as answer, AFQ.question FROM FormAnswers AA INNER JOIN CustomFormQuestions AFQ ON AFQ.id = AA.questionID WHERE AA.applicationID = ? GROUP BY AFQ.id");
        $answers->execute(array($form["id"]));
        $form["answers"] = $answers->fetchAll();

        return $this->view('custom-forms.answer', compact('form'));
    }
}