<?php

namespace Main\Controllers;

use Curl\Curl;
use Main\Core\Controller;
use Main\Core\Redirect;
use Main\Services\DiscordBotService;
use PDO;

class DiscordController extends Controller
{
		public function __construct()
		{
			if (settings('loginProvider') == 'discord' || !DiscordBotService::isBotReady()) abort_404();
		}
	
	public function link()
	{
		$accountLinkingProvider = db()->prepare("SELECT * FROM AccountLinkingProviders WHERE slug = ?");
		$accountLinkingProvider->execute(['discord']);
		$accountLinkingProvider = $accountLinkingProvider->fetch(PDO::FETCH_ASSOC);
		if (!$accountLinkingProvider) abort_404();
		
		$linkedAccount = db()->prepare("SELECT * FROM LinkedAccounts WHERE accountID = ? AND providerID = ?");
		$linkedAccount->execute([auth()->user()->id(), $accountLinkingProvider['id']]);
		$linkedAccount = $linkedAccount->fetch(PDO::FETCH_ASSOC);
		if ($linkedAccount) abort_404();
		
		if (isset($_GET["auth_token"])) {
			$oauthToken = get('auth_token');
			$oauthValidateTokenRequest = new Curl();
			$oauthValidateTokenRequest->setHeader('X-Api-Key', settings('apiKey'));
			$oauthValidateTokenRequest->post("https://id.leaderos.net/api/tokens/$oauthToken/validate");
			if ($oauthValidateTokenRequest->error) {
				if (settings('debugModeStatus') == 1) {
					var_dump($oauthValidateTokenRequest->error);
					exit;
				}
				return $this->view('auth.failed', [
					'message' => t__('Something went wrong! Please try again later.')
				]);
			}
			$oauthValidateTokenResponse = $oauthValidateTokenRequest->response;
			if (!isset($oauthValidateTokenResponse->status) || !isset($oauthValidateTokenResponse->data)) {
				if (settings('debugModeStatus') == 1) {
					var_dump($oauthValidateTokenResponse);
					exit;
				}
				return $this->view('auth.failed', [
					'message' => t__('Something went wrong! Please try again later.')
				]);
			}
			if ($oauthValidateTokenResponse->status && $oauthValidateTokenResponse->data->provider == $accountLinkingProvider['slug']) {
				$redirect = new Redirect(url("account.profile.index"));
				$validatedUserData = $oauthValidateTokenResponse->data;
				
				// Check if the connection is already linked to another account
				$checkConnections = db()->prepare("SELECT * FROM LinkedAccounts WHERE providerID = ? AND identifier = ?");
				$checkConnections->execute([$accountLinkingProvider['id'], $validatedUserData->username]);
				$checkConnections = $checkConnections->fetch(PDO::FETCH_ASSOC);
				if ($checkConnections) {
					return $redirect->flash("error", t__('Your %provider% account is already linked to another account!', ['%provider%' => $accountLinkingProvider['name']]));
				}
				
				$insertConnection = db()->prepare("INSERT INTO LinkedAccounts (accountID, providerID, identifier, displayName, creationDate) VALUES (?, ?, ?, ?, ?)");
				$insertConnection->execute([
					auth()->user()->id(),
					$accountLinkingProvider['id'],
					$validatedUserData->username,
					$validatedUserData->realname,
					datetime()
				]);
				
				// Send request to LeaderOS Discord Bot API to add discord roles
				$userRoles = db()->prepare("SELECT R.discordRoleID, AR.expiryDate FROM AccountRoles AR INNER JOIN Roles R ON AR.roleID = R.id WHERE AR.accountID = ? AND R.discordRoleID IS NOT NULL AND R.discordRoleID != '' AND (AR.expiryDate = '1000-01-01 00:00:00' OR AR.expiryDate > ?)");
				$userRoles->execute([auth()->user()->id(), datetime()]);
				$userRoles = array_map(function ($role) {
					return [
						'id' => $role['discordRoleID'],
						'expiryDate' => $role['expiryDate']
					];
				}, $userRoles->fetchAll(PDO::FETCH_ASSOC));
				
				$defaultRole = db()->prepare('SELECT discordRoleID FROM Roles WHERE slug = ? AND discordRoleID IS NOT NULL AND discordRoleID != "" LIMIT 1');
				$defaultRole->execute(['default']);
				$defaultRole = $defaultRole->fetch(PDO::FETCH_ASSOC);
				if ($defaultRole) {
					$userRoles[] = [
						'id' => $defaultRole['discordRoleID'],
						'expiryDate' => '1000-01-01 00:00:00'
					];
				}
				
				DiscordBotService::linkUser($validatedUserData->username, auth()->user()->displayName(), $userRoles);
				
				return $redirect->flash("success", t__('Your %provider% account has been successfully linked to your account!', ['%provider%' => $accountLinkingProvider['name']]));
			} else {
				return $this->view('auth.failed', [
					'message' => t__('Something went wrong! Please try again later.')
				]);
			}
		} else {
			redirect('https://id.leaderos.net/redirect?provider=' . $accountLinkingProvider['slug'] . "&return=" . urlencode(website_url(url('discord.link'))) . "&s=" . LOCATION);
		}
	}
	
	public function unlink()
	{
		$accountLinkingProvider = db()->prepare("SELECT * FROM AccountLinkingProviders WHERE slug = ?");
		$accountLinkingProvider->execute(['discord']);
		$accountLinkingProvider = $accountLinkingProvider->fetch(PDO::FETCH_ASSOC);
		if (!$accountLinkingProvider) abort_404();
		
		$linkedAccount = db()->prepare("SELECT * FROM LinkedAccounts WHERE accountID = ? AND providerID = ?");
		$linkedAccount->execute([auth()->user()->id(), $accountLinkingProvider['id']]);
		$linkedAccount = $linkedAccount->fetch(PDO::FETCH_ASSOC);
		if (!$linkedAccount) abort_404();
		
		// Send request to LeaderOS Discord Bot API to remove discord roles
		$siteRoles = db()->query("SELECT discordRoleID FROM Roles WHERE discordRoleID IS NOT NULL AND discordRoleID != ''");
		$siteRoles = $siteRoles->fetchAll(PDO::FETCH_ASSOC);
		
		DiscordBotService::unlinkUser($linkedAccount['identifier'], array_column($siteRoles, 'discordRoleID'));
		
		$unlinkAccount = db()->prepare("DELETE FROM LinkedAccounts WHERE accountID = ? AND providerID = ?");
		$unlinkAccount->execute([auth()->user()->id(), $accountLinkingProvider['id']]);
		
		$redirect = new Redirect(url("account.profile.index"));
		return $redirect->flash("success", t__('Your %provider% account has been successfully unlinked from your account!', ['%provider%' => $accountLinkingProvider['name']]));
	}
}