<?php

namespace Main\Controllers;

use Main\Core\Controller;
use Main\Core\Jobs\JobDispatcher;
use Main\Core\Redirect;
use Main\Jobs\SendEmail;
use Main\Services\SeoService;
use PDO;
use PHPMailer\PHPMailer\Exception;

class EmailVerificationController extends Controller
{
    public function index()
    {
	      SeoService::set('email.verification.index');
				
        return $this->view('verify-email');
    }
	
		public function send()
		{
			try {
				$verification = db()->prepare("SELECT * FROM AccountEmailVerificationTokens WHERE accountID = ? AND expiryDate > ?");
				$verification->execute(array(auth()->user()->id(), datetime()));
				$verification = $verification->fetch();
				if (!$verification) {
					$token = rand_token();
					$insertAccountEmailVerificationTokens = db()->prepare("INSERT INTO AccountEmailVerificationTokens (accountID, token, creationIP, expiryDate, lastSend, creationDate) VALUES (?, ?, ?, ?, ?, ?)");
					$insertAccountEmailVerificationTokens->execute(array(auth()->user()->id(), $token, getIP(), createDuration(0.04166666666), datetime(), datetime()));
					
					$url = website_url(url('email.verification.verify', ['token' => $token]));
					$search = array("%username%", "%url%");
					$replace = array(auth()->user()->displayName(), $url);
					$template = modules('email_verification')->settings('verifyEmailTemplate');
					$content = str_replace($search, $replace, $template);
					JobDispatcher::dispatch((new SendEmail(auth()->user()->email(), modules('email_verification')->settings('verifyEmailTitle'), $content)));
					
					response()->json([
						'status' => true,
					]);
				}
				
				response()->json([
					'status' => false,
				]);
			} catch (Exception $e) {
				response()->json([
					'status' => false,
					'message' => settings('debugModeStatus') == 1 ? $e->errorMessage() : t__('Could not send mail due to a system error.')
				]);
			}
		}
	
		public function sendAgain()
		{
			try {
				$verification = db()->prepare("SELECT * FROM AccountEmailVerificationTokens WHERE accountID = ? AND expiryDate > ?");
				$verification->execute(array(auth()->user()->id(), datetime()));
				$verification = $verification->fetch();

				if ($verification) {
					// Last try is less than 2 min ago
					if ($verification["lastSend"] > date('Y-m-d H:i:s', strtotime('-2 minutes'))) {
						return back()->flash('error', t__('Please wait a few minutes before trying again.'));
					}
					$token = $verification['token'];
					$updateAccountEmailVerificationTokens = db()->prepare("UPDATE AccountEmailVerificationTokens SET lastSend = ? WHERE id = ?");
					$updateAccountEmailVerificationTokens->execute(array(datetime(), $verification['id']));
				} else {
					$token = rand_token();
					$insertAccountEmailVerificationTokens = db()->prepare("INSERT INTO AccountEmailVerificationTokens (accountID, token, creationIP, expiryDate, lastSend, creationDate) VALUES (?, ?, ?, ?, ?, ?)");
					$insertAccountEmailVerificationTokens->execute(array(auth()->user()->id(), $token, getIP(), createDuration(0.04166666666), datetime(), datetime()));
				}
				
				$url = website_url(url('email.verification.verify', ['token' => $token]));
				$search = array("%username%", "%url%");
				$replace = array(auth()->user()->displayName(), $url);
				$template = modules('email_verification')->settings('verifyEmailTemplate');
				$content = str_replace($search, $replace, $template);
				JobDispatcher::dispatch((new SendEmail(auth()->user()->email(), modules('email_verification')->settings('verifyEmailTitle'), $content)));
				
				return back()->flash('success', t__('Email sent successfully! Please check your inbox and spam folder.'));
			} catch (Exception $e) {
				return back()->flash('error', t__('Could not send mail due to a system error:') . " " . (settings('debugModeStatus') == 1 ? $e->errorMessage() : ""));
			}
		}


    public function verify($token)
    {
				$verification = db()->prepare("SELECT * FROM AccountEmailVerificationTokens WHERE accountID = ? AND token = ? AND expiryDate > ?");
		    $verification->execute(array(auth()->user()->id(), $token, datetime()));
		    $verification = $verification->fetch();
				
				if (!$verification) abort_404();
			
        $expireToken = db()->prepare("UPDATE AccountEmailVerificationTokens SET expiryDate = ? WHERE id = ?");
				$expireToken->execute(array(datetime(), $verification["id"]));
				
        $updateAccount = db()->prepare("UPDATE Accounts SET isVerified = ? WHERE id = ?");
        $updateAccount->execute(array(1, auth()->user()->id()));
				
				$redirect = new Redirect(url('account.profile.index'));
				return $redirect->flash('success', t__('Your email has been verified!'));
    }
}