<?php

namespace Main\Controllers;

use Main\Core\Controller;
use Main\Core\Jobs\JobDispatcher;
use Main\Jobs\SendDiscordWebhook;
use Main\Services\DeliveryService;
use Main\Services\SeoService;
use PDO;

class FortuneWheelController extends Controller
{
		protected string $route_type = 'lottery';
	
		public function index()
		{
			$lotteries = db()->query("SELECT * FROM Lotteries");
			$lotteries = $lotteries->fetchAll(PDO::FETCH_ASSOC);
			
			if (count($lotteries) == 1) {
				redirect(url('fortune-wheel.show', ['slug' => $lotteries[0]['slug']]));
			}
			
			SeoService::set('fortune-wheel.index');
			
			return $this->view('fortune-wheel.index', compact('lotteries'));
		}

    public function show($slug)
    {
        $lotteries = db()->query("SELECT title, slug FROM Lotteries");
        $lotteries = $lotteries->fetchAll();

        $lottery = db()->prepare("SELECT * FROM Lotteries WHERE slug = ?");
        $lottery->execute(array($slug));
        $lottery = $lottery->fetch();

        if (!$lottery) abort_404();
	    
		    SeoService::set('fortune-wheel.show', [
			    'fortune_wheel_name' => $lottery['title']
		    ]);

        $slices = array();
        $lotteryAwards = db()->prepare("SELECT * FROM LotteryAwards WHERE lotteryID = ? AND isEnabled = ?");
        $lotteryAwards->execute(array($lottery["id"], 1));
		    $lotteryAwards = $lotteryAwards->fetchAll();

        foreach ($lotteryAwards as $lotteryAward) {
            array_push($slices, array(
                'id' => (int)$lotteryAward["id"],
                'text' => $lotteryAward["title"],
                'type' => (int)$lotteryAward["awardType"],
                'award' => $lotteryAward["award"],
                'background' => $lotteryAward["color"],
            ));
        }
	      $lottery["slices"] = $slices;
	    
	      $logs = db()->prepare("SELECT LH.*, LA.title, LA.awardType, LA.award FROM LotteryHistory LH INNER JOIN LotteryAwards LA ON LH.lotteryAwardID = LA.id INNER JOIN Lotteries L ON LA.lotteryID = L.id WHERE L.id = ? AND LH.accountID = ? AND LA.awardType != ? ORDER by LH.id DESC LIMIT 5");
        $logs->execute(array($lottery["id"], auth()->user()->id(), 3));
	      $logs = $logs->fetchAll();

        return $this->view('fortune-wheel.show', compact('lottery', 'logs', 'lotteries'));
    }

    public function spin($id)
    {
        function getAward($ps)
        {
            $psClone = [];
            foreach ($ps as $value) {
                $psClone = array_merge($psClone, ["#" . $value["id"] => $value['chance']]);
            }

            static $arr = array();
            $key = md5(serialize($psClone));

            if (!isset($arr[$key])) {
                $max = array_sum($psClone);
                foreach ($psClone as $k => $v) {
                    $v = $v / $max * 10000;
                    for ($i = 0; $i < $v; $i++) $arr[$key][] = $k;
                }
            }
            $id = str_replace("#", "", $arr[$key][mt_rand(0, count($arr[$key]) - 1)]);
            foreach ($ps as $value) {
                if ($value["id"] == $id) {
                    return $value;
                }
            }
        }

        $lottery = db()->prepare("SELECT * FROM Lotteries WHERE id = ?");
        $lottery->execute(array($id));
        $lottery = $lottery->fetch();

        if (!$lottery) abort_404();

        if ($lottery["price"] == 0 || auth()->user()->data("credit") >= $lottery["price"]) {
            $lotteryHistory = db()->prepare("SELECT LH.creationDate, L.duration FROM LotteryHistory LH INNER JOIN LotteryAwards LA ON LA.id = LH.lotteryAwardID INNER JOIN Lotteries L ON LA.lotteryID = L.id WHERE L.id = ? AND LH.accountID = ? AND L.price = ? ORDER BY LH.id DESC LIMIT 1");
            $lotteryHistory->execute(array($lottery["id"], auth()->user()->id(), 0));
            $lotteryHistory = $lotteryHistory->fetch();

            $expiryDate = ($lotteryHistory) ? date("Y-m-d H:i:s", (strtotime($lotteryHistory["creationDate"]) + ($lotteryHistory["duration"] * 3600))) : datetime();
            // Oyuncu daha önce ücretsiz oynamamışsa veya oynadıysa da oynama limiti kalktıysa
            if (!$lotteryHistory || ($lotteryHistory && datetime() > $expiryDate)) {
                $lotteryAwardID = 0;
                $awardType = 1;
                $award = 0;
                $total = 0;
                $lotteryAwards = db()->prepare("SELECT * FROM LotteryAwards WHERE lotteryID = ? AND isEnabled = ? ORDER BY chance DESC");
                $lotteryAwards->execute(array($lottery["id"], 1));
                $lotteryAwards = $lotteryAwards->fetchAll(PDO::FETCH_ASSOC);

                $lotteryAward = getAward($lotteryAwards);
                $lotteryAwardID = $lotteryAward["id"];
                $lotteryAwardTitle = $lotteryAward["title"];
                $awardType = $lotteryAward["awardType"];
                $award = $lotteryAward["award"];

                $insertCreditHistory = db()->prepare("INSERT INTO CreditHistory (accountID, type, price, creationDate) VALUES (?, ?, ?, ?)");

                // Oyun ücretli ise kredisini kes
                if ($lottery["price"] > 0) {
                    $updateAccount = db()->prepare("UPDATE Accounts SET credit = credit - ? WHERE id = ?");
                    $updateAccount->execute(array($lottery["price"], auth()->user()->id()));

                    $insertCreditHistory->execute(array(auth()->user()->id(), 5, $lottery["price"], datetime()));
                }

                // Oyun geçmişine ekle
                $insertLotteryHistory = db()->prepare("INSERT INTO LotteryHistory (accountID, lotteryAwardID, creationDate) VALUES (?, ?, ?)");
                $insertLotteryHistory->execute(array(auth()->user()->id(), $lotteryAwardID, datetime()));
                $lotteryHistoryID = db()->lastInsertId();

                // Kredi Kazanırsa kredisini ver
                if ($awardType == 1) {
                    $updateAccount = db()->prepare("UPDATE Accounts SET credit = credit + ? WHERE id = ?");
                    $updateAccount->execute(array($award, auth()->user()->id()));
                    $insertCreditHistory->execute(array(auth()->user()->id(), 6, $award, datetime()));
                }

                // Ürün Kazanırsa ürünü sandığa ekle
                if ($awardType == 2) {
                    if (!modules('chest')->isActive()) {
												DeliveryService::deliver(
													[[
														'id' => $award,
														'quantity' => 1
													]],
													auth()->user()->id(),
													"lottery",
													$lotteryHistoryID,
												);
                    } else {
                        $insertChests = db()->prepare("INSERT INTO Chests (accountID, productID, status, creationDate) VALUES (?, ?, ?, ?)");
                        $insertChests->execute(array(auth()->user()->id(), $award, 0, datetime()));
                    }
                }

                // Discord Webhook Gönder (Pas gelmediyse)
                if ($awardType != 3) {
	                JobDispatcher::dispatch((new SendDiscordWebhook('wheel.won', [
		                "username" => auth()->user()->displayName(),
		                "name" => $lottery["title"],
		                "award" => $lotteryAwardTitle,
	                ])));
                }

                response()->json([
										'status' => true,
                    'result' => $lotteryAwardID
                ]);
            } else {
                response()->json([
										'status' => false,
                    'error' => 'error_duration',
										'message' => t__('You have to wait until %date% to re-spin for free.', ['%date%' => date("d.m.Y H:i", (strtotime($lotteryHistory["creationDate"]) + ($lotteryHistory["duration"] * 3600)))]),
                ]);
            }
        } else {
            response()->json([
		            'status' => false,
                'error' => 'error_credit',
	              'message' => t__("You don't have enough credit to play the game.")
            ]);
        }
    }
	
		public function logs()
		{
			SeoService::set('fortune-wheel.logs');
			
			$logs = db()->prepare("SELECT LH.*, L.title as lotteryTitle, LA.title as awardTitle, LA.awardType, LA.award FROM LotteryHistory LH INNER JOIN LotteryAwards LA ON LH.lotteryAwardID = LA.id INNER JOIN Lotteries L ON LA.lotteryID = L.id WHERE LH.accountID = ? AND LA.awardType != ? ORDER by LH.id DESC LIMIT 50");
			$logs->execute(array(auth()->user()->id(), 3));
			$logs = $logs->fetchAll();
			
			return $this->view('fortune-wheel.logs', compact('logs'));
		}
}