<?php

namespace Main\Controllers\Forum;

use Exception;
use Main\Core\Controller;
use Main\Services\AvatarService;
use Main\Services\CkEditorImageUploadService;
use Main\Services\SeoService;
use Main\Services\UserService;
use PDO;

class ForumController extends Controller
{
		protected string $route_type = 'forum';
		
    public function index()
    {
				SeoService::set('forum.index');
			
        $categories = db()->prepare("SELECT * FROM ForumCategories WHERE parentID = ?");
		    $categories->execute(array(0));
		    $categories = array_map(function ($category) {
			    if (!forum()->user()->can($category["id"], "VIEW_FORUM")) return false;
					
					$subcategories = db()->prepare("SELECT * FROM ForumCategories WHERE parentID = ?");
					$subcategories->execute(array($category["id"]));
					$category["subcategories"] = array_map(function ($subcategory) {
						if (!forum()->user()->can($subcategory["id"], "VIEW_FORUM")) return false;
						
						$childCategories = db()->prepare("SELECT * FROM ForumCategories WHERE parentID = ?");
						$childCategories->execute(array($subcategory["id"]));
						$subcategory["subcategories"] = $childCategories->fetchAll();
						
						$subcategory["image"] = "/assets/core/images/forum/categories/" . $subcategory["imageID"] . "." . $subcategory["imageType"];
						
						
						return $subcategory;
					}, $subcategories->fetchAll(PDO::FETCH_ASSOC));
			    
			    $category["subcategories"] = array_filter($category["subcategories"]);
					$category["image"] = "/assets/core/images/forum/categories/" . $category["imageID"] . "." . $category["imageType"];
					
					return $category;
				}, $categories->fetchAll(PDO::FETCH_ASSOC));
				$categories = array_filter($categories);
				
				$viewableCategories = array_keys(forum()->user()->permissions());
				
				
        if (in_array('*', $viewableCategories)) {
	        $recentThreads = db()->query("SELECT FT.*, A.username, A.realname FROM ForumThreads FT INNER JOIN ForumCategories FC ON FC.id = FT.categoryID INNER JOIN Accounts A ON A.id = FT.accountID ORDER BY FT.id DESC LIMIT 5");
					$recentReplies = db()->query("SELECT FT.id, FT.slug, FT.title, FT.categoryID, FR.creationDate, FR.accountID, A.username, A.realname FROM ForumReplies FR INNER JOIN Accounts A ON A.id = FR.accountID INNER JOIN ForumThreads FT ON FT.id = FR.threadID INNER JOIN ForumCategories FC ON FC.id = FT.categoryID ORDER BY FR.id DESC LIMIT 5");
        } else {
	        $recentThreads = db()->prepare("SELECT FT.*, A.username, A.realname FROM ForumThreads FT INNER JOIN ForumCategories FC ON FC.id = FT.categoryID INNER JOIN Accounts A ON A.id = FT.accountID WHERE FT.categoryID IN (". implode(',', array_fill(0, count($viewableCategories), "?")) .") ORDER BY FT.id DESC LIMIT 5");
	        $recentThreads->execute($viewableCategories);
	        
	        $recentReplies = db()->prepare("SELECT FT.id, FT.slug, FT.title, FT.categoryID, FR.creationDate, FR.accountID, A.username, A.realname FROM ForumReplies FR INNER JOIN Accounts A ON A.id = FR.accountID INNER JOIN ForumThreads FT ON FT.id = FR.threadID INNER JOIN ForumCategories FC ON FC.id = FT.categoryID WHERE FT.categoryID IN (". implode(',', array_fill(0, count($viewableCategories), "?")) .") ORDER BY FR.id DESC LIMIT 5");
	        $recentReplies->execute($viewableCategories);
        }
        $recentThreads = array_map(function ($thread) {
	        $thread["user"] = [
						'id' => $thread["accountID"],
		        'username' => $thread["username"],
		        'displayName' => $thread["realname"],
						'avatar' => AvatarService::get($thread["accountID"], $thread["realname"])
	        ];
					
	        return $thread;
				}, $recentThreads->fetchAll(PDO::FETCH_ASSOC));
        $recentReplies = array_map(function ($thread) {
	        $thread["user"] = [
		        'id' => $thread["accountID"],
		        'username' => $thread["username"],
		        'displayName' => $thread["realname"],
		        'avatar' => AvatarService::get($thread["accountID"], $thread["realname"])
	        ];
	        
	        return $thread;
        }, $recentReplies->fetchAll(PDO::FETCH_ASSOC));

        $onlineUsersLogs = db()->prepare("SELECT A.username, A.realname, OAH.accountID FROM OnlineAccountsHistory OAH INNER JOIN Accounts A ON OAH.accountID = A.id WHERE OAH.expiryDate > ?");
		    $onlineUsersLogs->execute(array(datetime()));
		    $onlineUsersLogs = $onlineUsersLogs->fetchAll();
		    $onlineUsers = [];

        if (count($onlineUsersLogs) > 0) {
            foreach ($onlineUsersLogs as $onlineUsersLog) {
                $userRoles = UserService::getRoles($onlineUsersLog["accountID"]);
		            $onlineUsers[] = [
									'id' => $onlineUsersLog["accountID"],
			            'username' => $onlineUsersLog["username"],
			            'displayName' => $onlineUsersLog["realname"],
			            'role' => $userRoles[0]["slug"],
		            ];
            }
        }

        return $this->view('forum.index', compact('categories', 'recentThreads', 'recentReplies', 'onlineUsers'));
    }
	
	public function upload()
	{
		try {
			$image = CkEditorImageUploadService::upload($_FILES["upload"], "/apps/main/public/images/forum/uploads/");
			response()->json([
				'url' => '/assets/core/images/forum/uploads/' . $image,
			]);
		} catch (Exception $e) {
			response()->json([
				'status' => false,
				'error'  => $e->getMessage(),
			]);
		}
	}
}