<?php

namespace Main\Controllers\Forum;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;

class ReplyController extends Controller
{
		protected string $route_type = 'forum';
	
    public function edit($id)
    {
        $reply = db()->prepare("SELECT * FROM ForumReplies WHERE id = ?");
        $reply->execute(array($id));
        $reply = $reply->fetch();

        if (!$reply) abort_404();
				
				$thread = db()->prepare("SELECT * FROM ForumThreads WHERE id = ?");
				$thread->execute(array($reply["threadID"]));
				$thread = $thread->fetch();
				$reply["thread"] = $thread;
	    
		    if (!$thread) abort_404();
	    
		    $canModerate = forum()->user()->can($thread["categoryID"], "MODERATE_FORUM");
		    if (!$canModerate && $reply['accountID'] != auth()->user()->id()) {
			    abort_404();
		    }
	    
	      SeoService::set('forum.replies.edit');

        return $this->view('forum.replies.edit', compact('reply'));
    }

    public function update($id)
    {
        validate([
            "message" => "required"
        ]);

		    $reply = db()->prepare("SELECT * FROM ForumReplies WHERE id = ?");
		    $reply->execute(array($id));
		    $reply = $reply->fetch();
		    
		    if (!$reply) abort_404();
		    
		    $thread = db()->prepare("SELECT * FROM ForumThreads WHERE id = ?");
		    $thread->execute(array($reply["threadID"]));
		    $thread = $thread->fetch();
		    
		    if (!$thread) abort_404();
		    
		    $canModerate = forum()->user()->can($thread["categoryID"], "MODERATE_FORUM");
		    if (!$canModerate && $reply['accountID'] != auth()->user()->id()) {
			    abort_404();
		    }

        $updateReply = db()->prepare("UPDATE ForumReplies SET message = ?, updatedDate = ? WHERE id = ?");
        $updateReply->execute(array(input("message"), datetime(), $reply["id"]));

        return back()->flash("success", t__("Your reply has been updated successfully!"));
    }

    public function destroy($id)
    {
		    $reply = db()->prepare("SELECT * FROM ForumReplies WHERE id = ?");
		    $reply->execute(array($id));
		    $reply = $reply->fetch();
		    
		    if (!$reply) abort_404();
		    
		    $thread = db()->prepare("SELECT * FROM ForumThreads WHERE id = ?");
		    $thread->execute(array($reply["threadID"]));
		    $thread = $thread->fetch();

        if (!$thread) abort_404();
	    
		    $canModerate = forum()->user()->can($thread["categoryID"], "MODERATE_FORUM");
		    if (!$canModerate && $reply['accountID'] != auth()->user()->id()) {
			    abort_404();
		    }
	    
		    $deleteReply = db()->prepare("DELETE FROM ForumReplies WHERE id = ?");
		    $deleteReply->execute(array($id));

        redirect(url('forum.threads.show', ['id' => $thread["id"], 'slug' => $thread["slug"]]));
    }
}