<?php

namespace Main\Controllers;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;

class GameController extends Controller
{
		protected string $route_type = 'games';
	
    public function index()
    {
	      SeoService::set('games.index');
				
        $games = db()->query("SELECT * FROM Games ORDER BY id DESC");
		    $games = array_map(function($game) {
			    $game["image"] = "/assets/core/images/games/" . $game["imageID"].'.'.$game["imageType"];
			    
			    return $game;
		    }, $games->fetchAll(PDO::FETCH_ASSOC));

        return $this->view('games.index', compact('games'));
    }

    public function show($slug)
    {
        $game = db()->prepare("SELECT * FROM Games WHERE slug = ?");
        $game->execute([$slug]);
        $game = $game->fetch(PDO::FETCH_ASSOC);

        if (!$game) abort_404();
	    
	      SeoService::set('games.show', [
					'game_name' => $game['title'],
	      ]);
	    
		    $games = db()->query("SELECT * FROM Games ORDER BY id DESC");
		    $games = array_map(function($game) {
		        $game["image"] = "/assets/core/images/games/" . $game["imageID"].'.'.$game["imageType"];
						
		        return $game;
		    }, $games->fetchAll(PDO::FETCH_ASSOC));

        return $this->view('games.show', compact('game', 'games'));
    }
}