<?php

namespace Main\Controllers\GamingNight;

use DateTime;
use DateTimeZone;
use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;

class GamingNightController extends Controller
{
		protected string $route_type = 'gaming-night';
	
    public function index()
    {
	      SeoService::set('gaming-night.index');
			
				if (modules('gaming_night')->settings('day') == date("l") && date("Hi") >= modules('gaming_night')->settings('start') && date("Hi") <= modules('gaming_night')->settings('end')) {
					$products = db()->prepare("SELECT P.id, P.name, P.price, P.imageID, P.imageType, P.categoryID, P.priority, GNP.price as discountedPrice, GNP.stock, PC.isCumulative FROM GamingNightProducts GNP INNER JOIN Products P ON GNP.productID = P.id INNER JOIN ProductCategories PC ON PC.id = P.categoryID WHERE P.isActive = ?");
					$products->execute(array(1));
					$products = array_map(function($product) {
						$subs = false;
						if ($product["isCumulative"] == '1' && auth()->check()) {
							$discountProducts = explode(",", modules('store')->settings('discountProducts'));
							$subs = db()->prepare("SELECT * FROM Subscriptions S INNER JOIN Products P ON P.id = S.productID WHERE P.categoryID = ? AND accountID = ? AND (endsAt > ? OR endsAt = '1000-01-01 00:00:00') ORDER BY P.priority ASC LIMIT 1");
							$subs->execute(array($product["categoryID"], auth()->user()->id(), datetime()));
							$subs = $subs->fetch(PDO::FETCH_ASSOC);
							if ($subs) {
								$searchSubsProductInGamingNight = db()->prepare("SELECT * FROM GamingNightProducts WHERE productID = ?");
								$searchSubsProductInGamingNight->execute(array($subs["productID"]));
								$searchSubsProductInGamingNight = $searchSubsProductInGamingNight->fetch();
								if ($searchSubsProductInGamingNight)
									$subs["price"] = $searchSubsProductInGamingNight["price"];
								else if ($subs["discountedPrice"] > 0 && ($subs["discountExpiryDate"] > datetime() || $subs["discountExpiryDate"] == '1000-01-01 00:00:00'))
									$subs["price"] = $subs["discountedPrice"];
								else if (modules('store')->settings('discount') != 0 && (in_array($subs["productID"], $discountProducts) || modules('store')->settings('discountProducts') == '0') && (modules('store')->settings('discountExpiryDate') > datetime() || modules('store')->settings('discountExpiryDate') == '1000-01-01 00:00:00'))
									$subs["price"] = ($subs["price"]*(100-modules('store')->settings('discount')))/100;
							}
						}
						
						if ($subs && $product["priority"] < $subs["priority"]) {
							if ($subs["endsAt"] == '1000-01-01 00:00:00') {
								$product["discountedPrice"] = $product["discountedPrice"] - $subs["price"];
							} else {
								$product["discountedPrice"] = $product["discountedPrice"] - (($subs["price"] * (strtotime($subs["endsAt"]) - time())) / (strtotime($subs["endsAt"]) - strtotime($subs["startsAt"])));
							}
						}
						$product["discountPercent"] = round((($product["price"]-$product["discountedPrice"])*100)/($product["price"]));
						$product["subs"] = $subs;
						$product["image"] = "/assets/core/images/store/products/" . $product["imageID"] . "." . $product["imageType"];
						
						return $product;
					}, $products->fetchAll());
					
					return $this->view('gaming-night.index', compact('products'));
				}
				
		    // Get Server Timezone
		    $serverTimezone = date_default_timezone_get();
		    $serverTimezoneObject = new DateTimeZone($serverTimezone);
		    $utcTimezoneObject = new DateTimeZone("UTC");
	
				// Set Gaming Night Start and End
		    $gamingNightStart = modules('gaming_night')->settings('start');
		    $gamingNightStartFormatted = substr($gamingNightStart, 0, 2) . ":" . substr($gamingNightStart, 2, 2);
		    
		    $gamingNightEnd = modules('gaming_night')->settings('end');
		    $gamingNightEndFormatted = substr($gamingNightEnd, 0, 2) . ":" . substr($gamingNightEnd, 2, 2);
	
				// If today is gaming night and not ended
		    if (modules('gaming_night')->settings('day') == date("l") && modules('gaming_night')->settings('end') > date("Hi")) {
			    $dateString = date("Y-m-d") . " " . $gamingNightStartFormatted . ":00";
			    $dateEndString = date("Y-m-d") . " " . $gamingNightEndFormatted . ":00";
		    } else {
			    $nextGameNightDate = date("Y-m-d", strtotime("next " . modules('gaming_night')->settings('day')));
			    $dateString = $nextGameNightDate . " " . $gamingNightStartFormatted . ":00";
			    $dateEndString = $nextGameNightDate . " " . $gamingNightEndFormatted . ":00";
		    }
	
				// Convert to UTC
		    $dateTime = new DateTime($dateString, $serverTimezoneObject);
		    $dateTime->setTimezone($utcTimezoneObject);
		    $tick = $dateTime->format("Y-m-d\TH:i:sP");
		    
		    $dateTimeEnd = new DateTime($dateEndString, $serverTimezoneObject);
		    $dateTimeEnd->setTimezone($utcTimezoneObject);
		    $tickEnd = $dateTimeEnd->format("Y-m-d\TH:i:sP");
		    
		    return $this->view('gaming-night.countdown', compact('gamingNightStartFormatted', 'gamingNightEndFormatted', 'tick', 'tickEnd'));
    }
}