<?php

namespace Main\Controllers\Help;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;

class ArticleController extends Controller
{
		protected string $route_type = 'help';
	
    public function show($id, $slug)
    {
        $article = db()->prepare("SELECT HA.*, HT.name as topicName, HT.slug as topicSlug FROM HelpArticles HA INNER JOIN HelpTopics HT ON HA.topicID = HT.id WHERE HA.id = ?");
		    $article->execute(array($id));
		    $article = $article->fetch();

        if (!$article) abort_404();
	    
	      SeoService::set('help.articles.show', [
					'article_title' => $article['title'],
	      ]);

        $relatedArticles = db()->prepare("SELECT id, title, slug FROM HelpArticles WHERE topicID = ? AND id != ?");
        $relatedArticles->execute(array($article["topicID"], $article["id"]));
	      $article["relatedArticles"] = $relatedArticles->fetchAll();
				
				if (!cookies()->has("isArticleViewed")) {
					$updateHelpArticleViews = db()->prepare("UPDATE HelpArticles SET views = views + 1 WHERE id = ?");
					$updateHelpArticleViews->execute(array($article["id"]));
					setcookie("isArticleViewed", $article["id"]);
				}

        return $this->view('help.article', compact('article'));
    }

    public function rate($id)
    {
        $article = db()->prepare("SELECT id FROM HelpArticles WHERE id = ?");
		    $article->execute(array($id));
		    $article = $article->fetch();

        if (!$article) abort_404();

        validate([
            'rating' => 'required|boolean'
        ]);
	    
		    if (!cookies()->has("isArticleRated")) {
			    setcookie("isArticleRated", $article["id"]);
	
			    if (input("rating")) {
				    $updateHelpArticle = db()->prepare("UPDATE HelpArticles SET likesCount = likesCount+1 WHERE id = ?");
			    } else {
				    $updateHelpArticle = db()->prepare("UPDATE HelpArticles SET dislikesCount = dislikesCount+1 WHERE id = ?");
			    }
			    $updateHelpArticle->execute(array($article["id"]));
		    }
				
				// If client accepts JSON
	      if (request()->isAjax()) {
		      response()->json([
			      'status' => 'success',
			      'message' => t__('You have successfully voted!')
		      ]);
	      }
				
				return back()->flash('success', t__('You have successfully voted!'));
    }
}