<?php

namespace Main\Controllers\Help;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;

class HelpController extends Controller
{
		protected string $route_type = 'help';
	
    public function index()
    {
	      SeoService::set('help.index');
				
        $topics = db()->query("SELECT name, description, slug, imageID, imageType FROM HelpTopics ORDER BY `order` ASC, name ASC");
		    $topics = array_map(function($topic) {
						$topic['image'] = "/assets/core/images/help/topics/" . $topic['imageID'] . '.' . $topic['imageType'];
						
						return $topic;
		    }, $topics->fetchAll(PDO::FETCH_ASSOC));

        $popularArticles = db()->query("SELECT HA.id, HA.slug, HA.title, HA.content FROM HelpArticles HA INNER JOIN HelpTopics HT ON HA.topicID = HT.id ORDER BY HA.views DESC LIMIT 10");
		    $popularArticles = $popularArticles->fetchAll(PDO::FETCH_ASSOC);

        return $this->view('help.index', compact('topics', 'popularArticles'));
    }
	
		public function search()
		{
			if (!input('q')) abort_404();
			
			$query = input('q');
			
			SeoService::set('help.search', [
				'search_query' => $query,
			]);
			
			$articles = db()->prepare("SELECT id, slug, title FROM HelpArticles WHERE title LIKE :search OR content LIKE :search");
			$articles->execute([":search" => "%$query%"]);
			$articles = $articles->fetchAll();
			
			return $this->view('help.search', compact('articles', 'query'));
		}
}