<?php

namespace Main\Controllers\Help;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;

class TopicController extends Controller
{
		protected string $route_type = 'help';
	
    public function show($slug)
    {
        $topic = db()->prepare("SELECT * FROM HelpTopics WHERE slug = ?");
		    $topic->execute(array($slug));
		    $topic = $topic->fetch();

        if (!$topic) abort_404();
	    
		    SeoService::set('help.topics.show', [
			    'topic_title' => $topic['name'],
		    ]);

        $articles = db()->prepare("SELECT * FROM HelpArticles WHERE topicID = ? ORDER BY `order` ASC, id DESC");
		    $articles->execute(array($topic["id"]));
		    $articles = $articles->fetchAll();
	    
	      $topic["articles"] = $articles;

        return $this->view('help.topic', compact('topic', 'articles'));
    }
}