<?php
  
  namespace Main\Controllers;
  
  use Main\Core\Controller;
  use Main\Services\SeoService;
  use PDO;
  use PDOException;
  
  class LeaderboardController extends Controller
  {
	  protected string $route_type = 'leaderboard';
		
    public function index()
    {
	    $firstServer = db()->query("SELECT serverSlug FROM Leaderboards ORDER BY id DESC LIMIT 1");
	    $firstServer = $firstServer->fetch(PDO::FETCH_ASSOC);
	    if ($firstServer) {
		    redirect(url('leaderboards.show', ['slug' => $firstServer['serverSlug']]));
	    }
	    
	    SeoService::set('leaderboards.index');
			
			abort_404();
			//return $this->view('leaderboards.index');
    }
	  
	  public function show($slug)
	  {
		  $leaderboard = db()->prepare("SELECT * FROM Leaderboards WHERE serverSlug = ?");
		  $leaderboard->execute([$slug]);
		  $leaderboard = $leaderboard->fetch(PDO::FETCH_ASSOC);
			
			if (!$leaderboard) abort_404();
		  
		  SeoService::set('leaderboards.show', [
				'leaderboard_title' => $leaderboard['serverName'],
		  ]);
			
			$servers = db()->query("SELECT serverName, serverSlug FROM Leaderboards ORDER BY id DESC");
			$servers = $servers->fetchAll(PDO::FETCH_ASSOC);
		  
		  $mysqlTable       = $leaderboard["mysqlTable"];
		  $sorter           = $leaderboard["sorter"];
		  $dataLimit        = $leaderboard["dataLimit"];
		  $usernameColumn   = $leaderboard["usernameColumn"];
		  
		  $tableData          = $leaderboard["tableData"];
		  $tableTitles        = $leaderboard["tableTitles"];
			
		  $leaderboard["tableTitles"] = explode(",", $tableTitles);
		  $leaderboard["tableData"] = explode(",", $tableData);
			
			$search = isset($_GET["search"]) ? get('search') : null;
		  
		  if ($leaderboard["mysqlServer"] == '0') {
				if ($search !== null) {
					$data = db()->prepare("
					    SELECT ranking.*, ranking.rank
					    FROM (
					        SELECT
					            @rank := @rank + 1 AS rank, $usernameColumn, $tableData
					        FROM $mysqlTable, (SELECT @rank := 0) AS t
					        ORDER BY $sorter DESC
					    ) AS ranking
					    WHERE $usernameColumn = ?
					");
					$data->execute([$search]);
				} else {
					$data = db()->prepare("
					    SELECT
					        @rank := @rank + 1 AS rank, $usernameColumn, $tableData
					    FROM $mysqlTable, (SELECT @rank := 0) AS t
					    ORDER BY $sorter DESC
					    LIMIT $dataLimit
					");
					$data->execute();
				}
			  
			  $leaderboard["data"] = $data->fetchAll(PDO::FETCH_ASSOC);
		  }
		  else {
			  try {
				  $newDB = new PDO("mysql:host=".$leaderboard["mysqlServer"]."; port=".$leaderboard["mysqlPort"]."; dbname=".$leaderboard["mysqlDatabase"]."; charset=utf8", $leaderboard["mysqlUsername"], $leaderboard["mysqlPassword"]);
			  }
			  catch (PDOException $e) {
				  die("<strong>MySQL error:</strong> ".utf8_encode($e->getMessage()));
			  }
			  
				if ($search !== null) {
					$data = $newDB->prepare("
					    SELECT ranking.*, ranking.rank
					    FROM (
					        SELECT
					            @rank := @rank + 1 AS rank, $usernameColumn, $tableData
					        FROM $mysqlTable, (SELECT @rank := 0) AS t
					        ORDER BY $sorter DESC
					    ) AS ranking
					    WHERE $usernameColumn = ?
					");
					$data->execute([$search]);
				} else {
					$data = $newDB->prepare("
					    SELECT
					        @rank := @rank + 1 AS rank, $usernameColumn, $tableData
					    FROM $mysqlTable, (SELECT @rank := 0) AS t
					    ORDER BY $sorter DESC
					    LIMIT $dataLimit
					");
					$data->execute();
				}
				
				$leaderboard["data"] = $data->fetchAll(PDO::FETCH_ASSOC);
		  }
			
			return $this->view('leaderboards.show', compact('leaderboard', 'servers'));
	  }
  }