<?php

namespace Main\Controllers;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;

class OrderController extends Controller
{
		protected string $route_type = 'order';
		
    public function show($id)
    {
        $order = db()->prepare("SELECT * FROM Orders WHERE id = ? AND accountID = ?");
        $order->execute([$id, auth()->user()->id()]);
        $order = $order->fetch(PDO::FETCH_ASSOC);

        if (!$order) abort_404();
	    
		    SeoService::set('orders.show', [
			    'order_id' => $order['id'],
		    ]);
	    
        if ($order["type"] == 1) {
            $orderProducts = db()->prepare("SELECT OP.id, P.name, OP.quantity, OP.unitPrice FROM OrderProducts OP INNER JOIN Products P ON OP.productID = P.id WHERE OP.orderID = ?");
            $orderProducts->execute([$id]);
            $order["products"] = array_map(function ($orderProduct) {
							$orderProductVariableValues = db()->prepare("SELECT V.*, OPVV.value FROM OrderProductVariableValues OPVV INNER JOIN StoreVariables V ON V.id = OPVV.variableID  WHERE orderProductID = ?");
							$orderProductVariableValues->execute([$orderProduct["id"]]);
							$orderProduct["variables"] = $orderProductVariableValues->fetchAll(PDO::FETCH_ASSOC);
							
							return $orderProduct;
            }, $orderProducts->fetchAll(PDO::FETCH_ASSOC));
        }
		    if ($order["type"] == 2) {
			    $orderProducts = db()->prepare("SELECT * FROM OrderCredits WHERE orderID = ?");
			    $orderProducts->execute([$id]);
			    $order["product"] = $orderProducts->fetch(PDO::FETCH_ASSOC);
		    }
        if ($order["type"] == 3) {
            $orderProducts = db()->prepare("SELECT CP.* FROM OrderCreditPackages OCP INNER JOIN CreditPackages CP ON OCP.packageID = CP.id WHERE OCP.orderID = ?");
            $orderProducts->execute([$id]);
            $order["products"] = array_map(function ($product) {
								$product["amount"] = ($product["bonus"] > 0) ? $product["amount"] + $product["bonus"] : $product["amount"];
								
								return $product;
						}, $orderProducts->fetchAll(PDO::FETCH_ASSOC));
        }

        return $this->view('orders.show', compact('order'));
    }

    public function success()
    {
        return $this->view('orders.success');
    }

    public function error()
    {
        return $this->view('orders.error');
    }
}