<?php

namespace Main\Controllers;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;
use Pecee\SimpleRouter\Exceptions\NotFoundHttpException;

class PageController extends Controller
{
    public function index($slug)
    {
        $page = db()->prepare("SELECT * FROM Pages WHERE slug = ?");
        $page->execute(array($slug));
        $page = $page->fetch(PDO::FETCH_ASSOC);
				
        if (!$page) abort_404();
				
				SeoService::set('page', [
					'page_title' => $page['title']
				]);

        return $this->view('page', compact('page'));
    }
}