<?php

namespace Main\Controllers;

use Exception;
use Main\Core\Controller;
use Main\Core\Jobs\JobDispatcher;
use Main\Jobs\CreateParasutInvoice;
use Main\Jobs\SendDiscordWebhook;
use Main\Jobs\SendEmail;
use Main\Libs\Payment\Order;
use Main\Libs\Payment\Product;
use Main\Services\DeliveryService;
use Main\Services\EmailService;
use Main\Services\PaymentGatewayService;
use Main\Services\SeoService;
use PDO;

class PaymentController extends Controller
{
    public function success()
    {
	      SeoService::set('payment.success');
				
        return $this->view('payment.success');
    }

    public function error()
    {
	      SeoService::set('payment.error');
			
        return $this->view('payment.error');
    }
	
	/**
	 * @throws Exception
	 */
	public function pay($provider, $orderId)
    {
			/*$order = db()->prepare("SELECT * FROM Orders WHERE id = ? AND accountID = ?");
			$order->execute(array($orderId, auth()->user()->id()));
			$order = $order->fetch();
			
			if (!$order) abort_404();
	    
	    if ($order["status"] == 1) {
		    redirect(url('payment.success'));
	    }
			
			$paymentGateway = db()->prepare("SELECT * FROM PaymentGateways WHERE status = ? AND slug = ?");
	    $paymentGateway->execute(array(1, $provider));
	    $paymentGateway = $paymentGateway->fetch();
			
			if (!$paymentGateway) abort_404();
	    
	    SeoService::set('payment.pay', [
		    'payment_gateway' => $paymentGateway["title"]
	    ]);
			
	    if ($order["type"] == 1) {
		    $orderProducts = db()->prepare("SELECT P.name, OP.quantity, OP.unitPrice FROM OrderProducts OP INNER JOIN Products P ON OP.productID = P.id WHERE OP.orderID = ?");
		    $orderProducts->execute([$order["id"]]);
		    $order["products"] = $orderProducts->fetchAll(PDO::FETCH_ASSOC);
	    }
	    if ($order["type"] == 3) {
		    $orderProducts = db()->prepare("SELECT CP.* FROM OrderCreditPackages OCP INNER JOIN CreditPackages CP ON OCP.packageID = CP.id WHERE OCP.orderID = ?");
		    $orderProducts->execute([$order["id"]]);
		    $order["products"] = array_map(function ($product) {
			    $product["amount"] = ($product["bonus"] > 0) ? $product["amount"] + $product["bonus"] : $product["amount"];
			    
			    return $product;
		    }, $orderProducts->fetchAll(PDO::FETCH_ASSOC));
	    }
			
			// Create Customer Object
	    $userContact = db()->prepare("SELECT * FROM AccountContactInfo WHERE accountID = ?");
	    $userContact->execute([auth()->user()->id()]);
			$userContact = $userContact->fetch();
			if (!$userContact) redirect(url('account.contact.edit'));
      $customer = new Customer(
				auth()->user()->id(),
				auth()->user()->email(),
	      $userContact["firstName"],
				$userContact["lastName"],
				$userContact["phoneNumber"],
	      getIP(),
      );
			
			// Create Order Object
	    $products = [];
	    foreach ($order["products"] as $product) {
		    $products[] = new Product($product["name"], $product["unitPrice"]);
	    }
			$orderObject = new Order(
				$order["id"],
				$order["type"] == 1 ? "product" : "credit",
				$order["total"],
				$order["subtotal"],
				$order["tax"],
				$order["gatewayFee"],
				$order["discount"],
				$order["credit"],
				$products
			);
			
			try {
				$payment = PaymentGatewayService::init($paymentGateway["slug"], $paymentGateway["currency"], $paymentGateway["config"]);
				$payment->pay($customer, $orderObject);
			} catch (Exception $e) {
				if (settings('debugModeStatus') == 1) {
					return $e->getMessage();
				} else {
					return $this->view('payment.error');
				}
			}*/
    }
	
	/**
	 * @throws Exception
	 */
	public function payManual($orderId)
    {
		    $paymentGateway = db()->prepare("SELECT * FROM PaymentGateways WHERE status = ? AND slug = ?");
		    $paymentGateway->execute(array(1, "manual"));
		    $paymentGateway = $paymentGateway->fetch();

        if (!$paymentGateway) abort_404();
	    
        $order = db()->prepare("SELECT * FROM Orders WHERE id = ? AND accountID = ?");
		    $order->execute(array($orderId, auth()->user()->id()));
		    $order = $order->fetch();

        if (!$order) abort_404();
				
        if ($order["status"] == 1) {
	        redirect(url('payment.success'));
        }
				
		    SeoService::set('payment.pay', [
			    'payment_gateway' => $paymentGateway["title"]
		    ]);
	    
	      $paymentGateway["config"] = PaymentGatewayService::parseConfig($paymentGateway["config"]);
	    
	      $paymentGateway["message"] = str_replace(
			    [
				    '{order_id}',
				    '{price}',
			    ],
			    [
				    $order["id"],
				    money()->real($order["total"] - $order["credit"]),
			    ],
			    $paymentGateway["config"]["content"]
		    );

        return $this->view('payment.manual', compact('paymentGateway'));
    }

    public function callback($provider)
    {
	    $paymentGateway = db()->prepare("SELECT * FROM PaymentGateways WHERE slug = ?");
	    $paymentGateway->execute(array($provider));
	    $paymentGateway = $paymentGateway->fetch();
	    
	    if (!$paymentGateway) abort_404();
			
			// if provider is not manual and payment gateway is not active then abort
			if ($provider != "manual" && $paymentGateway["status"] == 0) abort_404();
			
	    try {
		    $payment = PaymentGatewayService::init($paymentGateway["slug"], $paymentGateway["currency"], $paymentGateway["config"]);
		    $data =  $payment->callback();
				
				$orderID = $data->getOrderID();
				$paymentID = $data->getPaymentID();
				
				// Process the payment
		    $orders = db()->prepare("SELECT O.*, A.username, A.realname, A.email as accountEmail, A.credit as accountCredit FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID WHERE O.status = ? AND O.id = ? AND O.paymentID != ?");
		    $orders->execute(array(0, $orderID, $paymentID));
		    $readOrder = $orders->fetch();
		    if ($orders->rowCount() > 0) {
					// Check credits
			    if ($readOrder["credit"] > 0 && $readOrder["credit"] > $readOrder["accountCredit"]) {
				    throw new Exception("Not enough credits!");
			    }
					
			    // Update Order Status
			    $updateOrder = db()->prepare("UPDATE Orders SET status = ?, paymentID = ? WHERE id = ?");
			    $updateOrder->execute(array(1, $paymentID, $readOrder["id"]));
			    
			    // Update community goal
			    if (modules('store')->settings('communityGoalStatus') == '1') {
				    $newCommunityGoalValue = modules('store')->settings('communityGoalCurrent') + $readOrder["earnings"];
				    if ($newCommunityGoalValue >= modules('store')->settings('communityGoalTarget')) {
					    $newCommunityGoalValue = 0;
					    if (modules('store')->settings('communityGoalRepeat') == '0') {
								modules('store')->updateSetting('communityGoalStatus', '0');
					    }
				    }
						modules('store')->updateSetting('communityGoalCurrent', $newCommunityGoalValue);
			    }
			    
			    // Checkout
			    if ($readOrder["type"] == 1) {
				    // Only pay with credit requirement
				    if (modules('store')->settings('isCreditRequiredOnPurchase') == 1) {
					    throw new Exception("You can not buy this product without credit!");
				    }
				    
				    $orderProducts = db()->prepare("SELECT OP.id as orderProductID, OP.quantity, OP.unitPrice, C.name as categoryName, C.isCumulative, P.* FROM OrderProducts OP INNER JOIN Products P ON P.id = OP.productID INNER JOIN ProductCategories C ON P.categoryID = C.id WHERE OP.orderID = ?");
				    $orderProducts->execute(array($readOrder["id"]));
				    $orderProducts = array_map(function ($orderProduct) {
					    $orderProductVariableValues = db()->prepare("SELECT V.*, OPVV.value FROM OrderProductVariableValues OPVV INNER JOIN StoreVariables V ON V.id = OPVV.variableID  WHERE orderProductID = ?");
					    $orderProductVariableValues->execute([$orderProduct["orderProductID"]]);
					    $orderProduct["variables"] = $orderProductVariableValues->fetchAll(PDO::FETCH_ASSOC);
					    
					    return $orderProduct;
				    }, $orderProducts->fetchAll(PDO::FETCH_ASSOC));
				    
				    if ($readOrder["credit"] > 0) {
					    $updateCredit = db()->prepare("UPDATE Accounts SET credit = credit - ? WHERE id = ?");
					    $updateCredit->execute(array($readOrder["credit"], $readOrder["accountID"]));
					    $insertCreditHistory = db()->prepare("INSERT INTO CreditHistory (accountID, type, price, creationDate) VALUES (?, ?, ?, ?)");
					    $insertCreditHistory->execute(array($readOrder["accountID"], 2, $readOrder["credit"], datetime()));
				    }
				    if ($readOrder["cashback"] > 0) {
					    $updateCredit = db()->prepare("UPDATE Accounts SET credit = credit + ? WHERE id = ?");
					    $updateCredit->execute(array($readOrder["cashback"], $readOrder["accountID"]));
					    $insertCreditHistory = db()->prepare("INSERT INTO CreditHistory (accountID, type, price, creationDate) VALUES (?, ?, ?, ?)");
					    $insertCreditHistory->execute(array($readOrder["accountID"], 1, $readOrder["cashback"], datetime()));
				    }
				    if ($readOrder["coupon"] != null) {
					    $coupon = db()->prepare("SELECT * FROM ProductCoupons WHERE name = ?");
					    $coupon->execute(array($readOrder["coupon"]));
					    $readCoupon = $coupon->fetch();
					    if ($coupon->rowCount() > 0) {
						    $couponID = $readCoupon["id"];
						    $insertProductCouponsHistory = db()->prepare("INSERT INTO ProductCouponsHistory (accountID, couponID, productID, creationDate) VALUES (?, ?, ?, ?)");
						    $insertProductCouponsHistory->execute(array($readOrder["accountID"], $couponID, $orderID, datetime()));
					    }
				    }
				    
				    // Add revenue share to the creator
				    $creatorCode = db()->prepare("SELECT OCC.revenueShare, CC.creatorID FROM OrderCreatorCodes OCC INNER JOIN CreatorCodes CC ON CC.id = OCC.codeID WHERE OCC.orderID = ? AND CC.creatorID != ?");
				    $creatorCode->execute(array($readOrder["id"], $readOrder["accountID"]));
				    $creatorCode = $creatorCode->fetch(PDO::FETCH_ASSOC);
				    if ($creatorCode) {
					    $creatorCodeAccount = db()->prepare("SELECT * FROM Accounts WHERE id = ?");
					    $creatorCodeAccount->execute(array($creatorCode["creatorID"]));
					    $creatorCodeAccount = $creatorCodeAccount->fetch(PDO::FETCH_ASSOC);
					    
					    if ($creatorCodeAccount) {
						    $updateCreatorCodeAccount = db()->prepare("UPDATE Accounts SET credit = credit + ? WHERE id = ?");
						    $updateCreatorCodeAccount->execute(array($creatorCode["revenueShare"], $creatorCode["creatorID"]));
						    $insertCreditHistory = db()->prepare("INSERT INTO CreditHistory (accountID, type, price, creationDate) VALUES (?, ?, ?, ?)");
						    $insertCreditHistory->execute(array($creatorCode["creatorID"], 1, $creatorCode["revenueShare"], datetime()));
					    }
				    }
				    
				    foreach ($orderProducts as $orderProduct) {
					    if (modules('chest')->isActive()) {
						    $canGift = true;
						    if ($orderProduct["isCumulative"] == '1') {
							    $subs = db()->prepare("SELECT * FROM Subscriptions S INNER JOIN Products P ON P.id = S.productID WHERE P.categoryID = ? AND accountID = ? AND (endsAt > ? OR endsAt = '1000-01-01 00:00:00') ORDER BY P.priority ASC LIMIT 1");
							    $subs->execute(array($orderProduct["categoryID"], $readOrder["accountID"], datetime()));
							    $subs = $subs->fetch(PDO::FETCH_ASSOC);
							    if ($subs) {
								    // Is upgrade
								    if ($subs["priority"] > $orderProduct["priority"])
									    $canGift = false;
							    }
						    }
						    
						    for ($i = 0; $i < $orderProduct["quantity"]; $i++) {
							    $insertChests = db()->prepare("INSERT INTO Chests (accountID, productID, canGift, status, creationDate) VALUES (?, ?, ?, ?, ?)");
							    $insertChests->execute(array($readOrder["accountID"], $orderProduct["id"], ($canGift ? '1' : '0'), 0, datetime()));
							    $chestID = db()->lastInsertId();
							    
							    $insertChestProductVariableValues = db()->prepare("INSERT INTO ChestProductVariableValues (chestID, variableID, value) VALUES (?, ?, ?)");
							    foreach ($orderProduct["variables"] as $variable) {
								    $insertChestProductVariableValues->execute(array($chestID, $variable["id"], $variable["value"]));
							    }
						    }
					    }
					    
					    if ($orderProduct["stock"] != -1) {
						    $updateStock = db()->prepare("UPDATE Products SET stock = stock - ? WHERE id = ?");
						    $updateStock->execute(array($orderProduct["quantity"], $orderProduct["id"]));
					    }
				    }
				    
				    if (!modules('chest')->isActive()) {
					    $orderProductsForDelivery = [];
					    foreach ($orderProducts as $orderProduct) {
						    $variablesForDelivery = [];
						    foreach ($orderProduct["variables"] as $variable) {
							    $variablesForDelivery[$variable["identifier"]] = $variable["value"];
						    }
						    
						    $orderProductsForDelivery[] = [
							    'id' => $orderProduct["id"],
							    'quantity' => $orderProduct["quantity"],
							    'variables' => $variablesForDelivery,
						    ];
					    }
					    DeliveryService::deliver($orderProductsForDelivery, $readOrder["accountID"], "order", $orderID);
				    }
				    
				    $deleteShoppingCartProducts = db()->prepare("DELETE FROM ShoppingCartProducts WHERE shoppingCartID = ?");
				    $deleteShoppingCartProducts->execute(array($readOrder["accountID"]));
				    
				    if (modules('store')->settings('sendEmailOnPurchase') != '0') {
					    $orderProductsArray = [];
					    foreach ($orderProducts as $orderProduct) {
						    $orderProductsArray[] = new Product($orderProduct["name"], $orderProduct["unitPrice"], $orderProduct["quantity"]);
					    }
					    $orderObject = new Order(
						    $readOrder["id"],
						    "product",
						    $readOrder["total"],
						    $readOrder["subtotal"],
						    $readOrder["tax"],
						    $readOrder["gatewayFee"],
						    $readOrder["discount"],
						    $readOrder["credit"],
						    $readOrder["coupon"],
						    $orderProductsArray
					    );
					    JobDispatcher::dispatch((new SendEmail(
						    $readOrder["accountEmail"],
						    modules('store')->settings('purchaseEmailTitle'),
						    EmailService::processPurchaseEmailContent($readOrder["realname"], $orderObject)
					    )));
				    }
				    
				    foreach ($orderProducts as $orderProduct) {
					    JobDispatcher::dispatch((new SendDiscordWebhook('store.purchase.product', [
						    "username" => $readOrder["realname"],
						    "product" => $orderProduct["name"],
						    "category" => $orderProduct["categoryName"],
						    "quantity" => $orderProduct["quantity"],
						    "price" => $orderProduct["unitPrice"],
						    "currency" => settings('currency'),
					    ])));
				    }
			    }
			    
			    // Credit
			    if ($readOrder["type"] == 2 || $readOrder["type"] == 3) {
				    $credit = 0;
				    $productName = "";
				    $productPrice = 0;
				    $earnings = $readOrder["earnings"];
				    if (modules('credit')->settings('creditPackageStatus') == 0) {
					    $orderCredits = db()->prepare("SELECT * FROM OrderCredits WHERE orderID = ?");
					    $orderCredits->execute(array($readOrder["id"]));
					    if ($orderCredits->rowCount() > 0) {
						    $readOrderCredits = $orderCredits->fetch();
						    $credit = $readOrderCredits["amount"];
						    $productName = money()->credits($credit);
						    $productPrice = $earnings;
					    }
					    else {
						    throw new Exception("Credit Order not found!");
					    }
				    }
				    else {
					    $orderCreditPackage = db()->prepare("SELECT * FROM OrderCreditPackages WHERE orderID = ?");
					    $orderCreditPackage->execute(array($readOrder["id"]));
					    if ($orderCreditPackage->rowCount() > 0) {
						    $readOrderCreditPackage = $orderCreditPackage->fetch();
						    $creditPackage = db()->prepare("SELECT * FROM CreditPackages WHERE id = ?");
						    $creditPackage->execute(array($readOrderCreditPackage["packageID"]));
						    $readCreditPackage = $creditPackage->fetch();
						    if ($creditPackage->rowCount() > 0) {
							    $credit = $readCreditPackage["amount"] + $readCreditPackage["bonus"];
							    
							    if ($readCreditPackage["stock"] != -1) {
								    $updateCreditPackage = db()->prepare("UPDATE CreditPackages SET stock = stock - ? WHERE id = ?");
								    $updateCreditPackage->execute(array(1, $readCreditPackage["id"]));
							    }
							    
							    $productName = $readCreditPackage["name"];
							    $productPrice = ($readCreditPackage["discountedPrice"] > 0 && $readCreditPackage["discountExpiryDate"] > datetime()) ? $readCreditPackage["discountedPrice"] : $readCreditPackage["price"];
						    }
						    else {
							    throw new Exception("Credit package not found!");
						    }
					    }
					    else {
						    throw new Exception("Credit Order not found!");
					    }
				    }
				    
				    $insertCreditHistory = db()->prepare("INSERT INTO CreditHistory (accountID, type, price, creationDate) VALUES (?, ?, ?, ?)");
				    $insertCreditHistory->execute(array($readOrder["accountID"], 1, $credit, datetime()));
				    
				    $insertNotifications = db()->prepare("INSERT INTO Notifications (accountID, type, variables, creationDate) VALUES (?, ?, ?, ?)");
				    $insertNotifications->execute(array($readOrder["accountID"], 3, $earnings, datetime()));
				    
				    $updateAccounts = db()->prepare("UPDATE Accounts SET credit = credit + ? WHERE id = ?");
				    $updateAccounts->execute(array($credit, $readOrder["accountID"]));
						
				    JobDispatcher::dispatch((new SendDiscordWebhook('store.purchase.credit', [
					    "username" => $readOrder["realname"],
					    "credit" => $credit,
					    "currency" => settings('currency'),
				    ])));
						
				    
				    if (modules('store')->settings('sendEmailOnPurchase') != '0') {
							$orderObject = new Order(
								$readOrder["id"],
								"credit",
								$readOrder["total"],
								$readOrder["subtotal"],
								$readOrder["tax"],
								$readOrder["gatewayFee"],
								$readOrder["discount"],
								$readOrder["credit"],
								$readOrder["coupon"],
							[
								new Product($productName, $productPrice)
							]
							);
					    JobDispatcher::dispatch((new SendEmail(
						    $readOrder["accountEmail"],
						    modules('store')->settings('purchaseEmailTitle'),
						    EmailService::processPurchaseEmailContent($readOrder["realname"], $orderObject)
					    )));
				    }
			    }
			    
			    // Parasut
			    if (modules('parasut')->isActive()) {
						JobDispatcher::dispatch((new CreateParasutInvoice($readOrder["id"])));
			    }
					
			    if ($payment->isBrowserSideCallback()) {
				    redirect($payment->getSuccessUrl());
			    }
		    }
		    else {
			    throw new Exception("Order not found!");
		    }
	    } catch (Exception $e) {
		    if (settings('debugModeStatus') == 1) {
			    return $e->getMessage();
		    }
	    }
	    return "OK";
    }
}