<?php

namespace Main\Controllers;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;

class PunishmentController extends Controller
{
		protected string $route_type = 'punishments';
		
		private $pluginDB;
		private $result;
		private $plugin;
		
		public function __construct()
		{
			$plugin = modules('punishments')->settings('plugin');
			$result = true;
			$tableName = $plugin == "litebans" ? "litebans_bans" : "PunishmentHistory";
			try {
				if (modules('punishments')->settings('mysqlHost') != "") {
					$pluginDB = new PDO("mysql:host=" . modules('punishments')->settings('mysqlHost') . ";port=" . modules('punishments')->settings('mysqlPort') . ";dbname=" . modules('punishments')->settings('mysqlDatabase') . ";charset=utf8", modules('punishments')->settings('mysqlUsername'), modules('punishments')->settings('mysqlPassword'));
				} else {
					$pluginDB = db();
				}
				$result = $pluginDB->query("SELECT 1 FROM $tableName LIMIT 1");
			} catch (Exception $e) {
				$result = false;
			}
			
			$this->pluginDB = $pluginDB;
			$this->result = $result;
			$this->plugin = $plugin;
		}
	
    public function index()
    {
	      SeoService::set('punishments.index');
				
				$result = $this->result;
        return $this->view('punishments.index', compact('result'));
    }

    public function bans()
    {
	      SeoService::set('punishments.bans');
			
	      $result = $this->result;
				$pluginDB = $this->pluginDB;
	      $plugin = $this->plugin;

        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval($_GET["page"]);
        } else {
            $page = 1;
        }

        if ($plugin == "litebans") {
            $bans = $pluginDB->query("SELECT COUNT(id) FROM litebans_bans");
        } else {
            $bans = $pluginDB->query("SELECT COUNT(id) FROM PunishmentHistory WHERE punishmentType IN ('BAN', 'TEMP_BAN')");
        }
        $itemsCount = $bans->fetchColumn();

        $visiblePageCount = 5;
        $limit = 20;

        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;

        if (get("search")) {
	          $page = 1;
	          $pageCount = 1;
            if ($plugin == "litebans") {
								$bans = $pluginDB->prepare("SELECT DISTINCT B.id, H.name as banned_name, B.reason, B.banned_by_name, B.removed_by_name, B.time, B.until FROM litebans_bans B INNER JOIN litebans_history H ON B.uuid = H.uuid WHERE H.name = :search ORDER BY B.id DESC LIMIT 50");
            } else {
                $bans = $pluginDB->prepare("SELECT id, name as banned_name, reason, operator as banned_by_name, start as time, end as until FROM PunishmentHistory WHERE punishmentType IN ('BAN', 'TEMP_BAN') AND name = :search ORDER BY id DESC LIMIT 50");
            }
            $bans->execute(array(
                "search" => get("search")
            ));
        } else {
            if ($plugin == "litebans") {
	              $bans = $pluginDB->query("SELECT DISTINCT B.id, H.name AS banned_name, B.reason, B.banned_by_name, B.removed_by_name, B.time, B.until FROM (SELECT id, uuid, reason, banned_by_name, removed_by_name, time, until FROM litebans_bans ORDER BY id DESC LIMIT $visibleItemsCount, $limit) AS B INNER JOIN litebans_history H ON B.uuid = H.uuid");
            } else {
                $bans = $pluginDB->query("SELECT id, name as banned_name, reason, operator as banned_by_name, start as time, end as until FROM PunishmentHistory WHERE punishmentType IN ('BAN', 'TEMP_BAN') ORDER BY id DESC LIMIT $visibleItemsCount, $limit");
            }
        }
        $bans = $bans->fetchAll();

        return $this->view('punishments.bans', compact('result', 'bans', 'page', 'pageCount'));
    }

    public function mutes()
    {
	      SeoService::set('punishments.mutes');
			
		    $result = $this->result;
		    $pluginDB = $this->pluginDB;
	      $plugin = $this->plugin;

        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval($_GET["page"]);
        } else {
            $page = 1;
        }

        if ($plugin == "litebans") {
            $mutes = $pluginDB->query("SELECT COUNT(id) FROM litebans_mutes");
        } else {
            $mutes = $pluginDB->query("SELECT COUNT(id) FROM PunishmentHistory WHERE punishmentType IN ('MUTE', 'TEMP_MUTE')");
        }
        $itemsCount = $mutes->fetchColumn();

        $visiblePageCount = 5;
        $limit = 20;

        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;

        if (get("search")) {
		        $page = 1;
		        $pageCount = 1;
            if ($plugin == "litebans") {
	              $mutes = $pluginDB->prepare("SELECT DISTINCT M.id, H.name as banned_name, M.reason, M.banned_by_name, M.removed_by_name, M.time, M.until FROM litebans_mutes M INNER JOIN litebans_history H ON M.uuid = H.uuid WHERE H.name = :search ORDER BY M.id DESC LIMIT 50");
            } else {
                $mutes = $pluginDB->prepare("SELECT id, name as banned_name, reason, operator as banned_by_name, start as time, end as until FROM PunishmentHistory WHERE punishmentType IN ('MUTE', 'TEMP_MUTE') AND name = :search ORDER BY id DESC LIMIT 50");
            }
            $mutes->execute(array(
                "search" => get("search")
            ));
        } else {
            if ($plugin == "litebans") {
	              $mutes = $pluginDB->query("SELECT DISTINCT M.id, H.name AS banned_name, M.reason, M.banned_by_name, M.removed_by_name, M.time, M.until FROM (SELECT id, uuid, reason, banned_by_name, removed_by_name, time, until FROM litebans_mutes ORDER BY id DESC LIMIT $visibleItemsCount, $limit) AS M INNER JOIN litebans_history H ON M.uuid = H.uuid");
            } else {
                $mutes = $pluginDB->query("SELECT id, name as banned_name, reason, operator as banned_by_name, start as time, end as until FROM PunishmentHistory WHERE punishmentType IN ('MUTE', 'TEMP_MUTE') ORDER BY id DESC LIMIT $visibleItemsCount, $limit");
            }
        }
        $mutes = $mutes->fetchAll();

        return $this->view('punishments.mutes', compact('result', 'mutes', 'page', 'pageCount'));
    }

    public function kicks()
    {
	      SeoService::set('punishments.kicks');
				
		    $result = $this->result;
		    $pluginDB = $this->pluginDB;
	      $plugin = $this->plugin;
	    
		    if (isset($_GET["page"])) {
			    if (!is_numeric($_GET["page"])) {
				    $_GET["page"] = 1;
			    }
			    $page = intval($_GET["page"]);
		    } else {
			    $page = 1;
		    }

        if ($plugin == "litebans") {
            $kicks = $pluginDB->query("SELECT COUNT(id) FROM litebans_kicks");
        } else {
            $kicks = $pluginDB->query("SELECT COUNT(id) FROM PunishmentHistory WHERE punishmentType IN ('KICK')");
        }
        $itemsCount = $kicks->fetchColumn();

        $visiblePageCount = 5;
        $limit = 20;

        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;

        if (get("search")) {
		        $page = 1;
		        $pageCount = 1;
            if ($plugin == "litebans") {
	              $kicks = $pluginDB->prepare("SELECT DISTINCT K.id, H.name as banned_name, K.reason, K.banned_by_name, K.time FROM litebans_kicks K INNER JOIN litebans_history H ON K.uuid = H.uuid WHERE H.name = :search ORDER BY K.id DESC LIMIT 50");
            } else {
                $kicks = $pluginDB->prepare("SELECT id, name as banned_name, reason, operator as banned_by_name, start as time, end as until FROM PunishmentHistory WHERE punishmentType IN ('KICK') AND name = :search ORDER BY id DESC LIMIT 50");
            }
            $kicks->execute(array(
                "search" => get("search")
            ));
        } else {
            if ($plugin == "litebans") {
	              $kicks = $pluginDB->query("SELECT DISTINCT K.id, H.name AS banned_name, K.reason, K.banned_by_name, K.time FROM (SELECT id, uuid, reason, banned_by_name, time FROM litebans_kicks ORDER BY id DESC LIMIT $visibleItemsCount, $limit) AS K INNER JOIN litebans_history H ON K.uuid = H.uuid");
            } else {
                $kicks = $pluginDB->query("SELECT id, name as banned_name, reason, operator as banned_by_name, start as time, end as until FROM PunishmentHistory WHERE punishmentType IN ('KICK') ORDER BY id DESC LIMIT $visibleItemsCount, $limit");
            }
        }
        $kicks = $kicks->fetchAll();

        return $this->view('punishments.kicks', compact('result', 'kicks', 'page', 'pageCount'));
    }

    public function warnings()
    {
				SeoService::set('punishments.warnings');
				
		    $result = $this->result;
		    $pluginDB = $this->pluginDB;
	      $plugin = $this->plugin;

        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval($_GET["page"]);
        } else {
            $page = 1;
        }

        if ($plugin == "litebans") {
            $warnings = $pluginDB->query("SELECT COUNT(id) FROM litebans_warnings");
        } else {
            $warnings = $pluginDB->query("SELECT COUNT(id) FROM PunishmentHistory WHERE punishmentType IN ('WARNING')");
        }
        $itemsCount = $warnings->fetchColumn();

        $visiblePageCount = 5;
        $limit = 20;

        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;

        if (get("search")) {
		        $page = 1;
		        $pageCount = 1;
            if ($plugin == "litebans") {
	              $warnings = $pluginDB->prepare("SELECT DISTINCT W.id, H.name as banned_name, W.reason, W.banned_by_name, W.time FROM litebans_warnings W INNER JOIN litebans_history H ON W.uuid = H.uuid WHERE H.name = :search ORDER BY W.id DESC LIMIT 50");
            } else {
                $warnings = $pluginDB->prepare("SELECT id, name as banned_name, reason, operator as banned_by_name, start as time, end as until FROM PunishmentHistory WHERE punishmentType IN ('WARNING') AND name = :search ORDER BY id DESC LIMIT 50");
            }
            $warnings->execute(array(
                "search" => get("search")
            ));
        } else {
            if ($plugin == "litebans") {
	              $warnings = $pluginDB->query("SELECT DISTINCT W.id, H.name AS banned_name, W.reason, W.banned_by_name, W.time FROM (SELECT id, uuid, reason, banned_by_name, time FROM litebans_warnings ORDER BY id DESC LIMIT $visibleItemsCount, $limit) AS W INNER JOIN litebans_history H ON W.uuid = H.uuid");
            } else {
                $warnings = $pluginDB->query("SELECT id, name as banned_name, reason, operator as banned_by_name, start as time, end as until FROM PunishmentHistory WHERE punishmentType IN ('WARNING') ORDER BY id DESC LIMIT $visibleItemsCount, $limit");
            }
        }
        $warnings = $warnings->fetchAll();

        return $this->view('punishments.warnings', compact('result', 'warnings', 'page', 'pageCount'));
    }
}