<?php

namespace Main\Controllers;

use Main\Core\Controller;
use Main\Services\AvatarService;
use Main\Services\SeoService;
use PDO;

class StaffController extends Controller
{
	protected string $route_type = 'staff';
	
	public function index()
    {
	      SeoService::set('staff');
				
        $viewDashboardPerm = db()->prepare("SELECT id FROM Permissions WHERE name = ?");
        $viewDashboardPerm->execute(array('VIEW_DASHBOARD'));
        $viewDashboardPerm = $viewDashboardPerm->fetch();

        $superAdminPerm = db()->prepare("SELECT id FROM Permissions WHERE name = ?");
        $superAdminPerm->execute(array('SUPER_ADMIN'));
        $superAdminPerm = $superAdminPerm->fetch();
	    
		    $staff = db()->prepare("SELECT DISTINCT A.id, A.username, A.realname, R.name as roleName FROM AccountRoles AR INNER JOIN Accounts A ON AR.accountID = A.id INNER JOIN Roles R ON R.id = AR.roleID INNER JOIN RolePermissions RP ON RP.roleID = R.id WHERE RP.permissionID IN (:viewperm, :superperm) ORDER BY R.priority DESC");
		    $staff->execute(array(
	            "viewperm" => $viewDashboardPerm["id"],
	            "superperm" => $superAdminPerm["id"]
	        ));
		    $staff = $staff->fetchAll(PDO::FETCH_ASSOC);

        $roles = [];
        foreach ($staff as $staffUser) {
            $roles[$staffUser["roleName"]][] = [
								'id' => $staffUser["id"],
                'username' => $staffUser["username"],
                'displayName' => $staffUser["realname"],
	              'avatar' => AvatarService::get($staffUser["id"], $staffUser["realname"])
            ];
        }

        return $this->view('staff', compact('roles'));
    }
}